/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.State;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

class RequestFactoryScanner
extends ScannerBase<Void> {
    private TypeElement checkedElement;

    RequestFactoryScanner() {
    }

    @Override
    public Void visitExecutable(ExecutableElement x, State state) {
        ExecutableType xType;
        TypeMirror returnType;
        if (this.shouldIgnore(x, state)) {
            return null;
        }
        if (!x.getParameters().isEmpty()) {
            state.poison(x, Messages.factoryNoMethodParameters());
        }
        if (state.types.isAssignable(returnType = (xType = RequestFactoryScanner.viewIn(this.checkedElement, x, state)).getReturnType(), state.requestContextType)) {
            Element returnTypeElement = state.types.asElement(returnType);
            if (!returnTypeElement.getKind().equals((Object)ElementKind.INTERFACE)) {
                state.poison(x, Messages.factoryMustReturnInterface(returnTypeElement.getSimpleName()));
            } else {
                TypeElement contextElement = (TypeElement)returnTypeElement;
                state.maybeScanContext(contextElement);
                state.requireMapping(contextElement);
            }
        } else {
            state.poison(x, Messages.factoryMustBeAssignable(state.requestContextType.asElement().getSimpleName()));
        }
        return null;
    }

    @Override
    public Void visitType(TypeElement x, State state) {
        if (state.types.isSameType(state.requestFactoryType, x.asType())) {
            return null;
        }
        this.checkedElement = x;
        this.scanAllInheritedMethods(x, state);
        state.checkExtraTypes(x);
        return null;
    }
}

