/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TeeWriter<W extends Writer>
extends FilterWriter {
    private W tee;
    private boolean written;

    public TeeWriter(Writer out, W tee) {
        super(out);
        this.tee = tee;
        this.written = false;
    }

    public W getOtherWriter() {
        return this.tee;
    }

    public void setOtherWriter(W tee) {
        if (this.written) {
            throw new IllegalStateException("Data was already written to this writer");
        }
        if (this.getOtherWriter() != null) {
            throw new IllegalStateException("A \"tee\" writer has already been provided and cannot be replaced");
        }
        this.tee = tee;
    }

    @Override
    public void write(int c) throws IOException {
        this.written = true;
        super.write(c);
        if (this.tee != null) {
            ((Writer)this.tee).write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.written = true;
        super.write(cbuf, off, len);
        if (this.tee != null) {
            ((Writer)this.tee).write(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.written = true;
        super.write(str, off, len);
        if (this.tee != null) {
            ((Writer)this.tee).write(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.tee != null) {
            ((Writer)this.tee).flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.tee != null) {
            ((Writer)this.tee).close();
        }
    }
}

