/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.jakarta.AbstractRemoteServiceServlet;
import com.google.gwt.user.server.rpc.jakarta.RPC;
import com.google.gwt.user.server.rpc.jakarta.RPCServletUtils;
import com.google.gwt.user.server.rpc.jakarta.SerializationPolicyClient;
import com.google.gwt.user.server.rpc.jakarta.TeeWriter;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class RemoteServiceServlet
extends AbstractRemoteServiceServlet
implements SerializationPolicyProvider {
    private static final SerializationPolicyClient CODE_SERVER_CLIENT = new SerializationPolicyClient(5000, 5000);
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();
    private final Object delegate;
    private int codeServerPort = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SerializationPolicy loadSerializationPolicy(HttpServlet servlet, HttpServletRequest request, String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy;
        block18: {
            String contextPath = request.getContextPath();
            String modulePath = null;
            if (moduleBaseURL != null) {
                try {
                    modulePath = new URL(moduleBaseURL).getPath();
                }
                catch (MalformedURLException ex) {
                    servlet.log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
                }
            }
            serializationPolicy = null;
            if (modulePath == null || !modulePath.startsWith(contextPath)) {
                String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
                servlet.log(message);
            } else {
                String contextRelativePath = modulePath.substring(contextPath.length());
                String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
                InputStream is = servlet.getServletContext().getResourceAsStream(serializationPolicyFilePath);
                try {
                    if (is != null) {
                        try {
                            serializationPolicy = SerializationPolicyLoader.loadFromStream(is, null);
                            if (!serializationPolicy.hasClientFields()) break block18;
                            if (SerializationPolicyLoader.ENABLE_ENHANCED_CLASSES) {
                                servlet.log("WARNING: Service deserializes enhanced JPA/JDO classes, which is unsafe. See https://github.com/gwtproject/gwt/issues/9709 for more detail on the vulnerability that this presents.");
                                break block18;
                            }
                            servlet.log("ERROR: Service deserializes enhanced JPA/JDO classes, which is unsafe. Review build logs to see which classes are affected, or set gwt.enhancedClasses.enabled to true to allow using this service. See https://github.com/gwtproject/gwt/issues/9709 for more detail.");
                            serializationPolicy = null;
                        }
                        catch (ParseException e) {
                            servlet.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                        }
                        catch (IOException e) {
                            servlet.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                        }
                        break block18;
                    }
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    servlet.log(message);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return serializationPolicy;
    }

    public RemoteServiceServlet() {
        this.delegate = this;
    }

    public RemoteServiceServlet(Object delegate) {
        this.delegate = delegate;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.codeServerPort = this.getCodeServerPort();
    }

    private int getCodeServerPort() throws ServletException {
        String value = System.getProperty("gwt.codeserver.port");
        if (value == null) {
            return 0;
        }
        try {
            int port = Integer.parseInt(value);
            if (port >= 0 && port < 65536) {
                return port;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ServletException("Invalid value of gwt.codeserver.port system property; expected an integer in the range [1-65535] but got: " + value);
    }

    protected String getRequestModuleBasePath() {
        try {
            String contextPath;
            String header = this.getThreadLocalRequest().getHeader("X-GWT-Module-Base");
            if (header == null) {
                return null;
            }
            String path = new URL(header).getPath();
            if (!path.startsWith(contextPath = this.getThreadLocalRequest().getContextPath())) {
                return null;
            }
            return path.substring(contextPath.length());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        String url;
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null && (url = this.getCodeServerPolicyUrl(strongName)) != null) {
            serializationPolicy = this.loadPolicyFromCodeServer(url);
        }
        if (serializationPolicy == null) {
            this.log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.");
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        RPCRequest rpcRequest;
        this.checkPermutationStrongName();
        try {
            rpcRequest = RPC.decodeRequest(payload, this.delegate.getClass(), this);
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailedRequest(null, ex);
        }
        return this.processCall(rpcRequest);
    }

    public String processCall(RPCRequest rpcRequest) throws SerializationException {
        try {
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse(this.delegate, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy(), rpcRequest.getFlags());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailedRequest(rpcRequest, ex);
        }
        catch (RpcTokenException tokenException) {
            this.log("An RpcTokenException was thrown while processing this call.", tokenException);
            return RPC.encodeResponseForFailedRequest(rpcRequest, tokenException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, SerializationException {
        String requestPayload = this.readContent(request);
        this.onBeforeRequestDeserialized(requestPayload);
        Writer responseWriter = this.createWriterForResponse(request, response);
        boolean onAfterResponseSerializedOverridden = this.isOnAfterResponseSerializedOverridden();
        StringWriter writerForResponseCopy = onAfterResponseSerializedOverridden ? new StringWriter() : null;
        TeeWriter<StringWriter> writer = new TeeWriter<StringWriter>(responseWriter, writerForResponseCopy);
        RPC.setResponseWriter(writer);
        try {
            String responsePayload = this.processCall(requestPayload);
            if (onAfterResponseSerializedOverridden) {
                this.onAfterResponseSerialized(responsePayload != null ? responsePayload : writerForResponseCopy.toString());
            }
        }
        finally {
            RPC.unsetResponseWriter();
        }
    }

    private boolean isOnAfterResponseSerializedOverridden() {
        try {
            boolean foundOverride = false;
            for (Class<?> c = this.getClass(); !foundOverride && c != RemoteServiceServlet.class; c = c.getSuperclass()) {
                try {
                    Method m = c.getDeclaredMethod("onAfterResponseSerialized", String.class);
                    foundOverride = m != null;
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return foundOverride;
        }
        catch (SecurityException e) {
            throw new RuntimeException("Couldn't find onAfterResponseSerialized method", e);
        }
    }

    protected void checkPermutationStrongName() throws SecurityException {
        if (this.getPermutationStrongName() == null) {
            throw new SecurityException("Blocked request without GWT permutation header (XSRF attack?)");
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        return RemoteServiceServlet.loadSerializationPolicy(this, request, moduleBaseURL, strongName);
    }

    protected String getCodeServerPolicyUrl(String strongName) {
        if (this.codeServerPort <= 0) {
            return null;
        }
        return "http://localhost:" + this.codeServerPort + "/policies/" + strongName + ".gwt.rpc";
    }

    protected SerializationPolicy loadPolicyFromCodeServer(String url) {
        SerializationPolicyClient.Logger adapter = new SerializationPolicyClient.Logger(){

            @Override
            public void logInfo(String message) {
                RemoteServiceServlet.this.log(message);
            }

            @Override
            public void logError(String message, Throwable throwable) {
                RemoteServiceServlet.this.log(message, throwable);
            }
        };
        return CODE_SERVER_CLIENT.loadPolicy(url, adapter);
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    private Writer createWriterForResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean clientAcceptsGzipEncoding = RPCServletUtils.acceptsGzipEncoding(request);
        return RPCServletUtils.createWriterForResponse(this.getServletContext(), response, clientAcceptsGzipEncoding);
    }
}

