/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import com.google.gwt.user.server.rpc.jakarta.RPCServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class LazyGzipCompressingOutputStream
extends FilterOutputStream {
    private byte[] buffer;
    private int bytesWrittenToBuffer;
    private final HttpServletResponse response;

    public LazyGzipCompressingOutputStream(HttpServletResponse response, int sizeLimitForNoCompression) throws IOException {
        super((OutputStream)response.getOutputStream());
        this.buffer = new byte[sizeLimitForNoCompression];
        this.response = response;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer == null) {
            super.write(b);
        } else if (this.bytesWrittenToBuffer < this.buffer.length) {
            this.buffer[this.bytesWrittenToBuffer++] = (byte)b;
        } else {
            this.activateCompression();
            super.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            super.write(b, off, len);
        } else if (this.bytesWrittenToBuffer + len <= this.buffer.length) {
            System.arraycopy(b, off, this.buffer, this.bytesWrittenToBuffer, len);
            this.bytesWrittenToBuffer += len;
        } else {
            this.activateCompression();
            super.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer != null) {
            this.flushBuffer();
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.flushBuffer();
        }
        super.close();
    }

    private void activateCompression() throws IOException {
        RPCServletUtils.setGzipEncodingHeader(this.response);
        this.out = new GZIPOutputStream(this.out);
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        this.out.write(this.buffer, 0, this.bytesWrittenToBuffer);
        this.buffer = null;
    }
}

