/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.ArrayStamper;
import javaemul.internal.JsUtils;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsType;

public final class ArrayHelper {
    public static final int ARRAY_PROCESS_BATCH_SIZE = 10000;

    public static <T> T[] clone(T[] array) {
        Object[] result = ArrayHelper.asNativeArray(array).slice();
        return ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static <T> T[] clone(T[] array, int fromIndex, int toIndex) {
        Object[] result = ArrayHelper.unsafeClone(array, fromIndex, toIndex);
        ArrayHelper.setLength(result, toIndex - fromIndex);
        return ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static Object[] unsafeClone(Object array, int fromIndex, int toIndex) {
        return ArrayHelper.asNativeArray(array).slice(fromIndex, toIndex);
    }

    public static <T> T[] createFrom(T[] array, int length) {
        return ArrayStamper.stampJavaTypeInfo(new NativeArray(length), array);
    }

    public static boolean isArray(Object object) {
        throw new RuntimeException("Cannot call native method");
    }

    public static int getLength(Object array) {
        return ArrayHelper.asNativeArray((Object)array).length;
    }

    public static void setLength(Object array, int length) {
        ArrayHelper.asNativeArray((Object)array).length = length;
    }

    public static void push(Object[] array, Object o) {
        ArrayHelper.asNativeArray(array).push(o);
    }

    public static void push(byte[] array, byte o) {
        ArrayHelper.asNativeArray(array).push(o);
    }

    public static <T> T setAt(T[] array, int index, T value) {
        T originalValue = array[index];
        array[index] = value;
        return originalValue;
    }

    public static void removeFrom(Object[] array, int index, int deleteCount) {
        ArrayHelper.asNativeArray(array).splice(index, deleteCount, new Object[0]);
    }

    public static void insertTo(Object[] array, int index, Object value) {
        ArrayHelper.asNativeArray(array).splice(index, 0, value);
    }

    public static void insertTo(Object[] array, int index, Object[] values) {
        ArrayHelper.copy(values, 0, array, index, values.length, false);
    }

    public static void copy(Object array, int srcOfs, Object dest, int destOfs, int len) {
        ArrayHelper.copy(array, srcOfs, dest, destOfs, len, true);
    }

    private static void copy(Object src, int srcOfs, Object dest, int destOfs, int len, boolean overwrite) {
        if (len == 0) {
            return;
        }
        if (src == dest) {
            src = ArrayHelper.unsafeClone(src, srcOfs, srcOfs + len);
            srcOfs = 0;
        }
        NativeArray destArray = ArrayHelper.asNativeArray(dest);
        int batchStart = srcOfs;
        int end = srcOfs + len;
        while (batchStart < end) {
            int batchEnd = Math.min(batchStart + 10000, end);
            len = batchEnd - batchStart;
            Object[] spliceArgs = ArrayHelper.unsafeClone(src, batchStart, batchEnd);
            ArrayHelper.asNativeArray(spliceArgs).splice(0, 0, destOfs, overwrite ? len : 0);
            ArrayHelper.getSpliceFunction().apply(destArray, spliceArgs);
            batchStart = batchEnd;
            destOfs += len;
        }
    }

    private static NativeFunction getSpliceFunction() {
        throw new RuntimeException("Cannot call native method");
    }

    public static void sort(Object array, CompareFunction fn) {
        ArrayHelper.asNativeArray(array).sort(fn);
    }

    private static NativeArray asNativeArray(Object array) {
        return (NativeArray)JsUtils.uncheckedCast(array);
    }

    private ArrayHelper() {
    }

    @JsType(isNative=true, name="Array", namespace="<window>")
    private static class NativeArray {
        int length;

        NativeArray(int length) {
        }

        void push(Object object) {
            throw new RuntimeException("Cannot call native method");
        }

        Object[] slice() {
            throw new RuntimeException("Cannot call native method");
        }

        Object[] slice(int n, int n2) {
            throw new RuntimeException("Cannot call native method");
        }

        void splice(int n, int n2, Object ... objectArray) {
            throw new RuntimeException("Cannot call native method");
        }

        <T> void sort(CompareFunction compareFunction) {
            throw new RuntimeException("Cannot call native method");
        }
    }

    @JsFunction
    public static interface CompareFunction {
        public double compare(Object var1, Object var2);
    }

    @JsType(isNative=true, name="Function", namespace="<window>")
    private static class NativeFunction {
        private NativeFunction() {
        }

        public String apply(Object object, Object[] objectArray) {
            throw new RuntimeException("Cannot call native method");
        }
    }
}

