/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.internal.misc.VM;
import jdk.internal.reflect.CallerSensitive;

public class Reflection {
    private static volatile Map<Class<?>, String[]> fieldFilterMap;
    private static volatile Map<Class<?>, String[]> methodFilterMap;

    public static Class<?> getCallerClass() {
        throw new RuntimeException("Cannot call native method");
    }

    public static int getClassAccessFlags(Class<?> clazz) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void ensureMemberAccess(Class<?> currentClass, Class<?> memberClass, Class<?> targetClass, int modifiers) throws IllegalAccessException {
        if (!Reflection.verifyMemberAccess(currentClass, memberClass, targetClass, modifiers)) {
            throw Reflection.newIllegalAccessException(currentClass, memberClass, targetClass, modifiers);
        }
    }

    public static boolean verifyMemberAccess(Class<?> currentClass, Class<?> memberClass, Class<?> targetClass, int modifiers) {
        if (currentClass == memberClass) {
            return true;
        }
        if (!Reflection.verifyModuleAccess(currentClass.getModule(), memberClass)) {
            return false;
        }
        boolean gotIsSameClassPackage = false;
        boolean isSameClassPackage = false;
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(memberClass))) {
            isSameClassPackage = Reflection.isSameClassPackage(currentClass, memberClass);
            gotIsSameClassPackage = true;
            if (!isSameClassPackage) {
                return false;
            }
        }
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers) && Reflection.areNestMates(currentClass, memberClass)) {
            return true;
        }
        boolean successSoFar = false;
        if (Modifier.isProtected(modifiers) && Reflection.isSubclassOf(currentClass, memberClass)) {
            successSoFar = true;
        }
        if (!successSoFar && !Modifier.isPrivate(modifiers)) {
            if (!gotIsSameClassPackage) {
                isSameClassPackage = Reflection.isSameClassPackage(currentClass, memberClass);
                gotIsSameClassPackage = true;
            }
            if (isSameClassPackage) {
                successSoFar = true;
            }
        }
        if (!successSoFar) {
            return false;
        }
        if (targetClass != null && Modifier.isProtected(modifiers) && targetClass != currentClass) {
            if (!gotIsSameClassPackage) {
                isSameClassPackage = Reflection.isSameClassPackage(currentClass, memberClass);
                gotIsSameClassPackage = true;
            }
            if (!isSameClassPackage && !Reflection.isSubclassOf(targetClass, currentClass)) {
                return false;
            }
        }
        return true;
    }

    public static boolean verifyModuleAccess(Module currentModule, Class<?> memberClass) {
        Module memberModule = memberClass.getModule();
        if (currentModule == memberModule) {
            return true;
        }
        String pkg = memberClass.getPackageName();
        return memberModule.isExported(pkg, currentModule);
    }

    private static boolean isSameClassPackage(Class<?> c1, Class<?> c2) {
        if (c1.getClassLoader() != c2.getClassLoader()) {
            return false;
        }
        return Objects.equals(c1.getPackageName(), c2.getPackageName());
    }

    static boolean isSubclassOf(Class<?> queryClass, Class<?> ofClass) {
        while (queryClass != null) {
            if (queryClass == ofClass) {
                return true;
            }
            queryClass = queryClass.getSuperclass();
        }
        return false;
    }

    public static synchronized void registerFieldsToFilter(Class<?> containingClass, String ... fieldNames) {
        fieldFilterMap = Reflection.registerFilter(fieldFilterMap, containingClass, fieldNames);
    }

    public static synchronized void registerMethodsToFilter(Class<?> containingClass, String ... methodNames) {
        methodFilterMap = Reflection.registerFilter(methodFilterMap, containingClass, methodNames);
    }

    private static Map<Class<?>, String[]> registerFilter(Map<Class<?>, String[]> map, Class<?> containingClass, String ... names) {
        if (map.get(containingClass) != null) {
            throw new IllegalArgumentException("Filter already registered: " + containingClass);
        }
        map = new HashMap(map);
        map.put(containingClass, names);
        return map;
    }

    public static Field[] filterFields(Class<?> containingClass, Field[] fields) {
        if (fieldFilterMap == null) {
            return fields;
        }
        return (Field[])Reflection.filter(fields, fieldFilterMap.get(containingClass));
    }

    public static Method[] filterMethods(Class<?> containingClass, Method[] methods) {
        if (methodFilterMap == null) {
            return methods;
        }
        return (Method[])Reflection.filter(methods, methodFilterMap.get(containingClass));
    }

    private static Member[] filter(Member[] members, String[] filteredNames) {
        if (filteredNames == null || members.length == 0) {
            return members;
        }
        int numNewMembers = 0;
        for (Member member : members) {
            boolean shouldSkip = false;
            for (String filteredName : filteredNames) {
                if (member.getName() != filteredName) continue;
                shouldSkip = true;
                break;
            }
            if (shouldSkip) continue;
            ++numNewMembers;
        }
        Member[] newMembers = (Member[])Array.newInstance(members[0].getClass(), numNewMembers);
        int destIdx = 0;
        for (Member member : members) {
            boolean shouldSkip = false;
            for (String filteredName : filteredNames) {
                if (member.getName() != filteredName) continue;
                shouldSkip = true;
                break;
            }
            if (shouldSkip) continue;
            newMembers[destIdx++] = member;
        }
        return newMembers;
    }

    public static boolean isCallerSensitive(Method m) {
        ClassLoader loader = m.getDeclaringClass().getClassLoader();
        if (VM.isSystemDomainLoader(loader)) {
            return m.isAnnotationPresent(CallerSensitive.class);
        }
        return false;
    }

    public static IllegalAccessException newIllegalAccessException(Class<?> currentClass, Class<?> memberClass, Class<?> targetClass, int modifiers) throws IllegalAccessException {
        Module m2;
        String currentSuffix = "";
        String memberSuffix = "";
        Module m1 = currentClass.getModule();
        if (m1.isNamed()) {
            currentSuffix = " (in " + m1 + ")";
        }
        if ((m2 = memberClass.getModule()).isNamed()) {
            memberSuffix = " (in " + m2 + ")";
        }
        String memberPackageName = memberClass.getPackageName();
        String msg = currentClass + currentSuffix + " cannot access ";
        if (m2.isExported(memberPackageName, m1)) {
            msg = msg + "a member of " + memberClass + memberSuffix + " with modifiers \"" + Modifier.toString(modifiers) + "\"";
        } else {
            msg = msg + memberClass + memberSuffix + " because " + m2 + " does not export " + memberPackageName;
            if (m2.isNamed()) {
                msg = msg + " to " + m1;
            }
        }
        return new IllegalAccessException(msg);
    }

    public static boolean areNestMates(Class<?> clazz, Class<?> clazz2) {
        throw new RuntimeException("Cannot call native method");
    }

    static {
        HashMap map = new HashMap();
        map.put(Reflection.class, new String[]{"fieldFilterMap", "methodFilterMap"});
        map.put(System.class, new String[]{"security"});
        map.put(Class.class, new String[]{"classLoader"});
        fieldFilterMap = map;
        methodFilterMap = new HashMap();
    }
}

