/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.util.Map;
import java.util.Properties;
import jdk.internal.misc.OSEnvironment;

public class VM {
    private static final int JAVA_LANG_SYSTEM_INITED = 1;
    private static final int MODULE_SYSTEM_INITED = 2;
    private static final int SYSTEM_LOADER_INITIALIZING = 3;
    private static final int SYSTEM_BOOTED = 4;
    private static final int SYSTEM_SHUTDOWN = 5;
    private static volatile int initLevel;
    private static final Object lock;
    private static long directMemory;
    private static boolean pageAlignDirectMemory;
    private static Map<String, String> savedProps;
    private static volatile int finalRefCount;
    private static volatile int peakFinalRefCount;
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLevel(int value) {
        Object object = lock;
        synchronized (object) {
            if (value <= initLevel || value > 5) {
                throw new InternalError("Bad level: " + value);
            }
            initLevel = value;
            lock.notifyAll();
        }
    }

    public static int initLevel() {
        return initLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitInitLevel(int value) throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            while (initLevel < value) {
                lock.wait();
            }
        }
    }

    public static boolean isModuleSystemInited() {
        return VM.initLevel() >= 2;
    }

    public static boolean isBooted() {
        return initLevel >= 4;
    }

    public static void shutdown() {
        VM.initLevel(5);
    }

    public static boolean isShutdown() {
        return initLevel == 5;
    }

    public static long maxDirectMemory() {
        return directMemory;
    }

    public static boolean isDirectMemoryPageAligned() {
        return pageAlignDirectMemory;
    }

    public static boolean isSystemDomainLoader(ClassLoader loader) {
        return loader == null || loader == ClassLoader.getPlatformClassLoader();
    }

    public static String getSavedProperty(String key) {
        if (savedProps == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return savedProps.get(key);
    }

    public static Map<String, String> getSavedProperties() {
        if (savedProps == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return savedProps;
    }

    public static void saveAndRemoveProperties(Properties props) {
        if (VM.initLevel() != 0) {
            throw new IllegalStateException("Wrong init level");
        }
        Map sp = Map.ofEntries(props.entrySet().toArray(new Map.Entry[0]));
        savedProps = sp;
        String s = (String)props.remove("sun.nio.MaxDirectMemorySize");
        if (s != null) {
            if (s.equals("-1")) {
                directMemory = Runtime.getRuntime().maxMemory();
            } else {
                long l = Long.parseLong(s);
                if (l > -1L) {
                    directMemory = l;
                }
            }
        }
        if ("true".equals(s = (String)props.remove("sun.nio.PageAlignDirectMemory"))) {
            pageAlignDirectMemory = true;
        }
        props.remove("java.lang.Integer.IntegerCache.high");
        props.remove("sun.java.launcher.diag");
        props.remove("jdk.boot.class.path.append");
    }

    public static void initializeOSEnvironment() {
        if (VM.initLevel() == 0) {
            OSEnvironment.initialize();
        }
    }

    public static int getFinalRefCount() {
        return finalRefCount;
    }

    public static int getPeakFinalRefCount() {
        return peakFinalRefCount;
    }

    public static void addFinalRefCount(int n) {
        if ((finalRefCount += n) > peakFinalRefCount) {
            peakFinalRefCount = finalRefCount;
        }
    }

    public static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }

    public static ClassLoader latestUserDefinedLoader() {
        ClassLoader loader = VM.latestUserDefinedLoader0();
        return loader != null ? loader : ClassLoader.getPlatformClassLoader();
    }

    private static ClassLoader latestUserDefinedLoader0() {
        throw new RuntimeException("Cannot call native method");
    }

    public static boolean isSetUID() {
        long uid = VM.getuid();
        long euid = VM.geteuid();
        long gid = VM.getgid();
        long egid = VM.getegid();
        return uid != euid || gid != egid;
    }

    public static long getuid() {
        throw new RuntimeException("Cannot call native method");
    }

    public static long geteuid() {
        throw new RuntimeException("Cannot call native method");
    }

    public static long getgid() {
        throw new RuntimeException("Cannot call native method");
    }

    public static long getegid() {
        throw new RuntimeException("Cannot call native method");
    }

    public static long getNanoTimeAdjustment(long l) {
        throw new RuntimeException("Cannot call native method");
    }

    public static String[] getRuntimeArguments() {
        throw new RuntimeException("Cannot call native method");
    }

    private static void initialize() {
        throw new RuntimeException("Cannot call native method");
    }

    public static void initializeFromArchive(Class<?> clazz) {
        throw new RuntimeException("Cannot call native method");
    }

    static {
        lock = new Object();
        directMemory = 0x4000000L;
        VM.initialize();
    }
}

