/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.SimpleBarProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.impl.SimpleEntityProxyId;
import junit.framework.TestCase;

public class SimpleEntityProxyIdTest
extends TestCase {
    public void testEquality() {
        SimpleEntityProxyId<EntityProxy> client1 = this.id(EntityProxy.class, 1);
        SimpleEntityProxyIdTest.assertTrue(this.isStable(client1, client1));
        SimpleEntityProxyIdTest.assertTrue(this.isStable(client1, this.id(EntityProxy.class, 1)));
        client1.setServerId("server1");
        SimpleEntityProxyIdTest.assertTrue(this.isStable(client1, client1));
        SimpleEntityProxyIdTest.assertTrue(this.isStable(client1, this.id(EntityProxy.class, 1)));
        SimpleEntityProxyId<EntityProxy> server1 = this.id(EntityProxy.class, "server1");
        SimpleEntityProxyIdTest.assertTrue(this.isStable(server1, this.id(EntityProxy.class, "server1")));
        SimpleEntityProxyIdTest.assertFalse(this.isStable(client1, server1));
    }

    public void testInequality() {
        SimpleEntityProxyIdTest.assertFalse(this.isStable(this.id(EntityProxy.class, 1), this.id(EntityProxy.class, 2)));
        SimpleEntityProxyIdTest.assertFalse(this.isStable(this.id(EntityProxy.class, "server1"), this.id(EntityProxy.class, "server2")));
        SimpleEntityProxyIdTest.assertFalse(this.isStable(this.id(SimpleFooProxy.class, 1), this.id(SimpleBarProxy.class, 1)));
        SimpleEntityProxyIdTest.assertFalse(this.isStable(this.id(SimpleFooProxy.class, "server1"), this.id(SimpleBarProxy.class, "server1")));
    }

    private <T extends EntityProxy> SimpleEntityProxyId<T> id(Class<T> clazz, int clientId) {
        return new SimpleEntityProxyId<T>(clazz, clientId);
    }

    private <T extends EntityProxy> SimpleEntityProxyId<T> id(Class<T> clazz, String serverId) {
        return new SimpleEntityProxyId<T>(clazz, serverId);
    }

    private boolean isStable(SimpleEntityProxyId<?> a, SimpleEntityProxyId<?> b) {
        return a.equals(b) && b.equals(a) && a.hashCode() == b.hashCode();
    }
}

