/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.gwt.client.DefaultRequestTransport;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.SimpleRequestFactory;
import com.google.web.bindery.requestfactory.shared.SimpleValueProxy;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import com.google.web.bindery.requestfactory.shared.messages.OperationMessage;
import com.google.web.bindery.requestfactory.shared.messages.RequestMessage;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;

public class RequestPayloadTest
extends GWTTestCase {
    protected SimpleRequestFactory factory;
    protected RecordingRequestTransport transport;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testOperationPayload() throws Exception {
        this.delayTestFinish(5000);
        SimpleFooRequest context = this.factory.simpleFooRequest();
        context.findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                SimpleFooRequest context = RequestPayloadTest.this.factory.simpleFooRequest();
                final SimpleFooProxy foo = context.edit(response);
                AbstractRequestFactory abstractRequestFactory = ((AbstractRequestContext.State)AutoBeanUtils.getAutoBean(foo).getTag((String)"requestContext")).requestFactory;
                final String fooTypeToken = abstractRequestFactory.getTypeToken(SimpleFooProxy.class);
                final String valueTypeToken = abstractRequestFactory.getTypeToken(SimpleValueProxy.class);
                final SimpleValueProxy created = context.create(SimpleValueProxy.class);
                created.setNumber(42);
                created.setString("Hello world!");
                created.setSimpleFoo(foo);
                created.setSimpleValue(Arrays.asList(created));
                foo.setSimpleValue(created);
                foo.setSimpleValues(Collections.singletonList(created));
                context.persistAndReturnSelf().using(foo).with("barField", "oneToManyField", "oneToManySetField", "simpleValue", "simpleValues").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        RequestMessage requestMessage = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, RequestMessage.class, RequestPayloadTest.this.transport.lastRequestPayload).as();
                        int seenFoos = 0;
                        int seenValues = 0;
                        for (OperationMessage operationMessage : requestMessage.getOperations()) {
                            if (fooTypeToken.equals(operationMessage.getTypeToken())) {
                                ++seenFoos;
                                SimpleProxyId id = (SimpleProxyId)((Object)foo.stableId());
                                Assert.assertEquals(id.getServerId(), operationMessage.getServerId());
                                Assert.assertEquals(2, operationMessage.getPropertyMap().size());
                                Assert.assertTrue(operationMessage.getPropertyMap().containsKey("simpleValue"));
                                Assert.assertTrue(operationMessage.getPropertyMap().containsKey("simpleValues"));
                                continue;
                            }
                            if (!valueTypeToken.equals(operationMessage.getTypeToken())) continue;
                            ++seenValues;
                            AutoBean bean = AutoBeanUtils.getAutoBean(created);
                            SimpleProxyId id = BaseProxyCategory.stableId(bean);
                            Assert.assertEquals(id.getClientId(), operationMessage.getClientId());
                            Assert.assertEquals(AutoBeanUtils.getAllProperties(bean).keySet(), operationMessage.getPropertyMap().keySet());
                        }
                        Assert.assertTrue(seenFoos > 0);
                        Assert.assertTrue(seenValues > 0);
                        RequestPayloadTest.this.factory.simpleFooRequest().persistAndReturnSelf().using(response).fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                RequestMessage requestMessage = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, RequestMessage.class, RequestPayloadTest.this.transport.lastRequestPayload).as();
                                int seenFoos = 0;
                                for (OperationMessage operationMessage : requestMessage.getOperations()) {
                                    if (!fooTypeToken.equals(operationMessage.getTypeToken())) continue;
                                    ++seenFoos;
                                    Assert.assertNull(operationMessage.getPropertyMap());
                                }
                                Assert.assertTrue(seenFoos > 0);
                                RequestPayloadTest.this.finishTest();
                            }
                        });
                    }
                });
            }
        });
    }

    protected SimpleRequestFactory createFactory() {
        return (SimpleRequestFactory)GWT.create(SimpleRequestFactory.class);
    }

    protected RequestTransport createTransport() {
        return new DefaultRequestTransport();
    }

    @Override
    protected void gwtSetUp() throws Exception {
        this.factory = this.createFactory();
        this.transport = new RecordingRequestTransport(this.createTransport());
        this.factory.initialize(new SimpleEventBus(), this.transport);
    }

    protected static class RecordingRequestTransport
    implements RequestTransport {
        public String lastRequestPayload;
        private final RequestTransport realTransport;

        public RecordingRequestTransport(RequestTransport realTransport) {
            this.realTransport = realTransport;
        }

        @Override
        public void send(String payload, RequestTransport.TransportReceiver receiver) {
            this.lastRequestPayload = payload;
            this.realTransport.send(payload, receiver);
        }
    }
}

