/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceLocator;
import junit.framework.Assert;

public class ServiceInheritanceTest
extends GWTTestCase {
    private static final int TEST_DELAY = 5000;
    private Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testInvokeInheritedMethod() {
        this.delayTestFinish(5000);
        this.factory.subContext().add(13).fire(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals((Object)21, response);
                ServiceInheritanceTest.this.finishTest();
            }
        });
    }

    public void testInvokeMethodOnBaseClass() {
        this.delayTestFinish(5000);
        this.factory.baseContext().add(13).fire(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals((Object)18, response);
                ServiceInheritanceTest.this.finishTest();
            }
        });
    }

    public void testInvokeOverriddenMethod() {
        this.delayTestFinish(5000);
        this.factory.subContext().subtract(3).fire(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals((Object)0, response);
                ServiceInheritanceTest.this.finishTest();
            }
        });
    }

    protected Factory createFactory() {
        Factory toReturn = (Factory)GWT.create(Factory.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    @Override
    protected void gwtSetUp() {
        this.factory = this.createFactory();
    }

    static class SubclassImpl
    extends BaseImpl {
        public SubclassImpl() {
            this.initialValue = 8;
        }

        @Override
        public Integer subtract(int n) {
            return 0;
        }
    }

    static class BaseImpl {
        protected int initialValue = 5;

        public Integer add(int n) {
            return this.initialValue + n;
        }

        public Integer subtract(int n) {
            return this.initialValue - n;
        }
    }

    @Service(value=SubclassImpl.class, locator=SumServiceLocator.class)
    static interface SumServiceSub
    extends SumServiceBase {
    }

    @Service(value=BaseImpl.class, locator=SumServiceLocator.class)
    static interface SumServiceBase
    extends RequestContext,
    HasAdd {
        public Request<Integer> subtract(int var1);
    }

    static interface HasAdd {
        public Request<Integer> add(int var1);
    }

    protected static interface Factory
    extends RequestFactory {
        public SumServiceBase baseContext();

        public SumServiceSub subContext();
    }

    public static class SumServiceLocator
    implements ServiceLocator {
        @Override
        public Object getInstance(Class<?> clazz) {
            if (BaseImpl.class.equals(clazz)) {
                return new BaseImpl();
            }
            if (SubclassImpl.class.equals(clazz)) {
                return new SubclassImpl();
            }
            return null;
        }
    }
}

