/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import junit.framework.Assert;

public class MultipleFactoriesTest
extends GWTTestCase {
    private static final String EXPECTED_STRING_1 = "hello world 1";
    private static final String EXPECTED_STRING_2 = "hello world 2";
    private static final int TEST_DELAY = 5000;
    private Factory1 factory1;
    private Factory2 factory2;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void test() {
        this.delayTestFinish(5000);
        this.context1().getEntity().fire((Receiver<Proxy1>)new TestReceiver<Proxy1>(){

            @Override
            public void onSuccess(Proxy1 response) {
                Assert.assertEquals(MultipleFactoriesTest.EXPECTED_STRING_1, response.getString1());
                MultipleFactoriesTest.this.context2().getEntity().to((Receiver<Proxy2>)new TestReceiver<Proxy2>(){

                    @Override
                    public void onSuccess(Proxy2 response) {
                        Assert.assertEquals(MultipleFactoriesTest.EXPECTED_STRING_2, response.getString2());
                    }
                }).fire((Receiver<Void>)new TestReceiver<Void>(){

                    @Override
                    public void onSuccess(Void response) {
                        MultipleFactoriesTest.this.finishTest();
                    }
                });
            }
        });
    }

    protected Factory1 createFactory1() {
        Factory1 toReturn = (Factory1)GWT.create(Factory1.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    protected Factory2 createFactory2() {
        Factory2 toReturn = (Factory2)GWT.create(Factory2.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    @Override
    protected void gwtSetUp() {
        this.factory1 = this.createFactory1();
        this.factory2 = this.createFactory2();
    }

    private Context1 context1() {
        return this.factory1.context();
    }

    private Context2 context2() {
        return this.factory2.context();
    }

    static abstract class TestReceiver<T>
    extends Receiver<T> {
        TestReceiver() {
        }

        @Override
        public void onFailure(ServerFailure error) {
            Assert.fail(error.getMessage());
        }
    }

    @ProxyFor(value=Entity.class)
    static interface Proxy2
    extends ValueProxy {
        public String getString2();
    }

    @ProxyFor(value=Entity.class)
    static interface Proxy1
    extends ValueProxy {
        public String getString1();
    }

    @Service(value=ServiceImpl.class)
    static interface Context2
    extends RequestContext {
        public Request<Proxy2> getEntity();
    }

    @Service(value=ServiceImpl.class)
    static interface Context1
    extends RequestContext {
        public Request<Proxy1> getEntity();
    }

    protected static class ServiceImpl {
        protected ServiceImpl() {
        }

        public static Entity getEntity() {
            return Entity.SINGLETON;
        }
    }

    protected static interface Factory2
    extends RequestFactory {
        public Context2 context();
    }

    protected static interface Factory1
    extends RequestFactory {
        public Context1 context();
    }

    protected static class Entity {
        static final Entity SINGLETON = new Entity();

        protected Entity() {
        }

        public String getString1() {
            return MultipleFactoriesTest.EXPECTED_STRING_1;
        }

        public String getString2() {
            return MultipleFactoriesTest.EXPECTED_STRING_2;
        }
    }
}

