/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.Locator;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import junit.framework.Assert;

public class LocatorTest
extends GWTTestCase {
    private static final String ID = "DomainId";
    private static final int TEST_DELAY = 5000;
    private Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testLocator() {
        this.delayTestFinish(5000);
        this.context().getDomain().fire(new Receiver<DomainProxy>(){

            @Override
            public void onSuccess(final DomainProxy response) {
                LocatorTest.this.factory.find(response.stableId()).fire(new Receiver<DomainProxy>(){

                    @Override
                    public void onSuccess(DomainProxy found) {
                        Assert.assertEquals(response.stableId(), found.stableId());
                        LocatorTest.this.finishTest();
                    }
                });
            }
        });
    }

    protected Factory createFactory() {
        Factory toReturn = (Factory)GWT.create(Factory.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    @Override
    protected void gwtSetUp() {
        this.factory = this.createFactory();
    }

    private Context context() {
        return this.factory.context();
    }

    @ProxyFor(value=Domain.class, locator=DomainLocator.class)
    static interface DomainProxy
    extends EntityProxy {
        public EntityProxyId<DomainProxy> stableId();
    }

    static class Domain {
        static final Domain INSTANCE = new Domain();

        Domain() {
        }
    }

    static class ContextImpl {
        ContextImpl() {
        }

        public static Domain getDomain() {
            return Domain.INSTANCE;
        }
    }

    @Service(value=ContextImpl.class)
    static interface Context
    extends RequestContext {
        public Request<DomainProxy> getDomain();
    }

    protected static interface Factory
    extends RequestFactory {
        public Context context();
    }

    public static class DomainLocator
    extends Locator<Domain, String> {
        @Override
        public Domain create(Class<? extends Domain> clazz) {
            Assert.assertEquals(Domain.class, clazz);
            return new Domain();
        }

        @Override
        public Domain find(Class<? extends Domain> clazz, String id) {
            Assert.assertEquals(LocatorTest.ID, id);
            return Domain.INSTANCE;
        }

        @Override
        public Class<Domain> getDomainType() {
            return Domain.class;
        }

        @Override
        public String getId(Domain domainObject) {
            return LocatorTest.ID;
        }

        @Override
        public Class<String> getIdType() {
            return String.class;
        }

        @Override
        public Object getVersion(Domain domainObject) {
            return 0;
        }
    }
}

