/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.UmbrellaException;
import com.google.web.bindery.requestfactory.shared.FanoutReceiver;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Violation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import junit.framework.Assert;

public class FanoutReceiverTest
extends GWTTestCase {
    private static final int EXPECTED_VALUE = 42;
    private static final String MESSAGE = "It didn't work!";

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void test() {
        CountingReceiver c1 = new CountingReceiver();
        CountingReceiver c2 = new CountingReceiver();
        FanoutReceiver<Integer> fan = new FanoutReceiver<Integer>();
        fan.add(c1);
        fan.add(c2);
        fan.onConstraintViolation(null);
        fan.onFailure(null);
        fan.onSuccess(42);
        fan.onViolation(null);
        c1.check();
        c2.check();
    }

    public void testAddNull() {
        try {
            new FanoutReceiver().add(null);
            FanoutReceiverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExceptions() {
        CountingReceiver c1 = new CountingReceiver();
        c1.setExplode(true);
        CountingReceiver c2 = new CountingReceiver();
        FanoutReceiver<Integer> fan = new FanoutReceiver<Integer>();
        fan.add(c1);
        fan.add(c2);
        try {
            fan.onConstraintViolation(null);
            FanoutReceiverTest.fail("Expected UmbrellaException");
        }
        catch (UmbrellaException ex) {
            FanoutReceiverTest.assertEquals(1, ex.getCauses().size());
            FanoutReceiverTest.assertEquals(MESSAGE, ex.getCause().getMessage());
        }
        try {
            fan.onFailure(null);
            FanoutReceiverTest.fail("Expected UmbrellaException");
        }
        catch (UmbrellaException ex) {
            FanoutReceiverTest.assertEquals(1, ex.getCauses().size());
            FanoutReceiverTest.assertEquals(MESSAGE, ex.getCause().getMessage());
        }
        try {
            fan.onSuccess(42);
            FanoutReceiverTest.fail("Expected UmbrellaException");
        }
        catch (UmbrellaException ex) {
            FanoutReceiverTest.assertEquals(1, ex.getCauses().size());
            FanoutReceiverTest.assertEquals(MESSAGE, ex.getCause().getMessage());
        }
        try {
            fan.onViolation(null);
            FanoutReceiverTest.fail("Expected UmbrellaException");
        }
        catch (UmbrellaException ex) {
            FanoutReceiverTest.assertEquals(1, ex.getCauses().size());
            FanoutReceiverTest.assertEquals(MESSAGE, ex.getCause().getMessage());
        }
        c2.check();
    }

    private static class CountingReceiver
    extends Receiver<Integer> {
        private boolean explode;
        private int onConstraintViolation;
        private int onFailure;
        private int onSuccess;
        private int onViolation;

        private CountingReceiver() {
        }

        public void check() {
            Assert.assertEquals(1, this.onConstraintViolation);
            Assert.assertEquals(1, this.onFailure);
            Assert.assertEquals(1, this.onSuccess);
            Assert.assertEquals(1, this.onViolation);
        }

        private void maybeExplode() {
            if (this.explode) {
                throw new RuntimeException(FanoutReceiverTest.MESSAGE);
            }
        }

        @Override
        public void onConstraintViolation(Set<ConstraintViolation<?>> violations) {
            this.maybeExplode();
            ++this.onConstraintViolation;
        }

        @Override
        public void onFailure(ServerFailure error) {
            this.maybeExplode();
            ++this.onFailure;
        }

        @Override
        public void onSuccess(Integer response) {
            this.maybeExplode();
            Assert.assertEquals(42, response);
            ++this.onSuccess;
        }

        @Override
        @Deprecated
        public void onViolation(Set<Violation> errors) {
            this.maybeExplode();
            ++this.onViolation;
        }

        public void setExplode(boolean explode) {
            this.explode = explode;
        }
    }
}

