/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.SkipInterfaceValidation;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import junit.framework.Assert;

@SkipInterfaceValidation
public class ComplexKeysTest
extends GWTTestCase {
    private static final int TEST_DELAY = 5000;
    private Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testEntityKey() {
        this.delayTestFinish(5000);
        this.context().createEntity("key").fire(new Receiver<DomainWithEntityKeyProxy>(){

            @Override
            public void onSuccess(final DomainWithEntityKeyProxy response) {
                ComplexKeysTest.this.factory.find(response.stableId()).fire(new Receiver<DomainWithEntityKeyProxy>(){

                    @Override
                    public void onSuccess(DomainWithEntityKeyProxy found) {
                        Assert.assertEquals(response.stableId(), found.stableId());
                        ComplexKeysTest.this.finishTest();
                    }
                });
            }
        });
    }

    public void testValueKey() {
        this.delayTestFinish(5000);
        this.context().createValue("key").fire(new Receiver<DomainWithValueKeyProxy>(){

            @Override
            public void onSuccess(final DomainWithValueKeyProxy response) {
                ComplexKeysTest.this.factory.find(response.stableId()).fire(new Receiver<DomainWithValueKeyProxy>(){

                    @Override
                    public void onSuccess(DomainWithValueKeyProxy found) {
                        Assert.assertEquals(response.stableId(), found.stableId());
                        ComplexKeysTest.this.finishTest();
                    }
                });
            }
        });
    }

    protected Factory createFactory() {
        Factory toReturn = (Factory)GWT.create(Factory.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    @Override
    protected void gwtSetUp() {
        this.factory = this.createFactory();
    }

    private Context context() {
        return this.factory.context();
    }

    @ProxyFor(value=ValueKey.class)
    static interface ValueKeyProxy
    extends ValueProxy {
        public String getKey();
    }

    static class ValueKey {
        private String key;

        public ValueKey() {
        }

        public ValueKey(String key) {
            this.setKey(key);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            Assert.assertEquals("key", key);
            this.key = key;
        }
    }

    @ProxyFor(value=EntityKey.class)
    @SkipInterfaceValidation
    static interface EntityKeyProxy
    extends EntityProxy {
    }

    static class EntityKey {
        private final String key;

        public static EntityKey findEntityKey(String key) {
            return new EntityKey(key);
        }

        public EntityKey(String key) {
            Assert.assertEquals("key", key);
            this.key = key;
        }

        public String getId() {
            return this.key;
        }

        public Integer getVersion() {
            return 0;
        }
    }

    @ProxyFor(value=DomainWithValueKey.class)
    static interface DomainWithValueKeyProxy
    extends EntityProxy {
        public ValueKeyProxy getId();

        public EntityProxyId<DomainWithValueKeyProxy> stableId();
    }

    static class DomainWithValueKey {
        private final ValueKey key;

        public static DomainWithValueKey create(String key) {
            return new DomainWithValueKey(new ValueKey(key));
        }

        public static DomainWithValueKey findDomainWithValueKey(ValueKey key) {
            return new DomainWithValueKey(key);
        }

        public DomainWithValueKey(ValueKey key) {
            if (key == null) {
                throw new IllegalArgumentException("Key key");
            }
            this.key = key;
        }

        public ValueKey getId() {
            return this.key;
        }

        public Integer getVersion() {
            return 0;
        }
    }

    @ProxyFor(value=DomainWithEntityKey.class)
    static interface DomainWithEntityKeyProxy
    extends EntityProxy {
        public EntityKeyProxy getId();

        public EntityProxyId<DomainWithEntityKeyProxy> stableId();
    }

    static class DomainWithEntityKey {
        private final EntityKey key;

        public static DomainWithEntityKey findDomainWithEntityKey(EntityKey key) {
            return new DomainWithEntityKey(key);
        }

        public DomainWithEntityKey(EntityKey key) {
            if (key == null) {
                throw new IllegalArgumentException("Key key");
            }
            this.key = key;
        }

        public EntityKey getId() {
            return this.key;
        }

        public Integer getVersion() {
            return 0;
        }
    }

    static class ContextImpl {
        ContextImpl() {
        }

        public static DomainWithEntityKey createEntity(String key) {
            return new DomainWithEntityKey(new EntityKey(key));
        }

        public static DomainWithValueKey createValue(String key) {
            return new DomainWithValueKey(new ValueKey(key));
        }
    }

    @Service(value=ContextImpl.class)
    static interface Context
    extends RequestContext {
        public Request<DomainWithEntityKeyProxy> createEntity(String var1);

        public Request<DomainWithValueKeyProxy> createValue(String var1);
    }

    protected static interface Factory
    extends RequestFactory {
        public Context context();
    }
}

