/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Service;
import junit.framework.Assert;

public class BoxesAndPrimitivesTest
extends GWTTestCase {
    private static final int EXPECTED = 42;
    private static final Integer EXPECTED_BOXED = 42;
    private static final boolean EXPECTED_BOOL = true;
    private static final Boolean EXPECTED_BOOL_BOXED = Boolean.TRUE;
    private static final int TEST_DELAY = 5000;
    private Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testReturnAndParamTypes() {
        this.delayTestFinish(5000);
        Context ctx = this.context();
        ctx.getBoxed().to((Receiver<Integer>)new TestReceiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals(EXPECTED_BOXED, response);
            }
        });
        ctx.getPrimitive().to((Receiver<Integer>)new TestReceiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals(EXPECTED_BOXED, response);
            }
        });
        ctx.getEntity().to((Receiver<Proxy>)new TestReceiver<Proxy>(){

            @Override
            public void onSuccess(Proxy response) {
                Assert.assertEquals(EXPECTED_BOXED, response.getBoxed());
                Assert.assertEquals(42, response.getPrimitive());
                Assert.assertEquals(true, response.isIs());
                Assert.assertEquals(EXPECTED_BOOL_BOXED, response.isIsBoxed());
                Assert.assertEquals(true, response.hasHas());
                Assert.assertEquals(EXPECTED_BOOL_BOXED, response.hasHasBoxed());
            }
        });
        ctx.checkBoxed(EXPECTED_BOXED).to((Receiver<Void>)new TestReceiver<Void>(){

            @Override
            public void onSuccess(Void response) {
            }
        });
        ctx.checkPrimitive(42).to((Receiver<Void>)new TestReceiver<Void>(){

            @Override
            public void onSuccess(Void response) {
            }
        });
        ctx.fire((Receiver<Void>)new TestReceiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                BoxesAndPrimitivesTest.this.finishTest();
            }
        });
    }

    protected Factory createFactory() {
        Factory toReturn = (Factory)GWT.create(Factory.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    @Override
    protected void gwtSetUp() {
        this.factory = this.createFactory();
    }

    private Context context() {
        return this.factory.context();
    }

    static abstract class TestReceiver<T>
    extends Receiver<T> {
        TestReceiver() {
        }

        @Override
        public void onFailure(ServerFailure error) {
            Assert.fail(error.getMessage());
        }
    }

    @ProxyFor(value=Entity.class)
    static interface Proxy
    extends EntityProxy {
        public Integer getBoxed();

        public int getPrimitive();

        public boolean hasHas();

        public Boolean hasHasBoxed();

        public boolean isIs();

        public Boolean isIsBoxed();

        public void setBoxed(Integer var1);

        public void setPrimitive(int var1);
    }

    @Service(value=ServiceImpl.class)
    static interface Context
    extends RequestContext {
        public Request<Void> checkBoxed(Integer var1);

        public Request<Void> checkPrimitive(int var1);

        public Request<Integer> getBoxed();

        public Request<Proxy> getEntity();

        public Request<Integer> getPrimitive();
    }

    protected static class ServiceImpl {
        protected ServiceImpl() {
        }

        public static void checkBoxed(Integer value) {
            Assert.assertEquals(EXPECTED_BOXED, value);
        }

        public static void checkPrimitive(int value) {
            Assert.assertEquals(42, value);
        }

        public static Integer getBoxed() {
            return EXPECTED_BOXED;
        }

        public static Entity getEntity() {
            return Entity.SINGLETON;
        }

        public static int getPrimitive() {
            return 42;
        }
    }

    protected static interface Factory
    extends RequestFactory {
        public Context context();
    }

    protected static class Entity {
        static final Entity SINGLETON = new Entity();

        protected Entity() {
        }

        public static Entity findEntity(int id) {
            return SINGLETON;
        }

        public Integer getBoxed() {
            return EXPECTED_BOXED;
        }

        public int getId() {
            return 0;
        }

        public int getPrimitive() {
            return 42;
        }

        public int getVersion() {
            return 0;
        }

        public boolean hasHas() {
            return true;
        }

        public Boolean hasHasBoxed() {
            return EXPECTED_BOOL_BOXED;
        }

        public boolean isIs() {
            return true;
        }

        public Boolean isIsBoxed() {
            return EXPECTED_BOOL_BOXED;
        }

        public void setBoxed(Integer value) {
            Assert.assertEquals(EXPECTED_BOXED, value);
        }

        public void setPrimitive(int value) {
            Assert.assertEquals(42, value);
        }
    }
}

