/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.shared.ServiceLocator;
import junit.framework.TestCase;

public class ServiceLocatorTest
extends TestCase {
    public void testGetsServiceLocatorFromDecorator() {
        ServiceLayer layer = ServiceLayer.create(new CustomLocatorLayer());
        ServiceLocatorImpl locator = layer.createServiceLocator(ServiceLocatorImpl.class);
        ServiceLocatorTest.assertSame(ServiceLocatorImpl.INSTANCE, locator);
    }

    public void testInstantiatesServiceLocatorByDefault() {
        ServiceLayer layer = ServiceLayer.create(new ServiceLayerDecorator[0]);
        ServiceLocatorImpl locator = layer.createServiceLocator(ServiceLocatorImpl.class);
        ServiceLocatorTest.assertNotNull(locator);
        ServiceLocatorTest.assertNotSame(ServiceLocatorImpl.INSTANCE, locator);
    }

    static class ServiceLocatorImpl
    implements ServiceLocator {
        static final ServiceLocatorImpl INSTANCE = new ServiceLocatorImpl();

        ServiceLocatorImpl() {
        }

        @Override
        public Object getInstance(Class<?> clazz) {
            return new Object();
        }
    }

    static class CustomLocatorLayer
    extends ServiceLayerDecorator {
        CustomLocatorLayer() {
        }

        @Override
        public <T extends ServiceLocator> T createServiceLocator(Class<T> clazz) {
            return (T)ServiceLocatorImpl.INSTANCE;
        }
    }
}

