/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.user.client.rpc.UnicodeEscapingService;
import com.google.gwt.user.client.rpc.UnicodeEscapingTest;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryTestBase;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import java.util.ArrayList;
import java.util.List;

public class RequestFactoryUnicodeEscapingTest
extends RequestFactoryTestBase {
    private static final int TEST_FINISH_DELAY_MS = 5000;
    private final UnicodeEscapingTest test = new UnicodeEscapingTest(){

        @Override
        protected void clientToServerVerifyRange(int start, final int end, final int size, final int step) throws UnicodeEscapingService.InvalidCharacterException {
            this.current = start;
            int blockEnd = Math.min(end, this.current + size);
            RequestFactoryUnicodeEscapingTest.this.req.unicodeTestRequest().verifyStringContainingCharacterRange(this.current, blockEnd, 1.getStringContainingCharacterRange(start, blockEnd)).fire(new Receiver<Void>(){
                List<ServerFailure> fails = new ArrayList<ServerFailure>();

                @Override
                public void onFailure(ServerFailure error) {
                    this.fails.add(error);
                    this.onSuccess(null);
                }

                @Override
                public void onSuccess(Void response) {
                    current += step;
                    if (current < end) {
                        this.delayTestFinish(5000);
                        int blockEnd = Math.min(end, current + size);
                        RequestFactoryUnicodeEscapingTest.this.req.unicodeTestRequest().verifyStringContainingCharacterRange(current, blockEnd, UnicodeEscapingTest.getStringContainingCharacterRange(current, blockEnd)).fire(this);
                    } else {
                        if (!this.fails.isEmpty()) {
                            StringBuilder msg = new StringBuilder();
                            for (ServerFailure error : this.fails) {
                                msg.append(error.getMessage()).append("\n");
                            }
                            throw new RuntimeException(msg.toString());
                        }
                        this.finishTest();
                    }
                }
            });
        }

        @Override
        protected void serverToClientVerify(int start, final int end, final int size, final int step) {
            this.current = start;
            RequestFactoryUnicodeEscapingTest.this.req.unicodeTestRequest().getStringContainingCharacterRange(start, Math.min(end, this.current + size)).fire(new Receiver<String>(){
                List<ServerFailure> fails = new ArrayList<ServerFailure>();

                @Override
                public void onFailure(ServerFailure error) {
                    this.fails.add(error);
                    this.nextBatch();
                }

                @Override
                public void onSuccess(String response) {
                    try {
                        UnicodeEscapingTest.verifyStringContainingCharacterRange(current, Math.min(end, current + size), response);
                    }
                    catch (UnicodeEscapingService.InvalidCharacterException e) {
                        this.fails.add(new ServerFailure(e.getMessage()));
                    }
                    this.nextBatch();
                }

                private void nextBatch() {
                    current += step;
                    if (current < end) {
                        this.delayTestFinish(5000);
                        RequestFactoryUnicodeEscapingTest.this.req.unicodeTestRequest().getStringContainingCharacterRange(current, Math.min(end, current + size)).fire(this);
                    } else {
                        if (!this.fails.isEmpty()) {
                            StringBuilder msg = new StringBuilder();
                            for (ServerFailure t : this.fails) {
                                msg.append(t.getMessage()).append("\n");
                            }
                            throw new RuntimeException(msg.toString());
                        }
                        this.finishTest();
                    }
                }
            });
        }
    };

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testClientToServerBMPHigh() throws UnicodeEscapingService.InvalidCharacterException {
        this.test.testClientToServerBMPHigh();
    }

    public void testClientToServerBMPLow() throws UnicodeEscapingService.InvalidCharacterException {
        this.test.testClientToServerBMPLow();
    }

    public void testClientToServerNonBMP() throws UnicodeEscapingService.InvalidCharacterException {
        this.test.testClientToServerNonBMP();
    }

    public void testServerToClientBMP() {
        this.test.testServerToClientBMP();
    }

    public void testServerToClientNonBMP() {
        this.test.testServerToClientNonBMP();
    }
}

