/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.DefaultProxyStore;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.ProxySerializer;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.SimpleRequestFactory;
import com.google.web.bindery.requestfactory.shared.Violation;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import java.util.Set;
import junit.framework.Assert;

public abstract class RequestFactoryTestBase
extends GWTTestCase {
    protected EventBus eventBus;
    protected SimpleRequestFactory req;

    @Override
    public void gwtSetUp() {
        this.req = this.createFactory();
        this.eventBus = this.req.getEventBus();
    }

    protected void checkEqualityAndHashcode(Object a, Object b) {
        RequestFactoryTestBase.assertNotNull(a);
        RequestFactoryTestBase.assertNotNull(b);
        RequestFactoryTestBase.assertEquals(a.hashCode(), b.hashCode());
        RequestFactoryTestBase.assertEquals(a, b);
        RequestFactoryTestBase.assertEquals(b, a);
    }

    protected void checkReachableTypes(RequestContext ctx, Class<? extends BaseProxy> shouldWork, Class<? extends BaseProxy> shouldFail) {
        block4: {
            RequestFactoryTestBase.assertNotNull(ctx.create(shouldWork));
            try {
                if (GWT.isClient()) {
                    ctx.create(shouldFail);
                    RequestFactoryTestBase.fail();
                } else {
                    RequestFactoryTestBase.assertNotNull(ctx.create(shouldFail));
                }
            }
            catch (IllegalArgumentException expected) {
                if (GWT.isClient()) break block4;
                RequestFactoryTestBase.fail("Expect the create call to always work in RFSource implementation");
            }
        }
    }

    protected <T extends BaseProxy> T checkSerialization(T proxy) {
        AutoBean originalBean = AutoBeanUtils.getAutoBean(proxy);
        SimpleProxyId id = BaseProxyCategory.stableId(originalBean);
        DefaultProxyStore store = new DefaultProxyStore();
        ProxySerializer s = this.req.getSerializer(store);
        String key = s.serialize(proxy);
        RequestFactoryTestBase.assertNotNull(key);
        store = new DefaultProxyStore(store.encode());
        s = this.req.getSerializer(store);
        Object restored = s.deserialize(id.getProxyClass(), key);
        AutoBean restoredBean = AutoBeanUtils.getAutoBean(restored);
        RequestFactoryTestBase.assertNotSame(proxy, restored);
        RequestFactoryTestBase.assertTrue(AutoBeanUtils.deepEquals(originalBean, restoredBean));
        if (proxy instanceof EntityProxy && !id.isEphemeral()) {
            RequestFactoryTestBase.assertEquals(((EntityProxy)proxy).stableId(), ((EntityProxy)restored).stableId());
        }
        restoredBean.setTag("stableId", originalBean.getTag("stableId"));
        return restored;
    }

    protected void checkStableIdEquals(EntityProxy expected, EntityProxy actual) {
        RequestFactoryTestBase.assertEquals(expected.stableId(), actual.stableId());
        RequestFactoryTestBase.assertEquals(expected.stableId().hashCode(), actual.stableId().hashCode());
        RequestFactoryTestBase.assertSame(expected.stableId(), actual.stableId());
        RequestFactoryTestBase.assertNotSame(expected, actual);
        RequestFactoryTestBase.assertFalse(expected.equals(actual));
    }

    protected SimpleRequestFactory createFactory() {
        SimpleRequestFactory toReturn = (SimpleRequestFactory)GWT.create(SimpleRequestFactory.class);
        toReturn.initialize(new SimpleEventBus());
        return toReturn;
    }

    protected void finishTestAndReset() {
        SimpleFooRequest ctx = this.req.simpleFooRequest();
        ctx.reset();
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTestBase.this.finishTest();
            }
        });
    }

    protected class SimpleFooEventHandler<P extends EntityProxy>
    implements EntityProxyChange.Handler<P> {
        int persistEventCount = 0;
        int deleteEventCount = 0;
        int totalEventCount = 0;
        int updateEventCount = 0;

        protected SimpleFooEventHandler() {
        }

        @Override
        public void onProxyChange(EntityProxyChange<P> event) {
            ++this.totalEventCount;
            switch (event.getWriteOperation()) {
                case PERSIST: {
                    ++this.persistEventCount;
                    break;
                }
                case DELETE: {
                    ++this.deleteEventCount;
                    break;
                }
                case UPDATE: {
                    ++this.updateEventCount;
                    break;
                }
            }
        }
    }

    protected class SimpleFooFailureReceiver
    extends Receiver<SimpleFooProxy> {
        private SimpleFooProxy mutableFoo;
        private Request<SimpleFooProxy> persistRequest;
        private String expectedException;

        public SimpleFooFailureReceiver(SimpleFooProxy mutableFoo, Request<SimpleFooProxy> persistRequest, String exception) {
            this.mutableFoo = mutableFoo;
            this.persistRequest = persistRequest;
            this.expectedException = exception;
        }

        @Override
        public void onFailure(ServerFailure error) {
            Assert.assertSame(this.persistRequest.getRequestContext(), error.getRequestContext());
            Assert.assertEquals(this.expectedException, error.getExceptionType());
            if (this.expectedException != null) {
                Assert.assertFalse(error.getStackTraceString().length() == 0);
                Assert.assertEquals("THIS EXCEPTION IS EXPECTED BY A TEST", error.getMessage());
            } else {
                Assert.assertEquals(null, error.getStackTraceString());
                Assert.assertEquals("Server Error: THIS EXCEPTION IS EXPECTED BY A TEST", error.getMessage());
            }
            this.mutableFoo.setPleaseCrash(24);
            this.persistRequest.fire(new Receiver<SimpleFooProxy>(){

                @Override
                public void onSuccess(SimpleFooProxy response) {
                    response = RequestFactoryTestBase.this.checkSerialization(response);
                    RequestFactoryTestBase.this.finishTestAndReset();
                }
            });
        }

        @Override
        public void onSuccess(SimpleFooProxy response) {
            Assert.fail("Failure expected but onSuccess() was called");
        }

        @Override
        public void onViolation(Set<Violation> errors) {
            Assert.fail("Failure expected but onViolation() was called");
        }
    }
}

