/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.regexp.shared.RegExp;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryTestBase;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.OnlyUsedByRequestContextMethod;
import com.google.web.bindery.requestfactory.shared.OnlyUsedInListProxy;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.SimpleBarProxy;
import com.google.web.bindery.requestfactory.shared.SimpleBarRequest;
import com.google.web.bindery.requestfactory.shared.SimpleEnum;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.SimpleValueContext;
import com.google.web.bindery.requestfactory.shared.SimpleValueProxy;
import com.google.web.bindery.requestfactory.shared.Violation;
import com.google.web.bindery.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.web.bindery.requestfactory.shared.impl.SimpleEntityProxyId;
import com.google.web.bindery.requestfactory.shared.messages.ResponseMessage;
import com.google.web.bindery.requestfactory.shared.messages.ServerFailureMessage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import junit.framework.Assert;

public class RequestFactoryTest
extends RequestFactoryTestBase {
    private static final int DELAY_TEST_FINISH = 30000;

    public <T extends EntityProxy> void assertContains(Collection<T> col, T value) {
        EntityProxyId<?> lookFor = value.stableId();
        for (EntityProxy x : col) {
            EntityProxyId<?> found = x.stableId();
            if (!found.equals(lookFor)) continue;
            return;
        }
        RequestFactoryTest.assertTrue("Value " + value + " not found in collection " + col.toString(), false);
    }

    public <T extends EntityProxy> void assertNotContains(Collection<T> col, T value) {
        for (EntityProxy x : col) {
            RequestFactoryTest.assertNotSame(x.stableId(), value.stableId());
        }
    }

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testAntiAliasing() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().fetchDoubleReference().with("fooField", "selfOneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertNotNull(response.getFooField());
                Assert.assertSame(response.getFooField(), response.getSelfOneToManyField().get(0));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testCascadingCommit() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.req.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        SimpleBarProxy bar0 = context.create(SimpleBarProxy.class);
        SimpleBarProxy bar1 = context.create(SimpleBarProxy.class);
        SimpleBarProxy bar2 = context.create(SimpleBarProxy.class);
        SimpleBarProxy bar3 = context.create(SimpleBarProxy.class);
        SimpleBarProxy bar4 = context.create(SimpleBarProxy.class);
        ArrayList<SimpleBarProxy> bars = new ArrayList<SimpleBarProxy>();
        bars.add(bar0);
        bars.add(bar1);
        HashMap<SimpleBarProxy, Integer> barAsKeyMap = new HashMap<SimpleBarProxy, Integer>();
        barAsKeyMap.put(bar2, 4);
        barAsKeyMap.put(bar3, 21);
        HashMap<Integer, SimpleBarProxy> barAsValueMap = new HashMap<Integer, SimpleBarProxy>();
        barAsValueMap.put(41, bar2);
        barAsValueMap.put(141, bar3);
        barAsValueMap.put(43, bar4);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleBarProxy.class, handler);
        Request<SimpleFooProxy> request = context.persistCascadingAndReturnSelf().using(foo);
        SimpleFooProxy editFoo = context.edit(foo);
        editFoo.setOneToManyField(bars);
        editFoo.setSimpleBarKeyMap(barAsKeyMap);
        editFoo.setSimpleBarValueMap(barAsValueMap);
        request.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertFalse(((SimpleEntityProxyId)response.stableId()).isEphemeral());
                Assert.assertEquals(5, handler.persistEventCount);
                Assert.assertEquals(5, handler.updateEventCount);
                Assert.assertEquals(10, handler.totalEventCount);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testCreatePersistCascadingAndReturnSelfEditWithReferences() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        SimpleBarProxy bar = context.create(SimpleBarProxy.class);
        foo.setBarField(bar);
        Request<SimpleFooProxy> fooReq = context.persistCascadingAndReturnSelf().using(foo).with("barField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy returned) {
                Assert.assertTrue(AutoBeanUtils.getAutoBean(returned).isFrozen());
                Assert.assertTrue(AutoBeanUtils.getAutoBean(returned.getBarField()).isFrozen());
                RequestFactoryTest.this.simpleFooRequest().edit(returned);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testCreateReferencePersistCascadingAndReturnSelfEdit() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                SimpleFooProxy foo = context.edit(response);
                SimpleBarProxy bar = context.create(SimpleBarProxy.class);
                foo.setBarField(bar);
                Request<SimpleFooProxy> fooReq = context.persistCascadingAndReturnSelf().using(foo).with("barField");
                fooReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy returned) {
                        Assert.assertTrue(AutoBeanUtils.getAutoBean(returned).isFrozen());
                        Assert.assertTrue(AutoBeanUtils.getAutoBean(returned.getBarField()).isFrozen());
                        RequestFactoryTest.this.simpleFooRequest().edit(returned);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testChangedCreate() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        RequestFactoryTest.assertFalse(context.isChanged());
        foo.setCharField(Character.valueOf('c'));
        RequestFactoryTest.assertTrue(context.isChanged());
        foo.setCharField(null);
        RequestFactoryTest.assertFalse(context.isChanged());
    }

    public void testChangedCreateValueProxy() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleValueProxy foo = context.create(SimpleValueProxy.class);
        RequestFactoryTest.assertFalse(context.isChanged());
        foo.setString("foo");
        RequestFactoryTest.assertTrue(context.isChanged());
        foo.setString(null);
        RequestFactoryTest.assertFalse(context.isChanged());
    }

    public void testChangedEditCollectionsOfEntityProxies() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                foo = RequestFactoryTest.this.checkSerialization(foo);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                foo = context.edit(foo);
                Assert.assertFalse(context.isChanged());
                List<SimpleBarProxy> oldOneToManyField = foo.getOneToManyField();
                ArrayList<SimpleBarProxy> newOneToManyField = new ArrayList<SimpleBarProxy>(oldOneToManyField);
                foo.setOneToManyField(newOneToManyField);
                Assert.assertFalse(context.isChanged());
                foo.getOneToManyField().set(0, context.edit(foo.getOneToManyField().get(0)));
                Assert.assertFalse(context.isChanged());
                foo.getOneToManyField().set(0, context.create(SimpleBarProxy.class));
                Assert.assertTrue(context.isChanged());
                foo.getOneToManyField().set(0, oldOneToManyField.get(0));
                Assert.assertFalse(context.isChanged());
                foo.getOneToManyField().remove(0);
                Assert.assertTrue(context.isChanged());
                foo.setOneToManyField(oldOneToManyField);
                Assert.assertFalse(context.isChanged());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testChangedEditCollectionsOfSimpleValues() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                foo = RequestFactoryTest.this.checkSerialization(foo);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                foo = context.edit(foo);
                Assert.assertFalse(context.isChanged());
                List<Integer> oldNumberListField = foo.getNumberListField();
                ArrayList<Integer> newOneToManuField = new ArrayList<Integer>(oldNumberListField);
                foo.setNumberListField(newOneToManuField);
                Assert.assertFalse(context.isChanged());
                foo.getNumberListField().set(0, 43);
                Assert.assertTrue(context.isChanged());
                foo.getNumberListField().set(0, oldNumberListField.get(0));
                Assert.assertFalse(context.isChanged());
                foo.getNumberListField().remove(0);
                Assert.assertTrue(context.isChanged());
                foo.setNumberListField(oldNumberListField);
                Assert.assertFalse(context.isChanged());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testChangedEditEntityProxies() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                foo = RequestFactoryTest.this.checkSerialization(foo);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                foo = context.edit(foo);
                Assert.assertFalse(context.isChanged());
                SimpleBarProxy oldBarField = foo.getBarField();
                foo.setBarField(context.edit(oldBarField));
                Assert.assertFalse(context.isChanged());
                foo.setBarField(null);
                Assert.assertTrue(context.isChanged());
                foo.setBarField(oldBarField);
                Assert.assertFalse(context.isChanged());
                foo.setBarField(context.create(SimpleBarProxy.class));
                Assert.assertTrue(context.isChanged());
                foo.setBarField(oldBarField);
                Assert.assertFalse(context.isChanged());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testChangedEditSimpleValues() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                foo = RequestFactoryTest.this.checkSerialization(foo);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                foo = context.edit(foo);
                Assert.assertFalse(context.isChanged());
                String newName = "something else;";
                String oldName = foo.getUserName();
                Assert.assertFalse("Don't accidentally set the same name", "something else;".equals(oldName));
                Assert.assertFalse(context.isChanged());
                foo.setUserName("something else;");
                Assert.assertTrue(context.isChanged());
                foo.setUserName(oldName);
                Assert.assertFalse(context.isChanged());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testChangedEditValueProxies() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(1L).with("barField", "oneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                foo = RequestFactoryTest.this.checkSerialization(foo);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                foo = context.edit(foo);
                SimpleValueProxy created = context.create(SimpleValueProxy.class);
                created.setNumber(42);
                created.setString("Hello world!");
                created.setSimpleFoo(foo);
                SimpleValueProxy other = context.create(SimpleValueProxy.class);
                other.setNumber(42);
                other.setString("Hello world!");
                other.setSimpleFoo(foo);
                created.setSimpleValue(Arrays.asList(created, other));
                other.setSimpleValue(Arrays.asList(created, other));
                foo.setSimpleValue(created);
                foo.setSimpleValues(Collections.singletonList(created));
                context.persistAndReturnSelf().using(foo).with("simpleValue.simpleFoo", "simpleValue.simpleValue").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy foo) {
                        foo = RequestFactoryTest.this.checkSerialization(foo);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        foo = context.edit(foo);
                        Assert.assertFalse(context.isChanged());
                        foo.getSimpleValue().setNumber(43);
                        Assert.assertTrue(context.isChanged());
                        foo.getSimpleValue().setNumber(42);
                        Assert.assertFalse(context.isChanged());
                        SimpleValueProxy old = foo.getSimpleValue();
                        SimpleValueProxy created = context.create(SimpleValueProxy.class);
                        foo.setSimpleValue(created);
                        Assert.assertTrue(context.isChanged());
                        foo.setSimpleValue(old.getSimpleValue().get(1));
                        Assert.assertFalse(context.isChanged());
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testChangedNothing() {
        SimpleFooRequest context = this.simpleFooRequest();
        RequestFactoryTest.assertFalse(context.isChanged());
    }

    public void testClassToken() {
        String token = this.req.getHistoryToken(SimpleFooProxy.class);
        RequestFactoryTest.assertEquals(SimpleFooProxy.class, this.req.getProxyClass(token));
        SimpleFooProxy foo = this.simpleFooRequest().create(SimpleFooProxy.class);
        RequestFactoryTest.assertEquals(SimpleFooProxy.class, foo.stableId().getProxyClass());
    }

    public void testCollectionSubProperties() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getSimpleFooWithSubPropertyCollection().with("selfOneToManyField", "selfOneToManyField.fooField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals("I'm here", response.getSelfOneToManyField().get(0).getFooField().getUserName());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testDomainUpcast() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnSimpleFooSubclass().fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(42, response.getIntId());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testDummyCreate() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, handler);
        SimpleFooRequest context = this.simpleFooRequest();
        final SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        final EntityProxyId<SimpleFooProxy> futureId = foo.stableId();
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)futureId).isEphemeral());
        Request<SimpleFooProxy> fooReq = context.persistAndReturnSelf().using(foo);
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                EntityProxyId<SimpleFooProxy> returnedId = returned.stableId();
                Assert.assertEquals(futureId, returnedId);
                Assert.assertFalse(((SimpleEntityProxyId)returnedId).isEphemeral());
                Assert.assertEquals(1, handler.persistEventCount);
                Assert.assertEquals(1, handler.updateEventCount);
                Assert.assertEquals(2, handler.totalEventCount);
                RequestFactoryTest.this.checkStableIdEquals(foo, returned);
                RequestFactoryTest.this.simpleFooRequest().edit(returned);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testDummyCreateBar() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        final SimpleBarProxy foo = context.create(SimpleBarProxy.class);
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)foo.stableId()).isEphemeral());
        Request<SimpleBarProxy> fooReq = context.persistAndReturnSelf().using(foo);
        fooReq.fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                Assert.assertFalse(((SimpleEntityProxyId)foo.stableId()).isEphemeral());
                RequestFactoryTest.this.checkStableIdEquals(foo, returned);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testDummyCreateList() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        final SimpleBarProxy bar = context.create(SimpleBarProxy.class);
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)bar.stableId()).isEphemeral());
        Request<SimpleBarProxy> fooReq = context.returnFirst(Collections.singletonList(bar));
        fooReq.fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                Assert.assertFalse(((SimpleEntityProxyId)bar.stableId()).isEphemeral());
                Assert.assertFalse(((SimpleEntityProxyId)returned.stableId()).isEphemeral());
                RequestFactoryTest.this.checkStableIdEquals(bar, returned);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testEditAcrossContexts() {
        SimpleFooRequest contextA = this.simpleFooRequest();
        final SimpleFooRequest contextB = this.simpleFooRequest();
        SimpleFooProxy fromA = contextA.create(SimpleFooProxy.class);
        try {
            contextB.edit(fromA);
            RequestFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            contextB.persistAndReturnSelf().using(fromA).fire(new Receiver<SimpleFooProxy>(){

                @Override
                public void onSuccess(SimpleFooProxy response) {
                    Assert.fail();
                }
            });
            RequestFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.delayTestFinish(30000);
        contextA.findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                contextB.edit(response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testEmptyRequestBlankObject() {
        this.delayTestFinish(30000);
        RequestTransport transport = this.req.getRequestTransport();
        transport.send("{}", new RequestTransport.TransportReceiver(){

            @Override
            public void onTransportFailure(ServerFailure failure) {
                Assert.fail();
            }

            @Override
            public void onTransportSuccess(String payload) {
                ResponseMessage resp = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, ResponseMessage.class, payload).as();
                ServerFailureMessage failure = resp.getGeneralFailure();
                Assert.assertNotNull(failure);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testEmptyRequestZeroLength() {
        this.delayTestFinish(30000);
        RequestTransport transport = this.req.getRequestTransport();
        transport.send("", new RequestTransport.TransportReceiver(){

            @Override
            public void onTransportFailure(ServerFailure failure) {
                RequestFactoryTest.this.finishTestAndReset();
            }

            @Override
            public void onTransportSuccess(String payload) {
                Assert.fail("Should not have succeeded");
            }
        });
    }

    public void testEnumOnlyUsedByRequestContext() {
        this.delayTestFinish(30000);
        SimpleFooRequest ctx = this.simpleFooRequest();
        ctx.receiveEnum(OnlyUsedByRequestContextMethod.FOO).fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testEnumProperty() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals((Object)SimpleEnum.FOO, (Object)response.getEnumField());
                SimpleFooRequest ctx = RequestFactoryTest.this.simpleFooRequest();
                response = ctx.edit(response);
                response.setEnumField(SimpleEnum.BAR);
                ctx.persistAndReturnSelf().using(response).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        Assert.assertEquals((Object)SimpleEnum.BAR, (Object)response.getEnumField());
                        SimpleFooRequest ctx = RequestFactoryTest.this.simpleFooRequest();
                        response = ctx.edit(response);
                        response.setEnumField(null);
                        ctx.persistAndReturnSelf().using(response).fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                Assert.assertNull((Object)response.getEnumField());
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testEntityChainFromListOfValueObjects() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnValueProxies().with("simpleFoo.fooField").fire(new Receiver<List<SimpleValueProxy>>(){

            @Override
            public void onSuccess(List<SimpleValueProxy> response) {
                Assert.assertTrue("Issue 6710 only manifested itself with 2 value proxies at least", response.size() >= 2);
                for (SimpleValueProxy value : response) {
                    Assert.assertNotNull(value.getSimpleFoo());
                    Assert.assertNotNull(value.getSimpleFoo().getFooField());
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntity() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(42, response.getIntId());
                Assert.assertEquals("GWT", response.getUserName());
                Assert.assertEquals(8L, response.getLongField());
                Assert.assertEquals((Object)SimpleEnum.FOO, (Object)response.getEnumField());
                Assert.assertEquals(null, response.getBarField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntityWithRelation() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).with("barField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(42, response.getIntId());
                Assert.assertEquals("GWT", response.getUserName());
                Assert.assertEquals(8L, response.getLongField());
                Assert.assertEquals((Object)SimpleEnum.FOO, (Object)response.getEnumField());
                Assert.assertNotNull(response.getBarField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchList() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findAll().fire(new Receiver<List<SimpleFooProxy>>(){

            @Override
            public void onSuccess(List<SimpleFooProxy> responseList) {
                SimpleFooProxy response = RequestFactoryTest.this.checkSerialization(responseList.get(0));
                Assert.assertEquals(42, response.getIntId());
                Assert.assertEquals("GWT", response.getUserName());
                Assert.assertEquals(8L, response.getLongField());
                Assert.assertEquals((Object)SimpleEnum.FOO, (Object)response.getEnumField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchSet() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findAsSet().fire(new Receiver<Set<SimpleBarProxy>>(){

            @Override
            public void onSuccess(Set<SimpleBarProxy> response) {
                Assert.assertEquals(2, response.size());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testFindFindEdit() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, handler);
        this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy newFoo) {
                newFoo = RequestFactoryTest.this.checkSerialization(newFoo);
                Assert.assertEquals(1, handler.updateEventCount);
                Assert.assertEquals(1, handler.totalEventCount);
                RequestFactoryTest.this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy newFoo) {
                        newFoo = RequestFactoryTest.this.checkSerialization(newFoo);
                        Assert.assertEquals(1, handler.updateEventCount);
                        Assert.assertEquals(1, handler.totalEventCount);
                        SimpleFooRequest context = RequestFactoryTest.this.req.simpleFooRequest();
                        Request<Void> mutateRequest = context.persist().using(newFoo);
                        newFoo = context.edit(newFoo);
                        newFoo.setUserName("Ray");
                        mutateRequest.fire(new Receiver<Void>(){

                            @Override
                            public void onSuccess(Void response) {
                                Assert.assertEquals(2, handler.updateEventCount);
                                Assert.assertEquals(2, handler.totalEventCount);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testForwardReferenceDecode() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getTripletReference().with("selfOneToManyField.selfOneToManyField.fooField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertNotNull(response.getSelfOneToManyField().get(0));
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField());
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField().get(0));
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField().get(0).getFooField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testForwardReferenceWildcardDecode() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getTripletReference().with("selfOneToManyField.*.fooField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertNotNull(response.getSelfOneToManyField().get(0));
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField());
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField().get(0));
                Assert.assertNotNull(response.getSelfOneToManyField().get(0).getSelfOneToManyField().get(0).getFooField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testGetEventBus() {
        RequestFactoryTest.assertEquals(this.eventBus, this.req.getEventBus());
    }

    public void testGetListLongId() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findAll().with("barField.userName").fire(new Receiver<List<SimpleFooProxy>>(){

            @Override
            public void onSuccess(List<SimpleFooProxy> response) {
                Assert.assertEquals(2, response.size());
                for (SimpleFooProxy foo : response) {
                    foo = RequestFactoryTest.this.checkSerialization(foo);
                    Assert.assertNotNull(foo.stableId());
                    Assert.assertEquals("FOO", foo.getBarField().getUserName());
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testGetListStringId() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findAll().fire(new Receiver<List<SimpleBarProxy>>(){

            @Override
            public void onSuccess(List<SimpleBarProxy> response) {
                Assert.assertEquals(2, response.size());
                for (SimpleBarProxy bar : response) {
                    bar = RequestFactoryTest.this.checkSerialization(bar);
                    Assert.assertNotNull(bar.stableId());
                    RequestFactoryTest.this.finishTestAndReset();
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testHistoryToken() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        SimpleBarProxy foo = context.create(SimpleBarProxy.class);
        final EntityProxyId<SimpleBarProxy> futureId = foo.stableId();
        final String futureToken = this.req.getHistoryToken(futureId);
        RequestFactoryTest.assertEquals(futureId, this.req.getProxyId(futureToken));
        RequestFactoryTest.assertEquals(futureId.getProxyClass(), this.req.getProxyClass(futureToken));
        Request<SimpleBarProxy> fooReq = context.persistAndReturnSelf().using(foo);
        fooReq.fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                EntityProxyId<SimpleBarProxy> persistedId = returned.stableId();
                String persistedToken = RequestFactoryTest.this.req.getHistoryToken(returned.stableId());
                Assert.assertFalse(futureToken.equals(persistedToken));
                Assert.assertEquals(persistedToken, RequestFactoryTest.this.req.getHistoryToken(futureId));
                Assert.assertEquals(futureId, RequestFactoryTest.this.req.getProxyId(futureToken));
                Assert.assertEquals(futureId, RequestFactoryTest.this.req.getProxyId(persistedToken));
                Assert.assertEquals(futureId.getProxyClass(), RequestFactoryTest.this.req.getProxyClass(persistedToken));
                Assert.assertEquals(persistedId, RequestFactoryTest.this.req.getProxyId(futureToken));
                Assert.assertEquals(persistedId, RequestFactoryTest.this.req.getProxyId(persistedToken));
                Assert.assertEquals(persistedId.getProxyClass(), RequestFactoryTest.this.req.getProxyClass(futureToken));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testInstanceServiceRequest() {
        this.delayTestFinish(30000);
        this.req.instanceServiceRequest().add(5).fire(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals(10, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testInstanceServiceRequestByName() {
        this.delayTestFinish(30000);
        this.req.instanceServiceRequestByName().add(5).fire(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertEquals(10, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testLoggingService() {
        this.delayTestFinish(30000);
        String logRecordJson = "{" + "\"level\": \"ALL\", " + "\"loggerName\": \"logger\", " + "\"msg\": \"Hi mom\", " + "\"timestamp\": \"1234567890\"," + "\"thrown\": {}" + "}";
        this.req.loggingRequest().logMessage(logRecordJson).fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testMethodWithSideEffectDeleteChild() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler fooHandler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, fooHandler);
        final RequestFactoryTestBase.SimpleFooEventHandler barHandler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleBarProxy.class, barHandler);
        SimpleBarRequest context = this.req.simpleBarRequest();
        final SimpleBarProxy bar = context.create(SimpleBarProxy.class);
        context.persistAndReturnSelf().using(bar).fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy persistentBar) {
                persistentBar = RequestFactoryTest.this.checkSerialization(persistentBar);
                SimpleFooRequest context = RequestFactoryTest.this.req.simpleFooRequest();
                SimpleFooProxy foo = context.create(SimpleFooProxy.class);
                Request<SimpleFooProxy> persistRequest = context.persistAndReturnSelf().using(foo).with("barField");
                foo = context.edit(foo);
                foo.setUserName("John");
                foo.setBarField(bar);
                persistRequest.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy persistentFoo) {
                        persistentFoo = RequestFactoryTest.this.checkSerialization(persistentFoo);
                        SimpleFooRequest context = RequestFactoryTest.this.req.simpleFooRequest();
                        Request<Void> deleteRequest = context.deleteBar().using(persistentFoo);
                        deleteRequest.fire(new Receiver<Void>(){

                            @Override
                            public void onSuccess(Void response) {
                                Assert.assertEquals(1, fooHandler.persistEventCount);
                                Assert.assertEquals(2, fooHandler.updateEventCount);
                                Assert.assertEquals(3, fooHandler.totalEventCount);
                                Assert.assertEquals(1, barHandler.persistEventCount);
                                Assert.assertEquals(1, barHandler.updateEventCount);
                                Assert.assertEquals(1, barHandler.deleteEventCount);
                                Assert.assertEquals(3, barHandler.totalEventCount);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testMethodWithSideEffects() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, handler);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy newFoo) {
                newFoo = RequestFactoryTest.this.checkSerialization(newFoo);
                Assert.assertEquals(1, handler.updateEventCount);
                Assert.assertEquals(1, handler.totalEventCount);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                final Request<Long> mutateRequest = context.countSimpleFooWithUserNameSideEffect().using(newFoo);
                newFoo = context.edit(newFoo);
                newFoo.setUserName("Ray");
                mutateRequest.fire(new Receiver<Long>(){

                    @Override
                    public void onSuccess(Long response) {
                        RequestFactoryTest.this.assertCannotFire(mutateRequest);
                        Assert.assertEquals(new Long(2L), response);
                        Assert.assertEquals(2, handler.updateEventCount);
                        Assert.assertEquals(2, handler.totalEventCount);
                        RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy finalFoo) {
                                finalFoo = RequestFactoryTest.this.checkSerialization(finalFoo);
                                Assert.assertEquals("Ray", finalFoo.getUserName());
                                Assert.assertEquals(2, handler.updateEventCount);
                                Assert.assertEquals(2, handler.totalEventCount);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
                try {
                    newFoo.setUserName("Barney");
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
    }

    public void testMultipleEdits() {
        SimpleFooRequest c1 = this.req.simpleFooRequest();
        SimpleFooProxy proxy = c1.create(SimpleFooProxy.class);
        RequestFactoryTest.assertSame(proxy, c1.edit(c1.edit(proxy)));
        SimpleFooRequest c2 = this.req.simpleFooRequest();
        try {
            c2.edit(proxy);
            RequestFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoOpRequest() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullEntityProxyResult() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnNullSimpleFoo().with("fooField").fire(new NullReceiver());
    }

    public void testNullEntityFieldResult() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getSimpleFooWithNullRelationship().with("fooField.fooField.fooField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy v) {
                RequestFactoryTest.this.checkSerialization(v);
                Assert.assertNull(v.getFooField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullListRequest() {
        this.delayTestFinish(30000);
        Request<Void> fooReq = this.req.simpleFooRequest().receiveNullList(null);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullListResult() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnNullList().fire(new NullReceiver());
    }

    public void testNullSimpleFooRequest() {
        this.delayTestFinish(30000);
        Request<Void> fooReq = this.req.simpleFooRequest().receiveNullSimpleFoo(null);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullStringInstanceRequest() {
        this.delayTestFinish(30000);
        this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Request<Void> fooReq = RequestFactoryTest.this.req.simpleFooRequest().receiveNull(null).using(response);
                fooReq.fire(new Receiver<Void>(){

                    @Override
                    public void onSuccess(Void v) {
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testNullStringRequest() {
        this.delayTestFinish(30000);
        Request<Void> fooReq = this.req.simpleFooRequest().receiveNullString(null);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullStringResult() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnNullString().fire(new NullReceiver());
    }

    public void testNullValueInEntityListRequest() {
        this.delayTestFinish(30000);
        this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                ArrayList<SimpleFooProxy> list = new ArrayList<SimpleFooProxy>();
                list.add(response);
                list.add(null);
                Request<Void> fooReq = RequestFactoryTest.this.req.simpleFooRequest().receiveNullValueInEntityList(list);
                fooReq.fire(new Receiver<Void>(){

                    @Override
                    public void onSuccess(Void v) {
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testNullValueInEntityListResponse() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.req.simpleFooRequest().getNullInEntityList().with("selfOneToManyField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy v) {
                List<SimpleFooProxy> manyFoos = v.getSelfOneToManyField();
                Assert.assertEquals(3, manyFoos.size());
                Assert.assertNotNull(manyFoos.get(0));
                Assert.assertNull(manyFoos.get(1));
                Assert.assertNotNull(manyFoos.get(2));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullValueInEntityListResponseWithWildcard() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.req.simpleFooRequest().getNullInEntityList().with("selfOneToManyField.*.fooField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo0) {
                List<SimpleFooProxy> manyFoos = foo0.getSelfOneToManyField();
                Assert.assertEquals(3, manyFoos.size());
                Assert.assertSame(foo0, manyFoos.get(0).getSelfOneToManyField().get(0));
                Assert.assertNull(manyFoos.get(1));
                Assert.assertSame(foo0, manyFoos.get(2).getSelfOneToManyField().get(0));
                Assert.assertSame(foo0, manyFoos.get(2).getFooField().getFooField());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullValueInEntityListResponseWithLongResolvePaths() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.req.simpleFooRequest().getNullInEntityList().with("selfOneToManyField.selfOneToManyField.selfOneToManyField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy v) {
                Assert.assertEquals(3, v.getSelfOneToManyField().size());
                Assert.assertNotNull(v.getSelfOneToManyField().get(0));
                Assert.assertNull(v.getSelfOneToManyField().get(1));
                Assert.assertNotNull(v.getSelfOneToManyField().get(2));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullValueInIntegerListRequest() {
        this.delayTestFinish(30000);
        List<Integer> list = Arrays.asList(1, 2, null);
        Request<Void> fooReq = this.req.simpleFooRequest().receiveNullValueInIntegerList(list);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testNullValueInStringListRequest() {
        this.delayTestFinish(30000);
        List<String> list = Arrays.asList("nonnull", "null", null);
        Request<Void> fooReq = this.req.simpleFooRequest().receiveNullValueInStringList(list);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testEntityProxyIdRequest() {
        this.delayTestFinish(30000);
        this.req.simpleFooRequest().findSimpleFooById(1L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo) {
                Request<SimpleFooProxy> fooReq = RequestFactoryTest.this.req.simpleFooRequest().receiveEntityProxyId(foo.stableId());
                fooReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy v) {
                        Assert.assertEquals("receiveEntityProxyId", v.getUserName());
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testNullEntityProxyIdRequest() {
        this.delayTestFinish(30000);
        this.req.simpleFooRequest().receiveNullEntityProxyId(null).fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void foo) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testOnlyUsedInList() {
        OnlyUsedInListProxy proxy = this.simpleFooRequest().create(OnlyUsedInListProxy.class);
        RequestFactoryTest.assertNotNull(proxy);
    }

    public void testOperationOnlyMessage() {
        this.delayTestFinish(30000);
        SimpleFooRequest ctx = this.simpleFooRequest();
        SimpleFooProxy proxy = ctx.create(SimpleFooProxy.class);
        proxy.setUserName("GWT");
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPersistAllValueTypes() {
        this.delayTestFinish(30000);
        SimpleFooRequest r = this.simpleFooRequest();
        SimpleFooProxy f = r.create(SimpleFooProxy.class);
        f.setUserName("user name");
        f.setByteField((byte)100);
        f.setShortField((short)12345);
        f.setFloatField(Float.valueOf(1234.56f));
        f.setDoubleField(1.2345);
        f.setLongField(1234L);
        f.setBoolField(false);
        f.setOtherBoolField(true);
        f.setCreated(new java.util.Date(397387389L));
        r.persistAndReturnSelf().using(f).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy f) {
                f = RequestFactoryTest.this.checkSerialization(f);
                Assert.assertEquals("user name", f.getUserName());
                Assert.assertEquals((Object)100, f.getByteField());
                Assert.assertEquals((Object)12345, f.getShortField());
                Assert.assertEquals(0, (int)Math.rint(123456.0f - 100.0f * f.getFloatField().floatValue()));
                Assert.assertEquals(1.2345, f.getDoubleField());
                Assert.assertEquals((Object)1234L, f.getLongField());
                Assert.assertFalse(f.getBoolField());
                Assert.assertTrue(f.getOtherBoolField());
                Assert.assertEquals(new java.util.Date(397387389L), f.getCreated());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPersistedEntityWithNullVersion() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getSimpleFooWithNullVersion().fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onFailure(ServerFailure error) {
                RequestFactoryTest.this.finishTestAndReset();
            }

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.fail();
            }
        });
    }

    public void testPersistExistingEntityExistingRelation() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findSimpleBarById("999L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy barProxy = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy fooProxy) {
                        fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        fooProxy = context.edit(fooProxy);
                        fooProxy.setBarField(barProxy);
                        fooProxy.setUserName("Hello");
                        fooProxy.setByteField((byte)55);
                        context.persistAndReturnSelf().using(fooProxy).with("barField").fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy received) {
                                received = RequestFactoryTest.this.checkSerialization(received);
                                Assert.assertNotNull(received.getBarField());
                                Assert.assertEquals(barProxy.stableId(), received.getBarField().stableId());
                                Assert.assertEquals("Hello", received.getUserName());
                                Assert.assertTrue(55 == received.getByteField());
                                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                                received = context.edit(received);
                                received.setBarField(null);
                                received.setUserName(null);
                                received.setByteField(null);
                                context.persistAndReturnSelf().using(received).fire(new Receiver<SimpleFooProxy>(){

                                    @Override
                                    public void onSuccess(SimpleFooProxy response) {
                                        response = RequestFactoryTest.this.checkSerialization(response);
                                        Assert.assertNull(response.getBarField());
                                        Assert.assertNull(response.getUserName());
                                        Assert.assertNull(response.getByteField());
                                        RequestFactoryTest.this.finishTestAndReset();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistExistingEntityNewRelation() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        SimpleBarProxy makeABar = context.create(SimpleBarProxy.class);
        Request<SimpleBarProxy> persistRequest = context.persistAndReturnSelf().using(makeABar);
        makeABar = context.edit(makeABar);
        makeABar.setUserName("Amit");
        persistRequest.fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy persistedBar = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<Void> fooReq = context.persist().using(response);
                        response = context.edit(response);
                        response.setBarField(persistedBar);
                        fooReq.fire(new Receiver<Void>(){

                            @Override
                            public void onSuccess(Void response) {
                                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).with("barField.userName").fire(new Receiver<SimpleFooProxy>(){

                                    @Override
                                    public void onSuccess(SimpleFooProxy finalFooProxy) {
                                        finalFooProxy = RequestFactoryTest.this.checkSerialization(finalFooProxy);
                                        Assert.assertEquals("Amit", finalFooProxy.getBarField().getUserName());
                                        RequestFactoryTest.this.finishTestAndReset();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistFutureToFuture() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        final SimpleBarProxy newBar = context.create(SimpleBarProxy.class);
        Request<SimpleFooProxy> fooReq = context.persistAndReturnSelf().using(newFoo).with("barField");
        newFoo = context.edit(newFoo);
        newFoo.setBarField(newBar);
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertNotNull(response.getBarField());
                Assert.assertEquals(newBar.stableId(), response.getBarField().stableId());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPersistNewEntityExistingRelation() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.edit(context.create(SimpleFooProxy.class));
        final Request<Void> fooReq = context.persist().using(newFoo);
        newFoo.setUserName("Ray");
        final SimpleFooProxy finalFoo = newFoo;
        this.simpleBarRequest().findSimpleBarById("999L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                finalFoo.setBarField(response);
                fooReq.fire(new Receiver<Void>(){

                    @Override
                    public void onSuccess(Void response) {
                        RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy finalFooProxy) {
                                finalFooProxy = RequestFactoryTest.this.checkSerialization(finalFooProxy);
                                Assert.assertEquals("GWT", finalFooProxy.getUserName());
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistNewEntityNewRelation() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> fooReq = context.persistAndReturnSelf().using(newFoo);
        newFoo = context.edit(newFoo);
        newFoo.setUserName("Ray");
        SimpleBarRequest context2 = this.simpleBarRequest();
        SimpleBarProxy newBar = context2.create(SimpleBarProxy.class);
        final Request<SimpleBarProxy> barReq = context2.persistAndReturnSelf().using(newBar);
        newBar = context2.edit(newBar);
        newBar.setUserName("Amit");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                final SimpleFooProxy persistedFoo = RequestFactoryTest.this.checkSerialization(response);
                barReq.fire(new Receiver<SimpleBarProxy>(){

                    @Override
                    public void onSuccess(SimpleBarProxy response) {
                        SimpleBarProxy persistedBar = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertEquals("Ray", persistedFoo.getUserName());
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<Void> fooReq2 = context.persist().using(persistedFoo);
                        SimpleFooProxy editablePersistedFoo = context.edit(persistedFoo);
                        editablePersistedFoo.setBarField(persistedBar);
                        fooReq2.fire(new Receiver<Void>(){

                            @Override
                            public void onSuccess(Void response) {
                                RequestFactoryTest.this.req.simpleFooRequest().findSimpleFooById(persistedFoo.getId()).with("barField.userName").fire(new Receiver<SimpleFooProxy>(){

                                    @Override
                                    public void onSuccess(SimpleFooProxy finalFooProxy) {
                                        finalFooProxy = RequestFactoryTest.this.checkSerialization(finalFooProxy);
                                        Assert.assertEquals("Amit", finalFooProxy.getBarField().getUserName());
                                        RequestFactoryTest.this.finishTestAndReset();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistOneToManyExistingEntityExistingRelation() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findSimpleBarById("999L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy barProxy = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).with("oneToManyField").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy fooProxy) {
                        fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy).with("oneToManyField");
                        fooProxy = context.edit(fooProxy);
                        List<SimpleBarProxy> barProxyList = fooProxy.getOneToManyField();
                        final int listCount = barProxyList.size();
                        barProxyList.add(barProxy);
                        updReq.fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(response.getOneToManyField().size(), listCount + 1);
                                RequestFactoryTest.this.assertContains(response.getOneToManyField(), barProxy);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistRecursiveRelation() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy rayFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> persistRay = context.persistAndReturnSelf().using(rayFoo);
        rayFoo = context.edit(rayFoo);
        rayFoo.setUserName("Ray");
        rayFoo.setFooField(rayFoo);
        persistRay.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPersistRelation() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy rayFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> persistRay = context.persistAndReturnSelf().using(rayFoo);
        rayFoo = context.edit(rayFoo);
        rayFoo.setUserName("Ray");
        persistRay.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                final SimpleFooProxy persistedRay = RequestFactoryTest.this.checkSerialization(response);
                SimpleBarRequest context = RequestFactoryTest.this.simpleBarRequest();
                SimpleBarProxy amitBar = context.create(SimpleBarProxy.class);
                Request<SimpleBarProxy> persistAmit = context.persistAndReturnSelf().using(amitBar);
                amitBar = context.edit(amitBar);
                amitBar.setUserName("Amit");
                persistAmit.fire(new Receiver<SimpleBarProxy>(){

                    @Override
                    public void onSuccess(SimpleBarProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<SimpleFooProxy> persistRelationship = context.persistAndReturnSelf().using(persistedRay).with("barField");
                        SimpleFooProxy newRec = context.edit(persistedRay);
                        newRec.setBarField(response);
                        persistRelationship.fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals("Amit", response.getBarField().getUserName());
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistSelfOneToManyExistingEntityExistingRelation() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).with("selfOneToManyField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy).with("selfOneToManyField");
                fooProxy = context.edit(fooProxy);
                List<SimpleFooProxy> fooProxyList = fooProxy.getSelfOneToManyField();
                final int listCount = fooProxyList.size();
                fooProxyList.add(fooProxy);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertEquals(response.getSelfOneToManyField().size(), listCount + 1);
                        RequestFactoryTest.this.assertContains(response.getSelfOneToManyField(), response);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueList() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                fooProxy.getNumberListField().add(100);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertTrue(response.getNumberListField().contains(100));
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueListNull() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                fooProxy.setNumberListField(null);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        List<Integer> list = response.getNumberListField();
                        Assert.assertNull(list);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueListRemove() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                final int oldValue = fooProxy.getNumberListField().remove(0);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertFalse(response.getNumberListField().contains(oldValue));
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueListReplace() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                ArrayList<Integer> al = new ArrayList<Integer>();
                al.add(5);
                al.add(8);
                al.add(13);
                fooProxy.setNumberListField(al);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        List<Integer> list = response.getNumberListField();
                        Assert.assertEquals(5, list.get(0));
                        Assert.assertEquals(8, list.get(1));
                        Assert.assertEquals(13, list.get(2));
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueListReverse() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                final ArrayList<Integer> al = new ArrayList<Integer>();
                List<Integer> listField = fooProxy.getNumberListField();
                al.addAll(listField);
                Collections.reverse(listField);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Collections.reverse(al);
                        Assert.assertTrue(response.getNumberListField().equals(al));
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueListSetIndex() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy fooProxy) {
                fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy);
                fooProxy = context.edit(fooProxy);
                fooProxy.getNumberListField().set(0, 10);
                updReq.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        Assert.assertTrue((response = RequestFactoryTest.this.checkSerialization(response)).getNumberListField().get(0) == 10);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPersistValueSetAddNew() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        SimpleBarProxy newBar = context.create(SimpleBarProxy.class);
        context.persistAndReturnSelf().using(newBar).fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy barProxy = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).with("oneToManySetField").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy fooProxy) {
                        fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy).with("oneToManySetField");
                        fooProxy = context.edit(fooProxy);
                        Set<SimpleBarProxy> setField = fooProxy.getOneToManySetField();
                        final int listCount = setField.size();
                        setField.add(barProxy);
                        updReq.fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(listCount + 1, response.getOneToManySetField().size());
                                RequestFactoryTest.this.assertContains(response.getOneToManySetField(), barProxy);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistValueSetAlreadyExists() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findSimpleBarById("1L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy barProxy = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).with("oneToManySetField").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy fooProxy) {
                        fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy).with("oneToManySetField");
                        fooProxy = context.edit(fooProxy);
                        Set<SimpleBarProxy> setField = fooProxy.getOneToManySetField();
                        final int listCount = setField.size();
                        RequestFactoryTest.this.assertContains(setField, barProxy);
                        setField.add(barProxy);
                        updReq.fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(response.getOneToManySetField().size(), listCount);
                                RequestFactoryTest.this.assertContains(response.getOneToManySetField(), barProxy);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPersistValueSetRemove() {
        this.delayTestFinish(30000);
        this.simpleBarRequest().findSimpleBarById("1L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final SimpleBarProxy barProxy = RequestFactoryTest.this.checkSerialization(response);
                RequestFactoryTest.this.simpleFooRequest().findSimpleFooById(999L).with("oneToManySetField").fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy fooProxy) {
                        fooProxy = RequestFactoryTest.this.checkSerialization(fooProxy);
                        SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                        Request<SimpleFooProxy> updReq = context.persistAndReturnSelf().using(fooProxy).with("oneToManySetField");
                        fooProxy = context.edit(fooProxy);
                        Set<SimpleBarProxy> setField = fooProxy.getOneToManySetField();
                        final int listCount = setField.size();
                        RequestFactoryTest.this.assertContains(setField, barProxy);
                        setField.remove(context.edit(barProxy));
                        RequestFactoryTest.this.assertNotContains(setField, barProxy);
                        updReq.fire(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(listCount - 1, response.getOneToManySetField().size());
                                RequestFactoryTest.this.assertNotContains(response.getOneToManySetField(), barProxy);
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testPrimitiveList() {
        this.delayTestFinish(30000);
        Request<List<Integer>> fooReq = this.simpleFooRequest().getNumberList();
        fooReq.fire(new Receiver<List<Integer>>(){

            @Override
            public void onSuccess(List<Integer> response) {
                Assert.assertEquals(3, response.size());
                Assert.assertEquals(1, response.get(0));
                Assert.assertEquals(2, response.get(1));
                Assert.assertEquals(3, response.get(2));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveListAsParameter() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.simpleFooRequest().findSimpleFooById(999L);
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Request<Integer> sumReq = RequestFactoryTest.this.simpleFooRequest().sum(Arrays.asList(1, 2, 3)).using(response);
                sumReq.fire(new Receiver<Integer>(){

                    @Override
                    public void onSuccess(Integer response) {
                        Assert.assertEquals(6, response);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testPrimitiveListBigDecimalAsParameter() {
        this.delayTestFinish(30000);
        final ArrayList<BigDecimal> testList = new ArrayList<BigDecimal>();
        testList.add(BigDecimal.TEN);
        testList.add(new BigDecimal("12345.6789"){});
        this.simpleFooRequest().processBigDecimalList(testList).fire(new Receiver<List<BigDecimal>>(){

            @Override
            public void onSuccess(List<BigDecimal> response) {
                Assert.assertEquals(testList, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveListBigIntegerAsParameter() {
        this.delayTestFinish(30000);
        final ArrayList<BigInteger> testList = new ArrayList<BigInteger>();
        testList.add(BigInteger.TEN);
        testList.add(new BigInteger("12345"){});
        this.simpleFooRequest().processBigIntegerList(testList).fire(new Receiver<List<BigInteger>>(){

            @Override
            public void onSuccess(List<BigInteger> response) {
                Assert.assertEquals(testList, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveListBooleanAsParameter() {
        this.delayTestFinish(30000);
        Request<Boolean> procReq = this.simpleFooRequest().processBooleanList(Arrays.asList(true, false));
        procReq.fire(new Receiver<Boolean>(){

            @Override
            public void onSuccess(Boolean response) {
                Assert.assertEquals(true, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveListDateAsParameter() {
        this.delayTestFinish(30000);
        java.util.Date date = new java.util.Date(90, 0, 1);
        Date sqlDate = new Date(90, 0, 2);
        Time sqlTime = new Time(1, 2, 3);
        Timestamp sqlTimestamp = new Timestamp(12345L);
        final List<java.util.Date> testList = Arrays.asList(date, sqlDate, sqlTime, sqlTimestamp);
        this.simpleFooRequest().processDateList(testList).fire(new Receiver<List<java.util.Date>>(){

            @Override
            public void onSuccess(List<java.util.Date> response) {
                Assert.assertEquals(testList.size(), response.size());
                Iterator expected = testList.iterator();
                Iterator<java.util.Date> actual = response.iterator();
                while (expected.hasNext()) {
                    Assert.assertEquals(((java.util.Date)expected.next()).getTime(), actual.next().getTime());
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveListEnumAsParameter() {
        this.delayTestFinish(30000);
        Request<SimpleEnum> procReq = this.simpleFooRequest().processEnumList(Arrays.asList(SimpleEnum.BAR));
        procReq.fire(new Receiver<SimpleEnum>(){

            @Override
            public void onSuccess(SimpleEnum response) {
                Assert.assertEquals((Object)SimpleEnum.BAR, (Object)response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveParameter() {
        this.delayTestFinish(30000);
        SimpleFooRequest ctx = this.simpleFooRequest();
        ctx.add(3, 5).to(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                Assert.assertTrue(8 == response);
            }
        });
        ctx.add(4.0, 5.0).to(new Receiver<Double>(){

            @Override
            public void onSuccess(Double response) {
                Assert.assertTrue(9.0 == response);
            }
        });
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveSet() {
        this.delayTestFinish(30000);
        Request<Set<Integer>> fooReq = this.simpleFooRequest().getNumberSet();
        fooReq.fire(new Receiver<Set<Integer>>(){

            @Override
            public void onSuccess(Set<Integer> response) {
                Assert.assertEquals(3, response.size());
                Assert.assertTrue(response.contains(1));
                Assert.assertTrue(response.contains(2));
                Assert.assertTrue(response.contains(3));
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPrimitiveString() {
        this.delayTestFinish(30000);
        String testString = "test\"string'with\nstring\u2060characters\t";
        Request<String> fooReq = this.simpleFooRequest().processString("test\"string'with\nstring\u2060characters\t");
        fooReq.fire(new Receiver<String>(){

            @Override
            public void onSuccess(String response) {
                Assert.assertEquals("test\"string'with\nstring\u2060characters\t", response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPropertyRefsOnRecursiveProxyStructures() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().getFlattenedTripletReference().with("selfOneToManyField").fire(new Receiver<List<SimpleFooProxy>>(){

            @Override
            public void onSuccess(List<SimpleFooProxy> response) {
                for (int i = 0; i < response.size(); ++i) {
                    SimpleFooProxy proxy = response.get(i);
                    RequestFactoryTest.this.checkSerialization(proxy);
                    Assert.assertNotNull("Missing selfOneToManyField for item at index " + i, proxy.getSelfOneToManyField());
                    Assert.assertEquals(1, proxy.getSelfOneToManyField().size());
                    SimpleFooProxy next = response.get(Math.min(i + 1, response.size() - 1));
                    Assert.assertSame("Item at index " + i + " does not link the following item in its selfOneToManyField", proxy.getSelfOneToManyField().get(0), next);
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPropertyRefsOnWildcardChain() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.req.simpleFooRequest().getLongChain().with("fooField.*.*.fooField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy foo0) {
                Assert.assertNull(foo0.getSelfOneToManyField());
                SimpleFooProxy foo1 = foo0.getFooField();
                SimpleFooProxy foo2 = foo1.getFooField();
                SimpleFooProxy foo3 = foo2.getFooField();
                SimpleFooProxy foo4 = foo3.getFooField();
                SimpleFooProxy foo5 = foo4.getFooField();
                Assert.assertNotNull(foo1);
                Assert.assertNotNull(foo2);
                Assert.assertNotNull(foo3);
                Assert.assertNotNull(foo4);
                Assert.assertNull(foo5);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testPropertyRefsOnSameObjectReturnedTwice() {
        this.delayTestFinish(30000);
        SimpleFooRequest request = this.simpleFooRequest();
        request.findSimpleFooById(1L);
        request.findAll().with("barField").to(new Receiver<List<SimpleFooProxy>>(){

            @Override
            public void onSuccess(List<SimpleFooProxy> response) {
                for (SimpleFooProxy proxy : response) {
                    proxy = RequestFactoryTest.this.checkSerialization(proxy);
                    Assert.assertNotNull("barField has not been retrieved on id=" + proxy.getId(), proxy.getBarField());
                }
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
        request.fire();
    }

    public void testProxyList() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.simpleFooRequest().findSimpleFooById(999L).with("oneToManyField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(2, response.getOneToManyField().size());
                response = RequestFactoryTest.this.simpleFooRequest().edit(response);
                response.getOneToManyField().get(0).setUserName("canMutate");
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testProxyListAsParameter() {
        this.delayTestFinish(30000);
        Request<SimpleFooProxy> fooReq = this.simpleFooRequest().findSimpleFooById(999L).with("selfOneToManyField");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                final SimpleFooProxy fooProxy = RequestFactoryTest.this.checkSerialization(response);
                Request<String> procReq = RequestFactoryTest.this.simpleFooRequest().processList(fooProxy.getSelfOneToManyField()).using(fooProxy);
                procReq.fire(new Receiver<String>(){

                    @Override
                    public void onSuccess(String response) {
                        Assert.assertEquals(fooProxy.getUserName(), response);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testProxysAsInstanceMethodParams() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                SimpleBarProxy bar = context.create(SimpleBarProxy.class);
                Request<String> helloReq = context.hello(bar).using(response);
                bar = context.edit(bar);
                bar.setUserName("BAR");
                helloReq.fire(new Receiver<String>(){

                    @Override
                    public void onSuccess(String response) {
                        Assert.assertEquals("Greetings BAR from GWT", response);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testServerFailureCheckedException() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> persistRequest = context.persistAndReturnSelf().using(newFoo);
        SimpleFooProxy mutableFoo = context.edit(newFoo);
        mutableFoo.setPleaseCrash(43);
        persistRequest.fire(new RequestFactoryTestBase.SimpleFooFailureReceiver(this, mutableFoo, persistRequest, null));
    }

    public void testServerFailureRuntimeException() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> persistRequest = context.persistAndReturnSelf().using(newFoo);
        SimpleFooProxy mutableFoo = context.edit(newFoo);
        mutableFoo.setPleaseCrash(42);
        persistRequest.fire(new RequestFactoryTestBase.SimpleFooFailureReceiver(this, mutableFoo, persistRequest, null));
    }

    public void testSetters() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        SimpleBarProxy bar = context.create(SimpleBarProxy.class);
        RequestFactoryTest.assertNull(foo.getBarField());
        foo.setBarField(bar);
        RequestFactoryTest.assertSame(foo, context.edit(foo));
        foo.setBarField(bar);
        SimpleBarProxy returnedBarField = foo.getBarField();
        RequestFactoryTest.assertNotNull(returnedBarField);
        RequestFactoryTest.assertEquals(bar.stableId(), returnedBarField.stableId());
        RequestFactoryTest.assertEquals(returnedBarField, foo.getBarField());
        RequestFactoryTest.assertSame(returnedBarField, foo.getBarField());
        returnedBarField.setUserName("userName");
        RequestFactoryTest.assertEquals("userName", returnedBarField.getUserName());
    }

    public void testSettersWithCollections() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        SimpleBarProxy bar = context.create(SimpleBarProxy.class);
        List<SimpleBarProxy> originalList = Collections.singletonList(bar);
        RequestFactoryTest.assertNull(foo.getOneToManyField());
        foo.setOneToManyField(null);
        RequestFactoryTest.assertSame(foo, context.edit(foo));
        foo.setOneToManyField(originalList);
        List<SimpleBarProxy> list = foo.getOneToManyField();
        RequestFactoryTest.assertNotSame(originalList, list);
        RequestFactoryTest.assertEquals(originalList, list);
        RequestFactoryTest.assertEquals(1, list.size());
        RequestFactoryTest.assertEquals(bar.stableId(), list.get(0).stableId());
        RequestFactoryTest.assertEquals(list, foo.getOneToManyField());
        list.get(0).setUserName("userName");
    }

    public void testSettersWithMutableObject() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        foo = context.edit(foo);
        SimpleBarProxy immutableBar = context.create(SimpleBarProxy.class);
        SimpleBarProxy mutableBar = context.edit(immutableBar);
        mutableBar.setUserName("userName");
        foo.setBarField(mutableBar);
        context.edit(immutableBar).setUserName("Reset");
        RequestFactoryTest.assertEquals("Reset", foo.getBarField().getUserName());
    }

    public void testStableId() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        final SimpleFooProxy foo = context.create(SimpleFooProxy.class);
        final Long futureId = foo.getId();
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)foo.stableId()).isEphemeral());
        Request<SimpleFooProxy> fooReq = context.persistAndReturnSelf().using(foo);
        final SimpleFooProxy newFoo = context.edit(foo);
        RequestFactoryTest.assertEquals(futureId, foo.getId());
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)foo.stableId()).isEphemeral());
        RequestFactoryTest.assertEquals(futureId, newFoo.getId());
        RequestFactoryTest.assertTrue(((SimpleEntityProxyId)newFoo.stableId()).isEphemeral());
        newFoo.setUserName("GWT basic user");
        fooReq.fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                final SimpleFooProxy returned = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(futureId, foo.getId());
                Assert.assertFalse(((SimpleEntityProxyId)foo.stableId()).isEphemeral());
                Assert.assertEquals(futureId, newFoo.getId());
                Assert.assertFalse(((SimpleEntityProxyId)newFoo.stableId()).isEphemeral());
                Assert.assertFalse(((SimpleEntityProxyId)returned.stableId()).isEphemeral());
                RequestFactoryTest.this.checkStableIdEquals(foo, returned);
                RequestFactoryTest.this.checkStableIdEquals(newFoo, returned);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> editRequest = context.persistAndReturnSelf().using(returned);
                final SimpleFooProxy editableFoo = context.edit(returned);
                editableFoo.setUserName("GWT power user");
                editRequest.fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertEquals(response.getId(), returned.getId());
                        Assert.assertEquals("GWT power user", response.getUserName());
                        RequestFactoryTest.this.checkStableIdEquals(editableFoo, response);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testUnpersistedEchoComplexGraph() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, handler);
        SimpleFooRequest context = this.req.simpleFooRequest();
        final SimpleBarProxy simpleBar = context.create(SimpleBarProxy.class);
        simpleBar.setUnpersisted(true);
        final SimpleFooProxy simpleFoo = context.create(SimpleFooProxy.class);
        simpleFoo.setUnpersisted(true);
        simpleFoo.setBarField(simpleBar);
        context.echoComplex(simpleFoo, simpleBar).with("barField").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                RequestFactoryTest.this.checkStableIdEquals(simpleBar, response.getBarField());
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(0, handler.totalEventCount);
                RequestFactoryTest.this.checkStableIdEquals(simpleFoo, response);
                SimpleBarProxy responseBar = response.getBarField();
                Assert.assertNotNull(responseBar);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testUnpersistedEchoObject() {
        this.delayTestFinish(30000);
        final RequestFactoryTestBase.SimpleFooEventHandler handler = new RequestFactoryTestBase.SimpleFooEventHandler(this);
        EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, handler);
        SimpleFooRequest context = this.req.simpleFooRequest();
        final SimpleFooProxy simpleFoo = context.create(SimpleFooProxy.class);
        simpleFoo.setUnpersisted(true);
        context.echo(simpleFoo).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals(0, handler.totalEventCount);
                RequestFactoryTest.this.checkStableIdEquals(simpleFoo, response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testUnpersistedObjectFetch() {
        this.delayTestFinish(30000);
        this.req.simpleFooRequest().getUnpersistedInstance().fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                final SimpleFooProxy created = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertNotNull(created);
                Assert.assertTrue(created.getUnpersisted());
                RequestFactoryTest.this.req.simpleFooRequest().echo(created).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertNotNull(response);
                        Assert.assertEquals(created.stableId(), response.stableId());
                        Assert.assertTrue(response.getUnpersisted());
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testUseOfDeletedEntity() {
        this.delayTestFinish(30000);
        SimpleBarRequest context = this.simpleBarRequest();
        SimpleBarProxy willDelete = context.create(SimpleBarProxy.class);
        willDelete.setUserName("A");
        context.persistAndReturnSelf().using(willDelete).fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                Assert.assertEquals("A", response.getUserName());
                SimpleBarRequest context = RequestFactoryTest.this.simpleBarRequest();
                response = context.edit(response);
                response.setFindFails(true);
                response.setUserName("B");
                context.persistAndReturnSelf().using(response).fire(new Receiver<SimpleBarProxy>(){

                    @Override
                    public void onSuccess(SimpleBarProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertNotNull(response);
                        Assert.assertEquals("B", response.getUserName());
                        SimpleBarRequest context = RequestFactoryTest.this.simpleBarRequest();
                        response = context.edit(response);
                        response.setUserName("C");
                        context.persistAndReturnSelf().using(response).fire(new Receiver<SimpleBarProxy>(){

                            @Override
                            public void onFailure(ServerFailure error) {
                                Assert.assertTrue(error.getMessage().contains("The requested entity is not available on the server"));
                                RequestFactoryTest.this.finishTestAndReset();
                            }

                            @Override
                            public void onSuccess(SimpleBarProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.fail();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testValueMethodInvocation() {
        this.delayTestFinish(30000);
        SimpleValueContext ctx = this.req.simpleValueContext();
        SimpleValueProxy p = ctx.create(SimpleValueProxy.class);
        p.setString("Hello World!");
        ctx.getString().using(p).fire(new Receiver<String>(){

            @Override
            public void onSuccess(String response) {
                Assert.assertEquals("Hello World!", response);
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testValueObjectCreateSetRetrieveUpdate() {
        this.delayTestFinish(30000);
        SimpleFooRequest req = this.simpleFooRequest();
        req.findSimpleFooById(1L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                SimpleFooRequest req = RequestFactoryTest.this.simpleFooRequest();
                SimpleValueProxy created = req.create(SimpleValueProxy.class);
                created.setNumber(42);
                created.setString("Hello world!");
                created.setSimpleFoo(response);
                created.setSimpleValue(Arrays.asList(created));
                response = req.edit(response);
                response.setSimpleValue(created);
                req.persistAndReturnSelf().using(response).with("simpleValue.simpleFoo", "simpleValue.simpleValue").to(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        SimpleValueProxy value = response.getSimpleValue();
                        Assert.assertEquals(42, value.getNumber());
                        Assert.assertEquals("Hello world!", value.getString());
                        Assert.assertSame(response, value.getSimpleFoo());
                        Assert.assertSame(value, value.getSimpleValue().get(0));
                        try {
                            response.getSimpleValue().setNumber(43);
                            Assert.fail("Should have thrown exception");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        SimpleFooRequest req = RequestFactoryTest.this.simpleFooRequest();
                        response = req.edit(response);
                        response.getSimpleValue().setNumber(43);
                        req.persistAndReturnSelf().using(response).with("simpleValue").to(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(43, response.getSimpleValue().getNumber());
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        }).fire();
                    }
                }).fire();
            }
        });
    }

    public void testValueObjectCreateSetRetrieveUpdateViaList() {
        this.delayTestFinish(30000);
        SimpleFooRequest req = this.simpleFooRequest();
        req.findSimpleFooById(1L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                response = RequestFactoryTest.this.checkSerialization(response);
                SimpleFooRequest req = RequestFactoryTest.this.simpleFooRequest();
                SimpleValueProxy created1 = req.create(SimpleValueProxy.class);
                created1.setNumber(42);
                created1.setString("Able");
                created1.setSimpleFoo(response);
                SimpleValueProxy created2 = req.create(SimpleValueProxy.class);
                created2.setNumber(43);
                created2.setString("Baker");
                created2.setSimpleFoo(response);
                response = req.edit(response);
                response.setSimpleValues(Arrays.asList(created1, created2));
                req.persistAndReturnSelf().using(response).with("simpleValues").to(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        response = RequestFactoryTest.this.checkSerialization(response);
                        Assert.assertEquals(2, response.getSimpleValues().size());
                        SimpleValueProxy value1 = response.getSimpleValues().get(0);
                        Assert.assertEquals(42, value1.getNumber());
                        Assert.assertEquals("Able", value1.getString());
                        Assert.assertSame(response, value1.getSimpleFoo());
                        SimpleValueProxy value2 = response.getSimpleValues().get(1);
                        Assert.assertEquals(43, value2.getNumber());
                        Assert.assertEquals("Baker", value2.getString());
                        Assert.assertSame(response, value2.getSimpleFoo());
                        try {
                            response.getSimpleValues().get(0).setNumber(44);
                            Assert.fail("Should have thrown exception");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        SimpleFooRequest req = RequestFactoryTest.this.simpleFooRequest();
                        response = req.edit(response);
                        response.getSimpleValues().get(0).setNumber(44);
                        req.persistAndReturnSelf().using(response).with("simpleValues").to(new Receiver<SimpleFooProxy>(){

                            @Override
                            public void onSuccess(SimpleFooProxy response) {
                                response = RequestFactoryTest.this.checkSerialization(response);
                                Assert.assertEquals(44, response.getSimpleValues().get(0).getNumber());
                                RequestFactoryTest.this.finishTestAndReset();
                            }
                        }).fire();
                    }
                }).fire();
            }
        });
    }

    public void testValueObjectEquality() {
        SimpleFooRequest req = this.simpleFooRequest();
        SimpleValueProxy a = req.create(SimpleValueProxy.class);
        SimpleValueProxy b = req.create(SimpleValueProxy.class);
        this.checkEqualityAndHashcode(a, b);
        a.setString("Hello");
        RequestFactoryTest.assertFalse(a.equals(b));
        RequestFactoryTest.assertFalse(b.equals(a));
        b.setString("Hello");
        this.checkEqualityAndHashcode(a, b);
        a.setSimpleValue(Collections.singletonList(req.create(SimpleValueProxy.class)));
        RequestFactoryTest.assertFalse(a.equals(b));
        RequestFactoryTest.assertFalse(b.equals(a));
        b.setSimpleValue(Collections.singletonList(req.create(SimpleValueProxy.class)));
        this.checkEqualityAndHashcode(a, b);
        a.getSimpleValue().get(0).setNumber(55);
        RequestFactoryTest.assertFalse(a.equals(b));
        RequestFactoryTest.assertFalse(b.equals(a));
        b.getSimpleValue().get(0).setNumber(55);
        this.checkEqualityAndHashcode(a, b);
    }

    public void testValueObjectReturnedFromRequestIsImmutable() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnValueProxy().fire(new Receiver<SimpleValueProxy>(){

            @Override
            public void onSuccess(SimpleValueProxy a) {
                a = RequestFactoryTest.this.checkSerialization(a);
                try {
                    a.setNumber(77);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    a.getDate().setTime(1L);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                SimpleFooRequest ctx = RequestFactoryTest.this.simpleFooRequest();
                final SimpleValueProxy toCheck = ctx.edit(a);
                toCheck.setNumber(77);
                toCheck.getDate().setTime(1L);
                ctx.returnValueProxy().fire(new Receiver<SimpleValueProxy>(){

                    @Override
                    public void onSuccess(SimpleValueProxy b) {
                        b = RequestFactoryTest.this.checkSerialization(b);
                        b = RequestFactoryTest.this.simpleFooRequest().edit(b);
                        b.setNumber(77);
                        b.setDate(new java.util.Date(1L));
                        RequestFactoryTest.this.checkEqualityAndHashcode(toCheck, b);
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testValueObjectViolationsOnCreate() {
        this.delayTestFinish(30000);
        SimpleFooRequest req = this.simpleFooRequest();
        final SimpleValueProxy value = req.create(SimpleValueProxy.class);
        value.setShouldBeNull("Hello world");
        SimpleFooProxy foo = req.create(SimpleFooProxy.class);
        foo.setSimpleValue(value);
        req.echo(foo).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onConstraintViolation(Set<ConstraintViolation<?>> errors) {
                Assert.assertEquals(1, errors.size());
                ConstraintViolation<?> v = errors.iterator().next();
                Assert.assertEquals(value, v.getRootBean());
                Assert.assertEquals(value, v.getLeafBean());
                Assert.assertEquals("shouldBeNull", v.getPropertyPath().toString());
                super.onConstraintViolation(errors);
            }

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.fail();
            }

            @Override
            public void onViolation(Set<Violation> errors) {
                Assert.assertEquals(1, errors.size());
                Violation v = errors.iterator().next();
                Assert.assertEquals(value, v.getInvalidProxy());
                Assert.assertNull(v.getOriginalProxy());
                Assert.assertEquals("shouldBeNull", v.getPath());
                Assert.assertNull(v.getProxyId());
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testValueObjectViolationsOnEdit() {
        this.delayTestFinish(30000);
        this.simpleFooRequest().returnValueProxy().fire(new Receiver<SimpleValueProxy>(){

            @Override
            public void onSuccess(SimpleValueProxy response) {
                final SimpleValueProxy original = RequestFactoryTest.this.checkSerialization(response);
                SimpleFooRequest req = RequestFactoryTest.this.simpleFooRequest();
                final SimpleValueProxy value = req.edit(response);
                value.setShouldBeNull("Hello world");
                SimpleFooProxy foo = req.create(SimpleFooProxy.class);
                foo.setSimpleValue(value);
                req.echo(foo).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onConstraintViolation(Set<ConstraintViolation<?>> errors) {
                        Assert.assertEquals(1, errors.size());
                        ConstraintViolation<?> v = errors.iterator().next();
                        Assert.assertEquals(value, v.getRootBean());
                        Assert.assertEquals(value, v.getLeafBean());
                        Assert.assertEquals("shouldBeNull", v.getPropertyPath().toString());
                        super.onConstraintViolation(errors);
                    }

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        Assert.fail();
                    }

                    @Override
                    public void onViolation(Set<Violation> errors) {
                        Assert.assertEquals(1, errors.size());
                        Violation v = errors.iterator().next();
                        Assert.assertEquals(value, v.getInvalidProxy());
                        Assert.assertEquals(original, v.getOriginalProxy());
                        Assert.assertEquals("shouldBeNull", v.getPath());
                        Assert.assertNull(v.getProxyId());
                        RequestFactoryTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testViolationAbsent() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<Void> fooReq = context.persist().using(newFoo);
        newFoo = context.edit(newFoo);
        newFoo.setUserName("Amit");
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void ignore) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    public void testViolationsOnCreate() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> create = context.persistAndReturnSelf().using(newFoo);
        new FailFixAndRefire<SimpleFooProxy>(newFoo, context, create).doTest();
    }

    public void testViolationsOnCreateVoidReturn() {
        this.delayTestFinish(30000);
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        Request<Void> create = context.persist().using(newFoo);
        new FailFixAndRefire<Void>(newFoo, context, create).doVoidTest();
    }

    public void testViolationsOnEdit() {
        this.delayTestFinish(30000);
        this.fooCreationRequest().fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<SimpleFooProxy> editRequest = context.persistAndReturnSelf().using(returned);
                new FailFixAndRefire<SimpleFooProxy>(returned, context, editRequest).doTest();
            }
        });
    }

    public void testViolationsOnEditVoidReturn() {
        this.delayTestFinish(30000);
        this.fooCreationRequest().fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy returned) {
                returned = RequestFactoryTest.this.checkSerialization(returned);
                SimpleFooRequest context = RequestFactoryTest.this.simpleFooRequest();
                Request<Void> editRequest = context.persist().using(returned);
                new FailFixAndRefire<Void>(returned, context, editRequest).doVoidTest();
            }
        });
    }

    public void testEnumsUsedAsTypeParameter() {
        this.delayTestFinish(30000);
        List<SimpleEnum> list = Arrays.asList(SimpleEnum.FOO, SimpleEnum.BAR);
        Request<Void> fooReq = this.simpleFooRequest().enumsUsedAsTypeParameter(list);
        fooReq.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void v) {
                RequestFactoryTest.this.finishTestAndReset();
            }
        });
    }

    protected SimpleBarRequest simpleBarRequest() {
        return this.req.simpleBarRequest();
    }

    protected SimpleFooRequest simpleFooRequest() {
        return this.req.simpleFooRequest();
    }

    private void assertCannotFire(Request<Long> mutateRequest) {
        try {
            mutateRequest.fire(new Receiver<Long>(){

                @Override
                public void onSuccess(Long response) {
                    Assert.fail("Should not be called");
                }
            });
            RequestFactoryTest.fail("Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Request<SimpleFooProxy> fooCreationRequest() {
        SimpleFooRequest context = this.simpleFooRequest();
        SimpleFooProxy originalFoo = context.create(SimpleFooProxy.class);
        Request<SimpleFooProxy> fooReq = context.persistAndReturnSelf().using(originalFoo);
        originalFoo = context.edit(originalFoo);
        originalFoo.setUserName("GWT User");
        return fooReq;
    }

    private class FailFixAndRefire<T>
    extends Receiver<T> {
        private final RegExp THREE = RegExp.compile("\\b3\\b");
        private final RegExp THIRTY = RegExp.compile("\\b30\\b");
        private final SimpleFooProxy proxy;
        private final Request<T> request;
        private boolean voidReturnExpected;

        FailFixAndRefire(SimpleFooProxy proxy, RequestContext context, Request<T> request) {
            this.proxy = context.edit(proxy);
            this.request = request;
        }

        @Override
        public void onConstraintViolation(Set<ConstraintViolation<?>> errors) {
            Assert.assertEquals(1, errors.size());
            ConstraintViolation<?> error = errors.iterator().next();
            Assert.assertEquals("userName", error.getPropertyPath().toString());
            Assert.assertTrue(this.THREE.test(error.getMessage()));
            Assert.assertTrue(this.THIRTY.test(error.getMessage()));
            Assert.assertEquals("{javax.validation.constraints.Size.message}", error.getMessageTemplate());
            Assert.assertSame(this.proxy, error.getRootBean());
            Assert.assertSame(this.proxy, error.getLeafBean());
            Assert.assertEquals(this.proxy.stableId().getProxyClass(), error.getRootBeanClass());
            super.onConstraintViolation(errors);
        }

        @Override
        public void onSuccess(T response) {
            Assert.fail("Violations expected (you might be missing some jars, see the comment above this line)");
        }

        @Override
        public void onViolation(Set<Violation> errors) {
            Assert.assertEquals(1, errors.size());
            Violation error = errors.iterator().next();
            Assert.assertEquals("userName", error.getPath());
            Assert.assertTrue(this.THREE.test(error.getMessage()));
            Assert.assertTrue(this.THIRTY.test(error.getMessage()));
            Assert.assertEquals(this.proxy.stableId(), error.getProxyId());
            this.proxy.setUserName("long enough");
            this.request.fire(new Receiver<T>(){

                @Override
                public void onSuccess(T response) {
                    if (FailFixAndRefire.this.voidReturnExpected) {
                        Assert.assertNull(response);
                    } else {
                        Assert.assertEquals(FailFixAndRefire.this.proxy.stableId(), ((SimpleFooProxy)response).stableId());
                    }
                    RequestFactoryTest.this.finishTestAndReset();
                }
            });
        }

        void doTest() {
            this.proxy.setUserName("a");
            this.request.fire(this);
        }

        void doVoidTest() {
            this.voidReturnExpected = true;
            this.doTest();
        }
    }

    class NullReceiver
    extends Receiver<Object> {
        NullReceiver() {
        }

        @Override
        public void onSuccess(Object response) {
            Assert.assertNull(response);
            RequestFactoryTest.this.finishTestAndReset();
        }
    }
}

