/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.ExtraTypes;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.TestRequestFactory;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

public class RequestFactoryPolymorphicTest
extends GWTTestCase {
    private final Receiver<String> checkReceiver = new Receiver<String>(){

        @Override
        public void onSuccess(String response) {
            Assert.assertEquals("", response);
        }
    };
    private static final int TEST_DELAY = 5000;
    protected Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testChain() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.CasA().with("nextA.nextA").fire(new Receiver<AProxy>(){

            @Override
            public void onSuccess(AProxy response) {
                new CastAndCheckReceiver(AProxy.class).onSuccess(response.getNextA().getNextA());
                Assert.assertNull(response.getNextA().getNextA().getNextA());
                Assert.assertNull(((C1Proxy)response).getNextC());
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testChainWithExtras() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.CasA().with("nextC.nextC").fire(new Receiver<AProxy>(){

            @Override
            public void onSuccess(AProxy response) {
                Assert.assertNull(response.getNextA());
                C1Proxy cast = (C1Proxy)response;
                new CastAndCheckReceiver(C1Proxy.class).onSuccess(cast.getNextC().getNextC());
                Assert.assertNull(cast.getNextC().getNextC().getNextC());
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testChainWithWildcards() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.CasA().with("*.*").fire(new Receiver<AProxy>(){

            @Override
            public void onSuccess(AProxy response) {
                new CastAndCheckReceiver(AProxy.class).onSuccess(response.getNextA().getNextA());
                C1Proxy cast = (C1Proxy)response;
                new CastAndCheckReceiver(C1Proxy.class).onSuccess(cast.getNextC().getNextC());
                Assert.assertNull(cast.getNextC().getNextC().getNextC());
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testCreation() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        this.checkA(ctx, AProxy.class);
        this.checkB(ctx, B1Proxy.class);
        this.checkB(ctx, B2Proxy.class);
        this.checkC(ctx, C1Proxy.class);
        this.checkC(ctx, C2Proxy.class);
        this.checkD(ctx, D1Proxy.class);
        this.checkD(ctx, D2Proxy.class);
        this.checkD(ctx, D3Proxy.class);
        this.checkD(ctx, MoreDerivedProxy.class);
        this.checkW(ctx, WProxy.class);
        this.checkW(ctx, WZProxy.class);
        this.checkZ(ctx, ZProxy.class);
        this.checkZ(ctx, ZWProxy.class);
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testCreationList() {
        Context ctx = this.factory.ctx();
        ctx.checkList(Arrays.asList(this.create(ctx, AProxy.class), this.create(ctx, B2Proxy.class), this.create(ctx, C2Proxy.class), this.create(ctx, D2Proxy.class))).to(this.checkReceiver);
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testGenericRequest() {
        TestRequestFactory rf = (TestRequestFactory)GWT.create(TestRequestFactory.class);
        SimpleEventBus eventBus = new SimpleEventBus();
        rf.initialize(eventBus);
        SimpleFooProxy simpleFoo = rf.testGenericRequest().create(SimpleFooProxy.class);
        RequestFactoryPolymorphicTest.assertNull(simpleFoo.getUserName());
    }

    public void testRetrieval() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.AasA().to(CastAndCheckReceiver.of(AProxy.class));
        ctx.BasA().to(CastAndCheckReceiver.of(B1Proxy.class));
        ctx.BasB().to(CastAndCheckReceiver.of(B1Proxy.class));
        ctx.CasA().to(CastAndCheckReceiver.of(C1Proxy.class));
        ctx.CasB().to(CastAndCheckReceiver.of(C1Proxy.class));
        ctx.DasA().to(CastAndCheckReceiver.of(MoreDerivedProxy.class));
        ctx.DasD().to(CastAndCheckReceiver.of(MoreDerivedProxy.class));
        ctx.W().to(CastAndCheckReceiver.of(WProxy.class));
        ctx.W2().to(CastAndCheckReceiver.of(WZProxy.class));
        ctx.Z().to(CastAndCheckReceiver.of(ZProxy.class));
        ctx.Z2().to(CastAndCheckReceiver.of(ZWProxy.class));
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    public void testRetrievalCollection() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.testCollection().to(new ListChecker());
        ctx.testCollectionSub().to(new ListChecker());
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryPolymorphicTest.this.finishTest();
            }
        });
    }

    protected Factory createFactory() {
        Factory f = (Factory)GWT.create(Factory.class);
        f.initialize(new SimpleEventBus());
        return f;
    }

    @Override
    protected void gwtSetUp() throws Exception {
        this.factory = this.createFactory();
    }

    private void checkA(Context ctx, Class<? extends AProxy> clazz) {
        ctx.checkA(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private void checkB(Context ctx, Class<? extends EntityProxy> clazz) {
        ctx.checkB(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private void checkC(Context ctx, Class<? extends EntityProxy> clazz) {
        ctx.checkC(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private void checkD(Context ctx, Class<? extends EntityProxy> clazz) {
        ctx.checkD(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private void checkW(Context ctx, Class<? extends EntityProxy> clazz) {
        ctx.checkW(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private void checkZ(Context ctx, Class<? extends EntityProxy> clazz) {
        ctx.checkZ(this.create(ctx, clazz)).to(this.checkReceiver);
    }

    private <T extends EntityProxy> T create(Context ctx, Class<T> clazz) {
        EntityProxy obj = (EntityProxy)ctx.create(clazz);
        if (obj instanceof AProxy) {
            ((AProxy)obj).setA("A");
        }
        if (obj instanceof B1Proxy) {
            ((B1Proxy)obj).setB("B");
        }
        if (obj instanceof B2Proxy) {
            ((B2Proxy)obj).setB("B");
        }
        if (obj instanceof C1Proxy) {
            ((C1Proxy)obj).setC("C");
        }
        if (obj instanceof C2Proxy) {
            ((C2Proxy)obj).setC("C");
        }
        if (obj instanceof D1Proxy) {
            ((D1Proxy)obj).setD("D");
        }
        if (obj instanceof D2Proxy) {
            ((D2Proxy)obj).setD("D");
        }
        if (obj instanceof D3Proxy) {
            ((D3Proxy)obj).setD("D");
        }
        if (obj instanceof WProxy) {
            ((WProxy)obj).setW("W");
        }
        if (obj instanceof ZProxy) {
            ((ZProxy)obj).setZ("Z");
        }
        if (obj instanceof WZProxy) {
            ((WZProxy)obj).setW("W");
        }
        if (obj instanceof ZWProxy) {
            ((ZWProxy)obj).setZ("Z");
        }
        return (T)obj;
    }

    static class ListChecker
    extends Receiver<List<AProxy>> {
        ListChecker() {
        }

        @Override
        public void onSuccess(List<AProxy> response) {
            new CastAndCheckReceiver(AProxy.class).onSuccess(response.get(0));
            new CastAndCheckReceiver(B1Proxy.class).onSuccess(response.get(1));
            new CastAndCheckReceiver(C1Proxy.class).onSuccess(response.get(2));
            new CastAndCheckReceiver(MoreDerivedProxy.class).onSuccess(response.get(3));
        }
    }

    @ExtraTypes(value={C1Proxy.class, C2Proxy.class, MoreDerivedProxy.class})
    @Service(value=Impl.class)
    static interface Context
    extends RequestContext {
        public Request<AProxy> AasA();

        public Request<AProxy> BasA();

        public Request<B1Proxy> BasB();

        public Request<AProxy> CasA();

        public Request<B1Proxy> CasB();

        public Request<String> checkA(EntityProxy var1);

        public Request<String> checkB(EntityProxy var1);

        public Request<String> checkC(EntityProxy var1);

        public Request<String> checkD(EntityProxy var1);

        public Request<String> checkList(List<EntityProxy> var1);

        public Request<String> checkW(EntityProxy var1);

        public Request<String> checkZ(EntityProxy var1);

        public Request<AProxy> DasA();

        public Request<D1Proxy> DasD();

        public Request<List<AProxy>> testCollection();

        public Request<List<AProxy>> testCollectionSub();

        public Request<WProxy> W();

        public Request<WZProxy> W2();

        public Request<ZProxy> Z();

        public Request<ZWProxy> Z2();
    }

    static class CastAndCheckReceiver
    extends Receiver<EntityProxy> {
        private final Class<?> clazz;

        public static CastAndCheckReceiver of(Class<?> clazz) {
            return new CastAndCheckReceiver(clazz);
        }

        public CastAndCheckReceiver(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void onSuccess(EntityProxy response) {
            Assert.assertNotNull(response);
            Assert.assertEquals(this.clazz, response.stableId().getProxyClass());
            if (response instanceof HasA) {
                Assert.assertEquals("a", ((HasA)((Object)response)).getA());
            }
            if (response instanceof B1Proxy) {
                Assert.assertEquals("b", ((B1Proxy)response).getB());
            }
            if (response instanceof B2Proxy) {
                Assert.assertEquals("b", ((B2Proxy)response).getB());
            }
            if (response instanceof C1Proxy) {
                Assert.assertEquals("c", ((C1Proxy)response).getC());
            }
            if (response instanceof C2Proxy) {
                Assert.assertEquals("c", ((C2Proxy)response).getC());
            }
            if (response instanceof D1Proxy) {
                Assert.assertEquals("d", ((D1Proxy)response).getD());
            }
            if (response instanceof D2Proxy) {
                Assert.assertEquals("d", ((D2Proxy)response).getD());
            }
        }
    }

    @ExtraTypes(value={B2Proxy.class})
    protected static interface Factory
    extends RequestFactory {
        public Context ctx();
    }

    @ProxyFor(value=Z.class)
    public static interface ZWProxy
    extends WProxy {
        public String getZ();

        public void setZ(String var1);
    }

    @ProxyFor(value=Z.class)
    public static interface ZProxy
    extends EntityProxy {
        public String getZ();

        public void setZ(String var1);
    }

    public static class Z
    extends A {
        private static int idCount;
        private int id = idCount++;
        private String w = "w";
        private String z = "z";

        public static Z findZ(int id) {
            Z toReturn = new Z();
            toReturn.id = id;
            return toReturn;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public int getVersion() {
            return 0;
        }

        public String getW() {
            return this.w;
        }

        public String getZ() {
            return this.z;
        }

        public void setW(String w) {
            this.w = w;
        }

        public void setZ(String z) {
            this.z = z;
        }
    }

    @ProxyFor(value=W.class)
    public static interface WZProxy
    extends ZProxy {
        public String getW();

        public void setW(String var1);
    }

    @ProxyFor(value=W.class)
    public static interface WProxy
    extends EntityProxy {
        public String getW();

        public void setW(String var1);
    }

    public static class W {
        private static int idCount;
        private int id = idCount++;
        private String w = "w";
        private String z = "z";

        public static W findW(int id) {
            W toReturn = new W();
            toReturn.id = id;
            return toReturn;
        }

        public int getId() {
            return this.id;
        }

        public int getVersion() {
            return 0;
        }

        public String getW() {
            return this.w;
        }

        public String getZ() {
            return this.z;
        }

        public void setW(String w) {
            this.w = w;
        }

        public void setZ(String z) {
            this.z = z;
        }
    }

    @ProxyFor(value=D.class)
    public static interface MoreDerivedProxy
    extends AProxy,
    D1Proxy,
    D2Proxy,
    D3Proxy {
    }

    public static class Impl {
        public static A AasA() {
            return new A();
        }

        public static A BasA() {
            return new B();
        }

        public static B BasB() {
            return new B();
        }

        public static A CasA() {
            return new C();
        }

        public static B CasB() {
            return new C();
        }

        public static String checkA(Object obj) {
            return A.class.equals(obj.getClass()) && "A".equals(((A)obj).getA()) ? "" : "checkA";
        }

        public static String checkB(Object obj) {
            return B.class.equals(obj.getClass()) && "B".equals(((B)obj).getB()) ? "" : "checkB";
        }

        public static String checkC(Object obj) {
            return C.class.equals(obj.getClass()) && "C".equals(((C)obj).getC()) ? "" : "checkC";
        }

        public static String checkD(Object obj) {
            return D.class.equals(obj.getClass()) && "D".equals(((D)obj).getD()) ? "" : "checkD";
        }

        public static String checkList(List<Object> list) {
            if (list.size() != 4) {
                return "size";
            }
            String temp = Impl.checkA(list.get(0));
            if (!temp.isEmpty()) {
                return temp;
            }
            temp = Impl.checkB(list.get(1));
            if (!temp.isEmpty()) {
                return temp;
            }
            temp = Impl.checkC(list.get(2));
            if (!temp.isEmpty()) {
                return temp;
            }
            temp = Impl.checkD(list.get(3));
            if (!temp.isEmpty()) {
                return temp;
            }
            return "";
        }

        public static String checkW(Object obj) {
            return W.class.equals(obj.getClass()) && "W".equals(((W)obj).getW()) ? "" : "checkW";
        }

        public static String checkZ(Object obj) {
            return Z.class.equals(obj.getClass()) && "Z".equals(((Z)obj).getZ()) ? "" : "checkZ";
        }

        public static A DasA() {
            return new D();
        }

        public static D DasD() {
            return new D();
        }

        public static List<A> testCollection() {
            return Arrays.asList(new A(), new B(), new C(), new D());
        }

        public static List<A> testCollectionSub() {
            return Arrays.asList(new ASub(), new BSub(), new CSub(), new DSub());
        }

        public static W W() {
            return new W();
        }

        public static W W2() {
            return new W();
        }

        public static Z Z() {
            return new Z();
        }

        public static Z Z2() {
            return new Z();
        }
    }

    public static interface HasA {
        public String getA();
    }

    public static class DSub
    extends D {
    }

    @ProxyFor(value=D.class)
    public static interface D3Proxy
    extends EntityProxy {
        public String getD();

        public void setD(String var1);
    }

    @ProxyFor(value=D.class)
    public static interface D2Proxy
    extends EntityProxy {
        public String getD();

        public void setD(String var1);
    }

    @ExtraTypes(value={D2Proxy.class})
    @ProxyFor(value=D.class)
    public static interface D1Proxy
    extends AProxy {
        public String getD();

        public void setD(String var1);
    }

    public static class D
    extends A {
        private String d = "d";

        public static D findD(int id) {
            D toReturn = new D();
            toReturn.id = id;
            return toReturn;
        }

        public String getD() {
            return this.d;
        }

        public void setD(String value) {
            this.d = value;
        }
    }

    public static class CSub
    extends C {
    }

    @ProxyFor(value=C.class)
    public static interface C2Proxy
    extends B2Proxy {
        public String getC();

        public void setC(String var1);
    }

    @ProxyFor(value=C.class)
    public static interface C1Proxy
    extends B1Proxy {
        public String getC();

        public C1Proxy getNextC();

        public void setC(String var1);
    }

    public static class C
    extends B {
        private String c = "c";
        private C nextC;

        public static C findC(int id) {
            C toReturn = new C();
            toReturn.id = id;
            return toReturn;
        }

        public String getC() {
            return this.c;
        }

        public C getNextC() {
            if (this.nextC == null) {
                this.nextC = new C();
            }
            return this.nextC;
        }

        public void setC(String value) {
            this.c = value;
        }
    }

    public static class BSub
    extends B {
    }

    @ProxyFor(value=B.class)
    public static interface B2Proxy
    extends AProxy {
        public String getB();

        public void setB(String var1);
    }

    @ProxyFor(value=B.class)
    public static interface B1Proxy
    extends AProxy {
        public String getB();

        public void setB(String var1);
    }

    public static class B
    extends A {
        private String b = "b";

        public static B findB(int id) {
            B toReturn = new B();
            toReturn.id = id;
            return toReturn;
        }

        public String getB() {
            return this.b;
        }

        public void setB(String value) {
            this.b = value;
        }
    }

    public static class ASub
    extends A {
    }

    @ProxyFor(value=A.class)
    public static interface AProxy
    extends EntityProxy,
    HasA {
        public AProxy getNextA();

        public void setA(String var1);
    }

    public static class A {
        private static int idCount = 0;
        private String a = "a";
        protected int id = idCount++;
        private A nextA;

        public static A findA(int id) {
            A toReturn = new A();
            toReturn.id = id;
            return toReturn;
        }

        public String getA() {
            return this.a;
        }

        public int getId() {
            return this.id;
        }

        public A getNextA() {
            if (this.nextA == null) {
                this.nextA = new A();
            }
            return this.nextA;
        }

        public int getVersion() {
            return 0;
        }

        public void setA(String value) {
            this.a = value;
        }
    }
}

