/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.SkipInterfaceValidation;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;

@SkipInterfaceValidation
public class RequestFactoryGenericsTest
extends GWTTestCase {
    private static final int TEST_DELAY = 5000;
    protected Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testEchoDomain() throws Exception {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        DomainProxy proxy = ctx.create(DomainProxy.class);
        proxy.setA("foo");
        proxy.setB(true);
        proxy.setListOfA(Collections.singletonList("bar"));
        proxy.setListOfStrings(Collections.singletonList("baz"));
        ctx.echoDomain(proxy).fire(new Receiver<DomainProxy>(){

            @Override
            public void onSuccess(DomainProxy response) {
                Assert.assertEquals("foo", (String)response.getA());
                Assert.assertEquals(Boolean.TRUE, response.getB());
                Assert.assertEquals(Collections.singletonList("bar"), response.getListOfA());
                Assert.assertEquals(Collections.singletonList("baz"), response.getListOfStrings());
                RequestFactoryGenericsTest.this.finishTest();
            }
        });
    }

    public void testGetBase() throws Exception {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.getBase().fire(new Receiver<BaseDomainProxy>(){

            @Override
            public void onSuccess(BaseDomainProxy response) {
                Assert.assertEquals(Collections.singletonList("foo"), response.getListOfStrings());
                RequestFactoryGenericsTest.this.finishTest();
            }
        });
    }

    public void testEchoContainer() throws Exception {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        DomainProxy proxy = ctx.create(DomainProxy.class);
        proxy.setA("42");
        ContainerProxy container = ctx.create(ContainerProxy.class);
        container.setDomain(proxy);
        ctx.echoContainer(container).fire(new Receiver<ContainerProxy>(){

            @Override
            public void onSuccess(ContainerProxy response) {
                Assert.assertEquals("42", (String)response.getDomain().getA());
                RequestFactoryGenericsTest.this.finishTest();
            }
        });
    }

    @Override
    protected void gwtSetUp() throws Exception {
        this.factory = this.createFactory();
    }

    protected Factory createFactory() {
        Factory factory = (Factory)GWT.create(Factory.class);
        factory.initialize(new SimpleEventBus());
        return factory;
    }

    public static interface Factory
    extends RequestFactory {
        public Context ctx();
    }

    @Service(value=Impl.class)
    public static interface Context
    extends RequestContext {
        public Request<DomainProxy> echoDomain(DomainProxy var1);

        public Request<BaseDomainProxy> getBase();

        public Request<ContainerProxy> echoContainer(ContainerProxy var1);
    }

    @ProxyFor(value=Container.class)
    public static interface ContainerProxy
    extends ValueProxy,
    BaseContainerProxy {
        @Override
        public DomainProxy getDomain();

        public void setDomain(DomainProxy var1);
    }

    public static interface BaseContainerProxy {
        public BaseDomainProxy getDomain();
    }

    @ProxyFor(value=Domain.class)
    public static interface DomainProxy
    extends BaseDomainProxy,
    HasA<String> {
        public Boolean getB();

        public void setB(Boolean var1);
    }

    @ProxyFor(value=BaseDomain.class)
    public static interface BaseDomainProxy
    extends ValueProxy {
        public List<String> getListOfStrings();

        public void setListOfStrings(List<String> var1);
    }

    public static class Container {
        private Domain domain;

        public Domain getDomain() {
            return this.domain;
        }

        public void setDomain(Domain domain) {
            this.domain = domain;
        }
    }

    public static class Domain
    extends BaseDomain<String, Boolean> {
        private String str;
        private List<String> list;

        @Override
        public String getA() {
            return this.str;
        }

        @Override
        public void setA(String a) {
            this.str = a;
        }

        @Override
        public List<String> getListOfA() {
            return this.list;
        }

        @Override
        public void setListOfA(List<String> list) {
            this.list = list;
        }
    }

    public static abstract class BaseDomain<A, B>
    implements HasA<A> {
        private B b;
        private List<String> listOfStrings;

        public B getB() {
            return this.b;
        }

        public void setB(B b) {
            this.b = b;
        }

        public List<String> getListOfStrings() {
            return this.listOfStrings;
        }

        public void setListOfStrings(List<String> list) {
            this.listOfStrings = list;
        }
    }

    public static interface HasA<A> {
        public A getA();

        public void setA(A var1);

        public List<A> getListOfA();

        public void setListOfA(List<A> var1);
    }

    public static class Impl {
        public static Domain echoDomain(Domain domainObject) {
            return domainObject;
        }

        public static BaseDomain<?, ?> getBase() {
            return new BaseDomain<Integer, Float>(){
                {
                    this.setListOfStrings(Collections.singletonList("foo"));
                }

                @Override
                public void setA(Integer a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Integer getA() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<Integer> getListOfA() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setListOfA(List<Integer> list) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public static Container echoContainer(Container container) {
            return container;
        }
    }
}

