/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.web.bindery.event.shared.UmbrellaException;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryTestBase;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.Violation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import junit.framework.Assert;

public class RequestFactoryExceptionPropagationTest
extends RequestFactoryTestBase {
    private static final int DELAY_TEST_FINISH = 10000;
    private ExceptionVerifier exceptionVerifier;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    @Override
    protected void gwtTearDown() throws Exception {
        super.gwtTearDown();
        this.exceptionVerifier = null;
    }

    @Override
    protected void reportUncaughtException(Throwable ex) {
        try {
            this.exceptionVerifier.verify(ex);
        }
        catch (Throwable e) {
            super.reportUncaughtException(ex);
        }
    }

    public void testMixedSuccessAndFailureThrow() {
        this.delayTestFinish(10000);
        final RuntimeException exception1 = new RuntimeException("first exception");
        final RuntimeException exception2 = new RuntimeException("second exception");
        final CountingReceiver count = new CountingReceiver();
        SimpleFooRequest context = this.req.simpleFooRequest();
        context.pleaseCrash(42).to(count);
        context.returnNullString().to(new ThrowingReceiver(exception1));
        context.returnNullString().to(count);
        this.fireContextAndCatch(context, new ThrowingReceiver<Void>(exception2), new ExceptionVerifier(){

            @Override
            public void verify(Throwable e) {
                RequestFactoryExceptionPropagationTest.assertUmbrellaException(e, exception1, exception2);
                count.assertCounts(1, 1, 0);
                RequestFactoryExceptionPropagationTest.this.finishTestAndReset();
            }
        });
    }

    public void testOnFailureThrow() {
        this.delayTestFinish(10000);
        final RuntimeException exception1 = new RuntimeException("first exception");
        final RuntimeException exception2 = new RuntimeException("second exception");
        final CountingReceiver count = new CountingReceiver();
        SimpleFooRequest context = this.req.simpleFooRequest();
        context.returnNullString().to(count);
        context.pleaseCrash(42).to(new ThrowingReceiver(exception1));
        context.returnNullString().to(count);
        this.fireContextAndCatch(context, new ThrowingReceiver<Void>(exception2), new ExceptionVerifier(){

            @Override
            public void verify(Throwable e) {
                RequestFactoryExceptionPropagationTest.assertUmbrellaException(e, exception1, exception2);
                count.assertCounts(0, 2, 0);
                RequestFactoryExceptionPropagationTest.this.finishTestAndReset();
            }
        });
    }

    public void testOnGlobalFailureThrow() {
        this.delayTestFinish(10000);
        final RuntimeException exception1 = new RuntimeException("first exception");
        final RuntimeException exception2 = new RuntimeException("second exception");
        final CountingReceiver count = new CountingReceiver();
        SimpleFooRequest context = this.req.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        context.returnNullString().to(count);
        context.persist().using(newFoo).to(new ThrowingReceiver(exception1));
        context.returnNullString().to(count);
        SimpleFooProxy mutableFoo = context.edit(newFoo);
        mutableFoo.setPleaseCrash(42);
        this.fireContextAndCatch(context, new ThrowingReceiver<Void>(exception2), new ExceptionVerifier(){

            @Override
            public void verify(Throwable e) {
                RequestFactoryExceptionPropagationTest.assertUmbrellaException(e, exception1, exception2);
                count.assertCounts(2, 0, 0);
                RequestFactoryExceptionPropagationTest.this.finishTestAndReset();
            }
        });
    }

    public void testOnSuccessThrow() {
        this.delayTestFinish(10000);
        final RuntimeException exception1 = new RuntimeException("first exception");
        final RuntimeException exception2 = new RuntimeException("second exception");
        final CountingReceiver count = new CountingReceiver();
        SimpleFooRequest context = this.req.simpleFooRequest();
        context.returnNullString().to(count);
        context.returnNullString().to(new ThrowingReceiver(exception1));
        context.returnNullString().to(count);
        this.fireContextAndCatch(context, new ThrowingReceiver<Void>(exception2), new ExceptionVerifier(){

            @Override
            public void verify(Throwable e) {
                RequestFactoryExceptionPropagationTest.assertUmbrellaException(e, exception1, exception2);
                count.assertCounts(0, 2, 0);
                RequestFactoryExceptionPropagationTest.this.finishTestAndReset();
            }
        });
    }

    public void testOnViolationThrow() {
        this.delayTestFinish(10000);
        final RuntimeException exception1 = new RuntimeException("first exception");
        final RuntimeException exception2 = new RuntimeException("second exception");
        final CountingReceiver count = new CountingReceiver();
        SimpleFooRequest context = this.req.simpleFooRequest();
        SimpleFooProxy newFoo = context.create(SimpleFooProxy.class);
        newFoo.setUserName("a");
        context.returnNullString().to(count);
        context.persist().using(newFoo).to(new ThrowingReceiver(exception1));
        context.returnNullString().to(count);
        this.fireContextAndCatch(context, new ThrowingReceiver<Void>(exception2), new ExceptionVerifier(){

            @Override
            public void verify(Throwable e) {
                RequestFactoryExceptionPropagationTest.assertUmbrellaException(e, exception1, exception2);
                count.assertCounts(0, 0, 2);
                RequestFactoryExceptionPropagationTest.this.finishTestAndReset();
            }
        });
    }

    protected void fireContextAndCatch(RequestContext context, Receiver<Void> receiver, ExceptionVerifier exceptionVerifier) {
        this.exceptionVerifier = exceptionVerifier;
        if (receiver == null) {
            context.fire();
        } else {
            context.fire(receiver);
        }
    }

    private static void assertUmbrellaException(Throwable e, Throwable ... expectedCauses) {
        RequestFactoryExceptionPropagationTest.assertTrue(e instanceof UmbrellaException);
        HashSet<Throwable> causes = new HashSet<Throwable>(Arrays.asList(expectedCauses));
        RequestFactoryExceptionPropagationTest.assertEquals(causes, ((UmbrellaException)e).getCauses());
    }

    public static interface ExceptionVerifier {
        public void verify(Throwable var1);
    }

    private class ThrowingReceiver<T>
    extends Receiver<T> {
        private final RuntimeException e;

        public ThrowingReceiver(RuntimeException e) {
            this.e = e;
        }

        @Override
        public void onFailure(ServerFailure error) {
            throw this.e;
        }

        @Override
        public void onSuccess(T response) {
            throw this.e;
        }

        @Override
        public void onViolation(Set<Violation> errors) {
            throw this.e;
        }
    }

    private class CountingReceiver
    extends Receiver<Object> {
        int constraintViolationCallCount;
        int failureCallCount;
        int successCallCount;
        int violationCallCount;

        private CountingReceiver() {
        }

        public void assertCounts(int expectedFailureCallCount, int expectedSuccessCallCount, int expectedViolationCallCount) {
            Assert.assertEquals(expectedFailureCallCount, this.failureCallCount);
            Assert.assertEquals(expectedSuccessCallCount, this.successCallCount);
            Assert.assertEquals(expectedViolationCallCount, this.constraintViolationCallCount);
            Assert.assertEquals(expectedViolationCallCount, this.violationCallCount);
        }

        @Override
        public void onConstraintViolation(Set<ConstraintViolation<?>> errors) {
            ++this.constraintViolationCallCount;
            super.onConstraintViolation(errors);
        }

        @Override
        public void onFailure(ServerFailure error) {
            ++this.failureCallCount;
        }

        @Override
        public void onSuccess(Object response) {
            ++this.successCallCount;
        }

        @Override
        public void onViolation(Set<Violation> errors) {
            ++this.violationCallCount;
        }
    }
}

