/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryTestBase;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.SimpleBarProxy;
import com.google.web.bindery.requestfactory.shared.SimpleBarRequest;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import junit.framework.Assert;

public class RequestFactoryChainedContextTest
extends RequestFactoryTestBase {
    private static final int DELAY_TEST_FINISH = 5000;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testAppend() {
        this.delayTestFinish(5000);
        SimpleFooRequest fooCtx1 = this.req.simpleFooRequest();
        SimpleFooProxy foo1 = fooCtx1.create(SimpleFooProxy.class);
        SimpleBarRequest barCtx = fooCtx1.append(this.req.simpleBarRequest());
        SimpleFooRequest fooCtx2 = barCtx.append(this.req.simpleFooRequest());
        RequestFactoryChainedContextTest.assertNotSame(fooCtx1, fooCtx2);
        RequestFactoryChainedContextTest.assertSame(foo1, barCtx.edit(foo1));
        RequestFactoryChainedContextTest.assertSame(foo1, fooCtx2.edit(foo1));
        SimpleBarProxy foo2 = barCtx.create(SimpleBarProxy.class);
        RequestFactoryChainedContextTest.assertSame(foo2, fooCtx1.edit(foo2));
        RequestFactoryChainedContextTest.assertSame(foo2, fooCtx2.edit(foo2));
        SimpleFooProxy foo3 = fooCtx2.create(SimpleFooProxy.class);
        RequestFactoryChainedContextTest.assertSame(foo3, fooCtx1.edit(foo3));
        RequestFactoryChainedContextTest.assertSame(foo3, barCtx.edit(foo3));
        try {
            this.req.simpleValueContext().append(fooCtx2);
            RequestFactoryChainedContextTest.fail("Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fooCtx2.append(this.createFactory().simpleFooRequest());
            RequestFactoryChainedContextTest.fail("Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        final boolean[] seen = new boolean[]{false, false};
        fooCtx1.add(1, 2).to(new Receiver<Integer>(){

            @Override
            public void onSuccess(Integer response) {
                seen[0] = true;
                Assert.assertEquals(3, response);
            }
        });
        barCtx.countSimpleBar().to(new Receiver<Long>(){

            @Override
            public void onSuccess(Long response) {
                seen[1] = true;
                Assert.assertEquals(2L, response);
            }
        });
        barCtx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                Assert.assertTrue(seen[0]);
                Assert.assertTrue(seen[1]);
                RequestFactoryChainedContextTest.this.finishTestAndReset();
            }
        });
        try {
            fooCtx1.fire();
            RequestFactoryChainedContextTest.fail("Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fooCtx2.fire();
            RequestFactoryChainedContextTest.fail("Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fooCtx2.create(SimpleFooProxy.class);
            RequestFactoryChainedContextTest.fail("Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testChainedProxyInstantiation() {
        this.delayTestFinish(5000);
        Factory f = this.createChainedFactory();
        ACtx aCtx = f.a();
        this.checkReachableTypes(aCtx, AProxy.class, BProxy.class);
        RequestContext ctx = aCtx.a().to(new Receiver<AProxy>(){

            @Override
            public void onSuccess(AProxy response) {
                Assert.assertNotNull(response);
            }
        });
        BCtx bCtx = ctx.append(f.b());
        this.checkReachableTypes(aCtx, AProxy.class, BProxy.class);
        this.checkReachableTypes(bCtx, BProxy.class, AProxy.class);
        bCtx.b().to(new Receiver<BProxy>(){

            @Override
            public void onSuccess(BProxy response) {
                Assert.assertNotNull(response);
            }
        });
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                RequestFactoryChainedContextTest.this.finishTest();
            }
        });
    }

    protected Factory createChainedFactory() {
        Factory f = (Factory)GWT.create(Factory.class);
        f.initialize(new SimpleEventBus());
        return f;
    }

    @ProxyFor(value=B.class)
    static interface BProxy
    extends ValueProxy {
    }

    @Service(value=B.class)
    static interface BCtx
    extends RequestContext {
        public Request<BProxy> b();
    }

    public static class B {
        public static B b() {
            return new B();
        }
    }

    @ProxyFor(value=A.class)
    static interface AProxy
    extends ValueProxy {
    }

    @Service(value=A.class)
    static interface ACtx
    extends RequestContext {
        public Request<AProxy> a();
    }

    public static class A {
        public static A a() {
            return new A();
        }
    }

    protected static interface Factory
    extends RequestFactory {
        public ACtx a();

        public BCtx b();
    }
}

