/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.SkipInterfaceValidation;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import junit.framework.Assert;

@SkipInterfaceValidation
public class ProxyForInterfacesTest
extends GWTTestCase {
    private static final int TEST_DELAY = 5000;
    protected Factory factory;

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testProxyForInterfaces() {
        this.delayTestFinish(5000);
        Context ctx = this.factory.ctx();
        ctx.getC0().to(new ReceiverAssert("C0"));
        ctx.getC1_RetI1().to(new ReceiverAssert("C1"));
        ctx.getC2_RetI1().to(new ReceiverAssert("C2"));
        ctx.getC1_RetI2().to(new ReceiverAssert("C1"));
        ctx.getC2_RetI2().to(new ReceiverAssert("C2"));
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                ProxyForInterfacesTest.this.finishTest();
            }
        });
    }

    protected Factory createFactory() {
        Factory f = (Factory)GWT.create(Factory.class);
        f.initialize(new SimpleEventBus());
        return f;
    }

    @Override
    protected void gwtSetUp() throws Exception {
        this.factory = this.createFactory();
    }

    class ReceiverAssert<T extends I1>
    extends Receiver<T> {
        String name;

        public ReceiverAssert(String name) {
            this.name = name;
        }

        @Override
        public void onSuccess(T response) {
            Assert.assertEquals(this.name, response.getName());
        }
    }

    @ProxyFor(value=I2.class)
    static interface I2
    extends I1,
    ValueProxy {
    }

    @ProxyFor(value=I1.class)
    static interface I1
    extends ValueProxy {
        public String getName();
    }

    static class ContextImpl {
        ContextImpl() {
        }

        public static I1 getC0() {
            return new C0();
        }

        public static I1 getC1_RetI1() {
            return new C1();
        }

        public static I2 getC1_RetI2() {
            return new C1();
        }

        public static I1 getC2_RetI1() {
            return new C2();
        }

        public static I2 getC2_RetI2() {
            return new C2();
        }
    }

    @Service(value=ContextImpl.class)
    static interface Context
    extends RequestContext {
        public Request<I1> getC0();

        public Request<I1> getC1_RetI1();

        public Request<I2> getC1_RetI2();

        public Request<I1> getC2_RetI1();

        public Request<I2> getC2_RetI2();
    }

    static class C2
    extends C1 {
        C2() {
        }

        @Override
        public String getName() {
            return "C2";
        }
    }

    static class C1
    implements I2 {
        C1() {
        }

        @Override
        public String getName() {
            return "C1";
        }
    }

    static class C0
    implements I1 {
        C0() {
        }

        @Override
        public String getName() {
            return "C0";
        }
    }

    protected static interface Factory
    extends RequestFactory {
        public Context ctx();
    }
}

