/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.SimpleJsonRpcRequestFactory;
import java.util.Arrays;
import java.util.List;

public class JsonRpcRequestFactoryTest
extends GWTTestCase {
    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testEnumsUsedAsTypeParameter() {
        String[] expectedPayloadRegexes = new String[]{".*\"method\":\"simple.foo\".*", ".*\"params\":\\{\"enums\":\\[\"VALUE\"\\]\\}.*"};
        List<SimpleJsonRpcRequestFactory.SimpleContext.FooRequest.FooEnum> list = Arrays.asList(SimpleJsonRpcRequestFactory.SimpleContext.FooRequest.FooEnum.VALUE);
        this.createFactory(expectedPayloadRegexes).simple().foo().setEnums(list).fire();
    }

    protected SimpleJsonRpcRequestFactory createFactory() {
        return (SimpleJsonRpcRequestFactory)GWT.create(SimpleJsonRpcRequestFactory.class);
    }

    private SimpleJsonRpcRequestFactory createFactory(final String[] expectedPayloadRegexes) {
        SimpleJsonRpcRequestFactory req = this.createFactory();
        req.initialize(new SimpleEventBus(), new RequestTransport(){

            @Override
            public void send(String payload, RequestTransport.TransportReceiver receiver) {
                JsonRpcRequestFactoryTest.stringMatchesRegexes(payload, expectedPayloadRegexes);
            }
        });
        return req;
    }

    private static void stringMatchesRegexes(String string, String[] regexes) {
        for (String regex : regexes) {
            JsonRpcRequestFactoryTest.assertTrue("String \"" + string + "\" did not match \"" + regex + "\"", string.matches(regex));
        }
    }
}

