/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.gwt.client;

import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.requestfactory.gwt.client.RequestFactoryTestBase;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.MapKeyProxy;
import com.google.web.bindery.requestfactory.shared.MapValueProxy;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.SimpleBarProxy;
import com.google.web.bindery.requestfactory.shared.SimpleBarRequest;
import com.google.web.bindery.requestfactory.shared.SimpleEnum;
import com.google.web.bindery.requestfactory.shared.SimpleFooProxy;
import com.google.web.bindery.requestfactory.shared.SimpleFooRequest;
import com.google.web.bindery.requestfactory.shared.SimpleRequestFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

public class FindServiceTest
extends RequestFactoryTestBase {
    private static final int TEST_DELAY = 5000;
    private static final String[] SIMPLE_FOO_RELATIONS = new String[]{"barField", "simpleBarKeyMap", "simpleBarValueMap", "entityKeyAndValueMap"};

    @Override
    public String getModuleName() {
        return "com.google.web.bindery.requestfactory.gwt.RequestFactorySuite";
    }

    public void testChainedFind() {
        this.delayTestFinish(5000);
        List<String> ids = Arrays.asList("1L", "999L");
        final ArrayList proxies = new ArrayList();
        SimpleBarRequest ctx = this.req.simpleBarRequest();
        for (String id : ids) {
            ctx.findSimpleBarById(id).to(new Receiver<SimpleBarProxy>(){

                @Override
                public void onSuccess(SimpleBarProxy response) {
                    proxies.add(response);
                }
            });
        }
        ctx.fire(new Receiver<Void>(){

            @Override
            public void onSuccess(Void response) {
                final ArrayList reloaded = new ArrayList();
                SimpleBarRequest ctx = FindServiceTest.this.req.simpleBarRequest();
                for (SimpleBarProxy proxy : proxies) {
                    ctx.find(proxy.stableId()).to(new Receiver<SimpleBarProxy>(){

                        @Override
                        public void onSuccess(SimpleBarProxy response) {
                            reloaded.add(response);
                        }
                    });
                }
                ctx.fire(new Receiver<Void>(){

                    @Override
                    public void onSuccess(Void response) {
                        Assert.assertEquals(proxies, reloaded);
                        FindServiceTest.this.finishTest();
                    }
                });
            }
        });
    }

    public void testFetchDeletedEntity() {
        this.delayTestFinish(5000);
        SimpleBarRequest context = this.req.simpleBarRequest();
        SimpleBarProxy willDelete = context.create(SimpleBarProxy.class);
        context.persistAndReturnSelf().using(willDelete).fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final EntityProxyId<SimpleBarProxy> id = response.stableId();
                SimpleBarRequest context = FindServiceTest.this.req.simpleBarRequest();
                Request<Void> persist = context.persist().using(response);
                context.edit(response).setFindFails(true);
                persist.fire(new Receiver<Void>(){

                    @Override
                    public void onSuccess(Void response) {
                        FindServiceTest.this.req.find(id).fire(new Receiver<SimpleBarProxy>(){

                            @Override
                            public void onSuccess(SimpleBarProxy response) {
                                Assert.assertNull(response);
                                FindServiceTest.this.finishTestAndReset();
                            }
                        });
                    }
                });
            }
        });
    }

    public void testFetchEntityWithLongId() {
        boolean relationsAbsent = false;
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                FindServiceTest.this.checkReturnedProxy(response, false);
                final EntityProxyId<SimpleFooProxy> stableId = response.stableId();
                FindServiceTest.this.req.find(stableId).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy returnedProxy) {
                        Assert.assertEquals(stableId, returnedProxy.stableId());
                        FindServiceTest.this.checkReturnedProxy(returnedProxy, false);
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testFetchEntityWithRelation() {
        boolean relationsPresent = true;
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with(SIMPLE_FOO_RELATIONS).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                FindServiceTest.this.checkReturnedProxy(response, true);
                final EntityProxyId<SimpleFooProxy> stableId = response.stableId();
                FindServiceTest.this.req.find(stableId).with(SIMPLE_FOO_RELATIONS).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy returnedProxy) {
                        Assert.assertEquals(stableId, returnedProxy.stableId());
                        FindServiceTest.this.checkReturnedProxy(returnedProxy, true);
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testFetchEntityWithEntityKeyValueMapNoChildren() {
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with("entityKeyAndValueMap").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(1, response.getEntityKeyAndValueMap().size());
                Map.Entry<MapKeyProxy, MapValueProxy> entry = response.getEntityKeyAndValueMap().entrySet().iterator().next();
                Assert.assertNotNull(entry.getKey());
                Assert.assertNotNull(entry.getValue());
                Assert.assertNull(entry.getKey().getSimple());
                Assert.assertNull(entry.getValue().getSimple());
                FindServiceTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntityWithEntityKeyValueMapJustKeyChildren() {
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with("entityKeyAndValueMap.keys.simple").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(1, response.getEntityKeyAndValueMap().size());
                Map.Entry<MapKeyProxy, MapValueProxy> entry = response.getEntityKeyAndValueMap().entrySet().iterator().next();
                Assert.assertNotNull(entry.getKey());
                Assert.assertNotNull(entry.getValue());
                Assert.assertNotNull(entry.getKey().getSimple());
                Assert.assertNull(entry.getValue().getSimple());
                FindServiceTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntityWithEntityKeyValueMapJustValueChildren() {
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with("entityKeyAndValueMap.values.simple").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(1, response.getEntityKeyAndValueMap().size());
                Map.Entry<MapKeyProxy, MapValueProxy> entry = response.getEntityKeyAndValueMap().entrySet().iterator().next();
                Assert.assertNotNull(entry.getKey());
                Assert.assertNotNull(entry.getValue());
                Assert.assertNull(entry.getKey().getSimple());
                Assert.assertNotNull(entry.getValue().getSimple());
                FindServiceTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntityWithEntityKeyValueMapBothKeyAndValueChildren() {
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with("entityKeyAndValueMap.keys.simple", "entityKeyAndValueMap.values.simple").fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(1, response.getEntityKeyAndValueMap().size());
                Map.Entry<MapKeyProxy, MapValueProxy> entry = response.getEntityKeyAndValueMap().entrySet().iterator().next();
                Assert.assertNotNull(entry.getKey());
                Assert.assertNotNull(entry.getValue());
                Assert.assertNotNull(entry.getKey().getSimple());
                Assert.assertNotNull(entry.getValue().getSimple());
                FindServiceTest.this.finishTestAndReset();
            }
        });
    }

    public void testFetchEntityWithRelationWithEmptyMaps() {
        boolean relationsPresent = true;
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).with(SIMPLE_FOO_RELATIONS).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                FindServiceTest.this.checkReturnedProxy(response, true);
                SimpleFooRequest editRequest = FindServiceTest.this.req.simpleFooRequest();
                SimpleFooProxy editableSimpleFoo = editRequest.edit(response);
                editableSimpleFoo.setSimpleBarKeyMap(new HashMap<SimpleBarProxy, Integer>());
                editableSimpleFoo.setSimpleBarValueMap(new HashMap<Integer, SimpleBarProxy>());
                editRequest.persistAndReturnSelf().using(editableSimpleFoo).with(SIMPLE_FOO_RELATIONS).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy returnedProxy) {
                        Assert.assertEquals(0, returnedProxy.getSimpleBarKeyMap().size());
                        Assert.assertEquals(0, returnedProxy.getSimpleBarValueMap().size());
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testFetchEntityWithStringId() {
        this.delayTestFinish(5000);
        this.req.simpleBarRequest().findSimpleBarById("999L").fire(new Receiver<SimpleBarProxy>(){

            @Override
            public void onSuccess(SimpleBarProxy response) {
                final EntityProxyId<SimpleBarProxy> stableId = response.stableId();
                FindServiceTest.this.req.find(stableId).fire(new Receiver<SimpleBarProxy>(){

                    @Override
                    public void onSuccess(SimpleBarProxy returnedProxy) {
                        Assert.assertEquals(stableId, returnedProxy.stableId());
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testFetchsAfterCreateDontUpdate() {
        final int[] count = new int[]{0};
        final HandlerRegistration registration = EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, new EntityProxyChange.Handler<SimpleFooProxy>(){

            @Override
            public void onProxyChange(EntityProxyChange<SimpleFooProxy> event) {
                count[0] = count[0] + 1;
            }
        });
        this.delayTestFinish(5000);
        SimpleFooRequest context = this.req.simpleFooRequest();
        SimpleFooProxy proxy = context.create(SimpleFooProxy.class);
        context.persistAndReturnSelf().using(proxy).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(2, count[0]);
                FindServiceTest.this.req.find(response.stableId()).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy response) {
                        Assert.assertEquals(2, count[0]);
                        registration.removeHandler();
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    public void testFetchUnpersistedFutureId() {
        SimpleRequestFactory oldFactory = this.createFactory();
        EntityProxyId<SimpleBarProxy> id = oldFactory.simpleBarRequest().create(SimpleBarProxy.class).stableId();
        String historyToken = oldFactory.getHistoryToken(id);
        EntityProxyId id2 = this.req.getProxyId(historyToken);
        FindServiceTest.assertNotNull(id2);
        try {
            this.req.find(id2);
            FindServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMultipleFetchesDontUpdate() {
        final int[] count = new int[]{0};
        final HandlerRegistration registration = EntityProxyChange.registerForProxyType(this.req.getEventBus(), SimpleFooProxy.class, new EntityProxyChange.Handler<SimpleFooProxy>(){

            @Override
            public void onProxyChange(EntityProxyChange<SimpleFooProxy> event) {
                count[0] = count[0] + 1;
            }
        });
        this.delayTestFinish(5000);
        this.req.simpleFooRequest().findSimpleFooById(999L).fire(new Receiver<SimpleFooProxy>(){

            @Override
            public void onSuccess(SimpleFooProxy response) {
                Assert.assertEquals(1, count[0]);
                EntityProxyId<SimpleFooProxy> stableId = response.stableId();
                FindServiceTest.this.req.find(stableId).fire(new Receiver<SimpleFooProxy>(){

                    @Override
                    public void onSuccess(SimpleFooProxy returnedProxy) {
                        Assert.assertEquals(1, count[0]);
                        registration.removeHandler();
                        FindServiceTest.this.finishTestAndReset();
                    }
                });
            }
        });
    }

    private void checkReturnedProxy(SimpleFooProxy response, boolean checkForRelations) {
        FindServiceTest.assertEquals(42, response.getIntId());
        FindServiceTest.assertEquals("GWT", response.getUserName());
        FindServiceTest.assertEquals(8L, response.getLongField());
        FindServiceTest.assertEquals((Object)SimpleEnum.FOO, (Object)response.getEnumField());
        FindServiceTest.assertEquals(3, response.getValueMap().size());
        if (checkForRelations) {
            FindServiceTest.assertNotNull(response.getBarField());
            FindServiceTest.assertEquals(1, response.getSimpleBarKeyMap().size());
            FindServiceTest.assertEquals(1, response.getEntityKeyAndValueMap().size());
        } else {
            FindServiceTest.assertEquals(null, response.getBarField());
            FindServiceTest.assertEquals(null, response.getSimpleBarKeyMap());
            FindServiceTest.assertEquals(null, response.getEntityKeyAndValueMap());
        }
    }
}

