/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Utility {
    private static String sInstallPath = null;
    private static Pattern versionPattern = Pattern.compile("([0-9]+(?:\\.[0-9]+)*)((?:_[a-zA-Z0-9]+)?)");

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File createNormalFile(File parent, String fileName, boolean overwrite, boolean ignore) throws IOException {
        File file = new File(parent, fileName);
        if (file.createNewFile()) {
            System.out.println("Created file " + file);
            return file;
        }
        if (!file.exists() || file.isDirectory()) {
            throw new IOException(file.getPath() + " : could not create normal file.");
        }
        if (ignore) {
            System.out.println(file + " already exists; skipping");
            return null;
        }
        if (!overwrite) {
            throw new IOException(file.getPath() + " : already exists; please remove it or use the -overwrite or -ignore option.");
        }
        System.out.println("Overwriting existing file " + file);
        return file;
    }

    public static File getDirectory(File parent, String dirName, boolean create) throws IOException {
        File dir = new File(parent, dirName);
        boolean alreadyExisted = dir.exists();
        if (create) {
            dir.mkdirs();
        }
        if (!dir.exists() || !dir.isDirectory()) {
            if (create) {
                throw new IOException(dir.getPath() + " : could not create directory.");
            }
            throw new IOException(dir.getPath() + " : could not find directory.");
        }
        if (create && !alreadyExisted) {
            System.out.println("Created directory " + dir);
        }
        return dir;
    }

    public static File getDirectory(String dirPath, boolean create) throws IOException {
        return Utility.getDirectory(null, dirPath, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileFromClassPath(String partialPath) throws IOException {
        InputStream in = Utility.class.getClassLoader().getResourceAsStream(partialPath);
        try {
            if (in == null) {
                throw new FileNotFoundException(partialPath);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utility.streamOut(in, os, 1024);
            String string = new String(os.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            Utility.close(in);
        }
    }

    public static String getInstallPath() {
        if (sInstallPath == null) {
            Utility.computeInstallationPath();
        }
        return sInstallPath;
    }

    public static File makeTemporaryDirectory(File baseDir, String prefix) throws IOException {
        if (baseDir == null) {
            baseDir = new File(System.getProperty("java.io.tmpdir"));
        }
        baseDir.mkdirs();
        for (int tries = 0; tries < 3; ++tries) {
            File result = File.createTempFile(prefix, null, baseDir);
            if (!result.delete()) {
                throw new IOException("Couldn't delete temporary file " + result.getAbsolutePath() + " to replace with a directory.");
            }
            if (!result.mkdirs()) continue;
            return result;
        }
        throw new IOException("Couldn't create temporary directory after 3 tries in " + baseDir.getAbsolutePath());
    }

    public static void streamOut(InputStream in, OutputStream out, int bufferSize) throws IOException {
        assert (bufferSize >= 0);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void writeTemplateBinaryFile(File file, byte[] contents) throws IOException {
        FileOutputStream o = new FileOutputStream(file);
        o.write(contents);
        Utility.close(o);
    }

    public static void writeTemplateFile(File file, String contents, Map<String, String> replacements) throws IOException {
        String replacedContents = contents;
        Set<Map.Entry<String, String>> entries = replacements.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String replaceThis = entry.getKey();
            String withThis = entry.getValue();
            withThis = withThis.replaceAll("\\\\", "\\\\\\\\");
            withThis = withThis.replaceAll("\\$", "\\\\\\$");
            replacedContents = replacedContents.replaceAll(replaceThis, withThis);
        }
        PrintWriter pw = new PrintWriter(file);
        LineNumberReader lnr = new LineNumberReader(new StringReader(replacedContents));
        String line = lnr.readLine();
        while (line != null) {
            pw.println(line);
            line = lnr.readLine();
        }
        Utility.close(pw);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void computeInstallationPath() {
        try {
            String override = System.getProperty("gwt.devjar");
            if (override == null) {
                String partialPath = Utility.class.getName().replace('.', '/').concat(".class");
                URL url = Utility.class.getClassLoader().getResource(partialPath);
                if (url == null || !"jar".equals(url.getProtocol())) throw new IOException("Cannot determine installation directory; apparently not running from a jar");
                String path = url.toString();
                String jarPath = path.substring(path.indexOf("file:"), path.lastIndexOf(33));
                File devJarFile = new File(URI.create(jarPath));
                if (!devJarFile.isFile()) {
                    throw new IOException("Could not find jar file; " + devJarFile.getCanonicalPath() + " does not appear to be a valid file");
                }
                String dirPath = jarPath.substring(0, jarPath.lastIndexOf(47) + 1);
                File installDirFile = new File(URI.create(dirPath));
                if (!installDirFile.isDirectory()) {
                    throw new IOException("Could not find installation directory; " + installDirFile.getCanonicalPath() + " does not appear to be a valid directory");
                }
                sInstallPath = installDirFile.getCanonicalPath().replace(File.separatorChar, '/');
                return;
            } else {
                int pos = (override = override.replace('\\', '/')).lastIndexOf(47);
                sInstallPath = pos < 0 ? "" : override.substring(0, pos);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Installation problem detected, please reinstall GWT", e);
        }
    }

    public static int versionCompare(String v1, String v2) {
        Matcher v1Matcher = versionPattern.matcher(v1);
        Matcher v2Matcher = versionPattern.matcher(v2);
        if (!v1Matcher.matches() || !v2Matcher.matches()) {
            throw new IllegalArgumentException(v1Matcher.matches() ? v2 : v1 + " is not a proper version string");
        }
        String[] v1Prefix = v1Matcher.group(1).split("\\.");
        String[] v2Prefix = v2Matcher.group(1).split("\\.");
        for (int i = 0; i < v1Prefix.length; ++i) {
            if (v2Prefix.length <= i) {
                return 1;
            }
            int compare = Integer.parseInt(v1Prefix[i]) - Integer.parseInt(v2Prefix[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (v2Prefix.length == v1Prefix.length) {
            return v1Matcher.group(2).compareTo(v2Matcher.group(2));
        }
        return -1;
    }
}

