/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools;

import com.google.gwt.dev.About;
import com.google.gwt.util.tools.ArgHandler;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public abstract class ToolBase {
    private static final String PROPERTY_NOWARN_LEGACY_TOOLS = "gwt.nowarn.legacy.tools";
    private final Map<String, ArgHandler> argHandlers = new LinkedHashMap<String, ArgHandler>();

    protected void checkJdkVersion() {
        double classVersion = Double.valueOf(System.getProperty("java.class.version", "0.0"));
        if (classVersion < 50.0) {
            System.err.println("WARNING: Use on a JRE prior to version 1.6 is deprecated");
        }
    }

    protected String getDescription() {
        return null;
    }

    protected String getName() {
        return this.getClass().getName();
    }

    protected void printHelp() {
        this.printHelp(false);
    }

    protected void printHelp(boolean includeUndocumented) {
        System.err.println(About.getGwtVersion());
        LinkedHashSet<ArgHandler> uniqueArgHandlers = new LinkedHashSet<ArgHandler>(this.argHandlers.values());
        ArgHandler nullHandler = null;
        int widest = 0;
        for (ArgHandler handler : uniqueArgHandlers) {
            if (handler.isUndocumented()) continue;
            String helpTag = handler.getHelpTag();
            if (helpTag != null) {
                if (helpTag.length() <= widest) continue;
                widest = helpTag.length();
                continue;
            }
            nullHandler = handler;
            int len = nullHandler.getTagArgs()[0].length();
            if (len <= widest) continue;
            widest = len;
        }
        String name = this.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        System.err.print(name);
        for (ArgHandler handler : uniqueArgHandlers) {
            String[] tagArgs;
            String helpTag;
            if (!includeUndocumented && handler.isUndocumented() || (helpTag = handler.getHelpTag()) == null) continue;
            System.err.print(handler.isRequired() ? " " : " [");
            System.err.print(helpTag);
            for (String tagArg : tagArgs = handler.getTagArgs()) {
                System.err.print(" " + tagArg);
            }
            System.err.print(handler.isRequired() ? "" : "]");
        }
        if (nullHandler != null && (!nullHandler.isUndocumented() || includeUndocumented)) {
            String[] tagArgs;
            for (String element : tagArgs = nullHandler.getTagArgs()) {
                System.err.print(nullHandler.isRequired() ? " " : " [");
                System.err.print(element);
                System.err.print(nullHandler.isRequired() ? " " : "]");
            }
            System.err.println();
        }
        System.err.println();
        String description = this.getDescription();
        if (description != null) {
            System.err.println(description);
            System.err.println();
        }
        System.err.println("where ");
        for (ArgHandler handler : uniqueArgHandlers) {
            String helpTag;
            if (!includeUndocumented && handler.isUndocumented() || (helpTag = handler.getHelpTag()) == null) continue;
            int len = helpTag.length();
            System.err.print("  ");
            System.err.print(helpTag);
            for (i = len; i < widest; ++i) {
                System.err.print(' ');
            }
            System.err.print("  ");
            System.err.print(handler.getPurpose());
            System.err.println();
        }
        if (nullHandler != null && (!nullHandler.isUndocumented() || includeUndocumented)) {
            System.err.println("and ");
            String tagArg = nullHandler.getTagArgs()[0];
            int len = tagArg.length();
            System.err.print("  ");
            System.err.print(tagArg);
            for (i = len; i < widest; ++i) {
                System.err.print(' ');
            }
            System.err.print("  ");
            System.err.print(nullHandler.getPurpose());
            System.err.println();
        }
    }

    protected boolean processArgs(String ... args) {
        this.checkJdkVersion();
        if (args.length > 0) {
            boolean help = false;
            boolean helpUndocumented = false;
            if ("-help".equalsIgnoreCase(args[0])) {
                help = true;
            } else if ("-?".equals(args[0])) {
                help = true;
            } else if ("-helpfull".equalsIgnoreCase(args[0])) {
                helpUndocumented = true;
                help = true;
            } else if ("-??".equals(args[0])) {
                helpUndocumented = true;
                help = true;
            }
            if (help) {
                this.printHelp(helpUndocumented);
                return false;
            }
        }
        HashSet<ArgHandler> defs = new HashSet<ArgHandler>(this.argHandlers.values());
        int extraArgCount = 0;
        HashSet<ArgHandler> receivedArg = new HashSet<ArgHandler>();
        ArgHandler nullHandler = this.argHandlers.get("");
        for (int i = 0; i < args.length; ++i) {
            ArgHandler handler;
            String arg = args[i];
            if (arg.startsWith("-")) {
                handler = this.argHandlers.get(arg);
            } else {
                handler = nullHandler;
                ++extraArgCount;
            }
            if (handler == null) {
                System.err.println("Unknown argument: " + arg);
                this.printHelp();
                return false;
            }
            int addtlConsumed = handler.handle(args, i);
            if (addtlConsumed == -1) {
                this.printHelp();
                return false;
            }
            i += addtlConsumed;
            defs.remove(handler);
            receivedArg.add(handler);
        }
        for (ArgHandler argHandler : this.argHandlers.values()) {
            if (!argHandler.isRequired() || receivedArg.contains(argHandler)) continue;
            System.err.print("Missing required argument '");
            String tag = argHandler.getTag();
            if (tag != null) {
                System.err.print(tag);
                System.err.print(" ");
            }
            String tagArg = argHandler.getTagArgs()[0];
            System.err.print(tagArg);
            System.err.println("'");
            this.printHelp();
            return false;
        }
        if (extraArgCount == 0 && nullHandler != null && nullHandler.isRequired()) {
            System.err.print("Missing required argument '");
            String tagArg = nullHandler.getTagArgs()[0];
            System.err.print(tagArg);
            System.err.println("'");
            this.printHelp();
            return false;
        }
        for (ArgHandler def : defs) {
            String[] defArgs = def.getDefaultArgs();
            if (defArgs == null || def.handle(defArgs, 0) != -1) continue;
            return false;
        }
        return true;
    }

    protected void registerHandler(ArgHandler handler) {
        for (String tag : handler.getTags()) {
            tag = tag != null ? tag : "";
            this.argHandlers.put(tag, handler);
        }
    }
}

