/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.util.tools.ArgHandler;

public class ArgHandlerNoopDeprecatedFlag
extends ArgHandler {
    private final int numberOfArgumentsToConsume;
    private String[] tags;

    public ArgHandlerNoopDeprecatedFlag(int numberOfArgumentsToConsume, String ... tags) {
        Preconditions.checkArgument(tags != null);
        Preconditions.checkArgument(tags.length != 0);
        this.numberOfArgumentsToConsume = numberOfArgumentsToConsume;
        this.tags = tags;
    }

    public ArgHandlerNoopDeprecatedFlag(String ... tags) {
        this(0, tags);
    }

    @Override
    public boolean isUndocumented() {
        return true;
    }

    @Override
    public String getPurpose() {
        return "DEPRECATED: Has no effect and will be removed in a future release";
    }

    @Override
    public String getTag() {
        return this.tags[0];
    }

    @Override
    public String[] getTagArgs() {
        return this.tags;
    }

    @Override
    public int handle(String[] args, int startIndex) {
        String tag = args[startIndex];
        if (startIndex + this.numberOfArgumentsToConsume >= args.length) {
            System.err.println(tag + " should be followed by parameters.");
            return -1;
        }
        System.err.println(this.getWarningMessage(tag));
        return this.numberOfArgumentsToConsume;
    }

    protected String getWarningMessage(String tag) {
        return "The " + tag + " option is deprecated. It will be removed in a future release and will throw an error if it is still used.";
    }
}

