/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools;

import com.google.gwt.dev.util.Empty;
import com.google.gwt.util.tools.ArgHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ArgHandlerFlag
extends ArgHandler {
    private Map<String, Boolean> valuesByTag;

    protected void addTagValue(String tag, boolean value) {
        this.initValuesByTag();
        this.valuesByTag.put(tag, value);
    }

    public abstract boolean getDefaultValue();

    @Override
    public String getHelpTag() {
        return "-" + (this.isExperimental() ? "X" : "") + "[no]" + this.getLabel();
    }

    public String getLabel() {
        return "";
    }

    @Override
    public final String getPurpose() {
        return (this.isExperimental() ? "EXPERIMENTAL: " : "") + this.getPurposeSnippet() + " (defaults to " + (this.getDefaultValue() ? "ON" : "OFF") + ")";
    }

    public abstract String getPurposeSnippet();

    @Override
    public final String getTag() {
        String label = this.getLabel();
        if (label == "") {
            return "";
        }
        return "-" + (this.isExperimental() ? "X" : "") + label;
    }

    @Override
    public String[] getTagArgs() {
        return Empty.STRINGS;
    }

    @Override
    public final String[] getTags() {
        this.initValuesByTag();
        Set<String> tags = this.valuesByTag.keySet();
        return tags.toArray(new String[tags.size()]);
    }

    boolean getValueByTag(String tag) {
        this.initValuesByTag();
        return this.valuesByTag.get(tag);
    }

    @Override
    public int handle(String[] args, int startIndex) {
        String tag = args[startIndex];
        Boolean value = this.getValueByTag(tag);
        return this.setFlag(value) ? 0 : 1;
    }

    private void initValuesByTag() {
        if (this.valuesByTag != null) {
            return;
        }
        this.valuesByTag = new LinkedHashMap<String, Boolean>();
        this.valuesByTag.put("-" + (this.isExperimental() ? "X" : "") + this.getLabel(), true);
        this.valuesByTag.put("-" + (this.isExperimental() ? "X" : "") + "no" + this.getLabel(), false);
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    public abstract boolean setFlag(boolean var1);
}

