/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.tools;

import com.google.gwt.thirdparty.guava.common.base.Ascii;
import com.google.gwt.thirdparty.guava.common.base.Enums;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.util.tools.ArgHandler;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ArgHandlerEnum<T extends Enum<T>>
extends ArgHandler {
    private final Class<T> optionsEnumClass;
    private final T defaultValue;
    private final boolean allowAbbreviation;
    private static final int ABBREVIATION_MIN_SIZE = 3;

    public ArgHandlerEnum(Class<T> optionsEnumClass) {
        this(optionsEnumClass, null, false);
    }

    public ArgHandlerEnum(Class<T> optionsEnumClass, @Nullable T defaultValue, boolean allowAbbreviation) {
        Preconditions.checkArgument(((Enum[])optionsEnumClass.getEnumConstants()).length > 1);
        this.optionsEnumClass = Preconditions.checkNotNull(optionsEnumClass);
        this.defaultValue = defaultValue;
        this.allowAbbreviation = allowAbbreviation;
    }

    @Override
    public String[] getDefaultArgs() {
        if (this.defaultValue == null) {
            return null;
        }
        return new String[]{this.getTag(), ((Enum)this.defaultValue).name()};
    }

    @Override
    public String[] getTagArgs() {
        return new String[]{"(" + this.getFormattedOptionNames("|", this.optionsEnumClass) + ")"};
    }

    @Override
    public final int handle(String[] args, int startIndex) {
        int optionValueIndex = startIndex + 1;
        if (optionValueIndex < args.length) {
            String value = Ascii.toUpperCase(args[optionValueIndex].trim());
            T mode = this.matchOption(value);
            if (mode == null) {
                System.err.format("%s is not a valid option for %s\n", value, this.getTag());
                System.err.format("%s value must be one of %s.\n", this.getTag(), this.getFormattedOptionNames(", ", " or ", this.optionsEnumClass));
                return -1;
            }
            this.setValue(mode);
            return 1;
        }
        System.err.format("Missing argument for %s must be followed by one of %s.\n" + this.getTag(), this.getFormattedOptionNames(", ", " or ", this.optionsEnumClass));
        return -1;
    }

    protected String getPurposeString(String prefix) {
        String maybeExperimentalString = this.isExperimental() ? "EXPERIMENTAL: " : "";
        String defaultValueString = this.defaultValue != null ? " (defaults to " + ((Enum)this.defaultValue).name() + ")" : "";
        return String.format("%s%s %s%s", maybeExperimentalString, prefix, this.getFormattedOptionNames(", ", " or ", this.optionsEnumClass), defaultValueString);
    }

    public abstract void setValue(T var1);

    private List<String> getEnumNames(Class<T> optionsEnumClass) {
        return FluentIterable.from(Arrays.asList((Enum[])optionsEnumClass.getEnumConstants())).transform(Enums.stringConverter(optionsEnumClass).reverse()).toList();
    }

    private String getFormattedOptionNames(String separator, Class<T> optionsEnumClass) {
        return this.getFormattedOptionNames(separator, separator, optionsEnumClass);
    }

    private String getFormattedOptionNames(String separator, String lastSeparator, Class<T> optionsEnumClass) {
        List<String> enumNames = this.getEnumNames(optionsEnumClass);
        List<String> allNamesButLast = enumNames.subList(0, enumNames.size() - 1);
        String lastName = enumNames.get(enumNames.size() - 1);
        return Joiner.on(separator).join(allNamesButLast) + lastSeparator + lastName;
    }

    private Predicate<Enum<?>> buildMatchPredicate(final String value) {
        return new Predicate<Enum<?>>(){

            @Override
            public boolean apply(Enum<?> t) {
                if (ArgHandlerEnum.this.allowAbbreviation && value.length() >= 3) {
                    return t.name().startsWith(value);
                }
                return t.name().equals(value);
            }
        };
    }

    private T matchOption(String value) {
        ImmutableList<Enum<?>> matchedOptions = FluentIterable.from(Arrays.asList((Enum[])this.optionsEnumClass.getEnumConstants())).filter(this.buildMatchPredicate(value)).toList();
        return (T)(matchedOptions.size() == 1 ? (Enum)matchedOptions.get(0) : null);
    }
}

