/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.regexfilter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class RegexFilter
implements Serializable {
    private final List<String> values = new ArrayList<String>();
    private final ArrayList<Pattern> typePatterns = new ArrayList();
    private final ArrayList<Boolean> includeType = new ArrayList();

    public RegexFilter() {
    }

    public RegexFilter(TreeLogger logger, List<String> values) throws UnableToCompleteException {
        this();
        try {
            this.addAll(values);
        }
        catch (IllegalArgumentException e) {
            logger.log(TreeLogger.ERROR, "Got malformed filter entry\n" + e.getMessage());
            throw new UnableToCompleteException();
        }
        if (logger.isLoggable(TreeLogger.DEBUG)) {
            for (String regex : values) {
                logger.log(TreeLogger.DEBUG, "Got filter entry '" + regex + "'");
            }
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public List<String> getValues() {
        return ImmutableList.copyOf(this.values);
    }

    public void add(String regex) {
        if (regex.length() == 0) {
            throw new IllegalArgumentException("empty entry");
        }
        boolean include = this.entriesArePositiveByDefault();
        char c = regex.charAt(0);
        if (c == '+' || c == '-') {
            regex = regex.substring(1);
            include = c == '+';
        }
        Pattern p = Pattern.compile(regex);
        this.values.add((include ? (char)'+' : '-') + regex);
        this.typePatterns.add(p);
        this.includeType.add(include);
    }

    public void addAll(List<String> newValues) {
        for (String regex : newValues) {
            this.add(regex);
        }
    }

    public void addAll(RegexFilter regexFilter) {
        this.addAll(regexFilter.values);
    }

    public boolean isIncluded(String query) {
        return this.isIncluded(TreeLogger.NULL, query);
    }

    public boolean isIncluded(TreeLogger logger, String query) {
        logger = logger.branch(TreeLogger.DEBUG, "Considering query " + query);
        int size = this.typePatterns.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Considering filter rule " + this.values.get(idx) + " for query " + query);
            }
            boolean include = this.includeType.get(idx);
            Pattern pattern = this.typePatterns.get(idx);
            if (!pattern.matcher(query).matches()) continue;
            if (include) {
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    logger.log(TreeLogger.DEBUG, "Whitelisting " + query + " according to rule " + this.values.get(idx));
                }
                return true;
            }
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Blacklisting " + query + " according to rule " + this.values.get(idx));
            }
            return false;
        }
        return this.acceptByDefault();
    }

    protected abstract boolean acceptByDefault();

    protected abstract boolean entriesArePositiveByDefault();
}

