/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class StringSourceWriter
implements SourceWriter {
    private final StringWriter buffer = new StringWriter();
    private int indentLevel = 0;
    private String indentPrefix = "";
    private boolean needsIndent;
    private final PrintWriter out = new PrintWriter(this.buffer);

    @Override
    public void beginJavaDocComment() {
        this.println("/**");
        this.indent();
        this.indentPrefix = " * ";
    }

    @Override
    public void commit(TreeLogger logger) {
        this.out.flush();
    }

    @Override
    public void endJavaDocComment() {
        this.out.println("*/");
        this.outdent();
        this.indentPrefix = "";
    }

    @Override
    public void indent() {
        ++this.indentLevel;
    }

    @Override
    public void indentln(String s) {
        this.indent();
        this.println(s);
        this.outdent();
    }

    @Override
    public void indentln(String s, Object ... args) {
        this.indentln(String.format(s, args));
    }

    @Override
    public void outdent() {
        this.indentLevel = Math.max(this.indentLevel - 1, 0);
    }

    @Override
    public void print(String s) {
        this.maybeIndent();
        this.out.print(s);
    }

    @Override
    public void print(String s, Object ... args) {
        this.print(String.format(s, args));
    }

    @Override
    public void println() {
        this.maybeIndent();
        this.out.print('\n');
        this.needsIndent = true;
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    @Override
    public void println(String s, Object ... args) {
        this.println(String.format(s, args));
    }

    public String toString() {
        this.out.flush();
        return this.buffer.getBuffer().toString();
    }

    private void maybeIndent() {
        if (this.needsIndent) {
            this.needsIndent = false;
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.print("  ");
                this.out.print(this.indentPrefix);
            }
        }
    }
}

