/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.aria.client.ExpandedValue;
import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.aria.client.SelectedValue;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.AttachDetachException;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasTreeItems;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsTreeItem;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.SourcesTreeEvents;
import com.google.gwt.user.client.ui.TreeImages;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetIterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Tree
extends Widget
implements HasTreeItems.ForIsWidget,
HasWidgets.ForIsWidget,
SourcesTreeEvents,
HasFocus,
HasAnimation,
HasAllKeyHandlers,
HasAllFocusHandlers,
HasSelectionHandlers<TreeItem>,
HasOpenHandlers<TreeItem>,
HasCloseHandlers<TreeItem>,
SourcesMouseEvents,
HasAllMouseHandlers {
    private final Map<Widget, TreeItem> childWidgets = new HashMap<Widget, TreeItem>();
    private TreeItem curSelection;
    private com.google.gwt.dom.client.Element focusable;
    private ImageAdapter images;
    private String indentValue;
    private boolean isAnimationEnabled = false;
    private boolean lastWasKeyDown;
    private TreeItem root;
    private boolean scrollOnSelectEnabled = true;
    private boolean useLeafImages;

    static boolean shouldTreeDelegateFocusToElement(com.google.gwt.dom.client.Element element) {
        throw new RuntimeException("Cannot call native method");
    }

    public Tree() {
        this.init(new ImageAdapter(), false);
    }

    public Tree(Resources resources) {
        this.init(new ImageAdapter(resources), false);
    }

    public Tree(Resources resources, boolean useLeafImages) {
        this.init(new ImageAdapter(resources), useLeafImages);
    }

    @Deprecated
    public Tree(TreeImages images) {
        this.init(new ImageAdapter(images), false);
    }

    @Deprecated
    public Tree(TreeImages images, boolean useLeafImages) {
        this.init(new ImageAdapter(images), useLeafImages);
    }

    @Override
    public void add(Widget widget) {
        this.addItem(widget);
    }

    @Override
    public void add(IsWidget w) {
        this.add(Tree.asWidgetOrNull(w));
    }

    @Override
    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler(handler, BlurEvent.getType());
    }

    @Override
    public HandlerRegistration addCloseHandler(CloseHandler<TreeItem> handler) {
        return this.addHandler(handler, CloseEvent.getType());
    }

    @Override
    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler(handler, FocusEvent.getType());
    }

    @Override
    @Deprecated
    public void addFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener.add(this, listener);
    }

    @Override
    public TreeItem addItem(SafeHtml itemHtml) {
        return this.root.addItem(itemHtml);
    }

    @Override
    public void addItem(TreeItem item) {
        this.root.addItem(item);
    }

    @Override
    public void addItem(IsTreeItem isItem) {
        this.root.addItem(isItem);
    }

    @Override
    public TreeItem addItem(Widget widget) {
        return this.root.addItem(widget);
    }

    @Override
    public TreeItem addItem(IsWidget w) {
        return this.addItem(Tree.asWidgetOrNull(w));
    }

    @Override
    @Deprecated
    public void addKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler(handler, KeyDownEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler(handler, KeyPressEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler(handler, KeyUpEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addHandler(handler, MouseDownEvent.getType());
    }

    @Override
    @Deprecated
    public void addMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler(handler, MouseMoveEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler(handler, MouseOutEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler(handler, MouseOverEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler(handler, MouseUpEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler(handler, MouseWheelEvent.getType());
    }

    @Override
    public final HandlerRegistration addOpenHandler(OpenHandler<TreeItem> handler) {
        return this.addHandler(handler, OpenEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<TreeItem> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public TreeItem addTextItem(String itemText) {
        return this.root.addTextItem(itemText);
    }

    @Override
    @Deprecated
    public void addTreeListener(TreeListener listener) {
        ListenerWrapper.WrappedTreeListener.add(this, listener);
    }

    @Override
    public void clear() {
        this.root.removeItems();
    }

    public void ensureSelectedItemVisible() {
        if (this.curSelection == null) {
            return;
        }
        for (TreeItem parent = this.curSelection.getParentItem(); parent != null; parent = parent.getParentItem()) {
            parent.setState(true);
        }
    }

    public TreeItem getItem(int index) {
        return this.root.getChild(index);
    }

    public int getItemCount() {
        return this.root.getChildCount();
    }

    public TreeItem getSelectedItem() {
        return this.curSelection;
    }

    @Override
    public int getTabIndex() {
        return FocusPanel.impl.getTabIndex(this.focusable);
    }

    public TreeItem insertItem(int beforeIndex, SafeHtml itemHtml) {
        return this.root.insertItem(beforeIndex, itemHtml);
    }

    public void insertItem(int beforeIndex, TreeItem item) {
        this.root.insertItem(beforeIndex, item);
    }

    public TreeItem insertItem(int beforeIndex, Widget widget) {
        return this.root.insertItem(beforeIndex, widget);
    }

    public TreeItem insertTextItem(int beforeIndex, String itemText) {
        return this.root.insertTextItem(beforeIndex, itemText);
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public boolean isScrollOnSelectEnabled() {
        return this.scrollOnSelectEnabled;
    }

    @Override
    public Iterator<Widget> iterator() {
        Widget[] widgets = new Widget[this.childWidgets.size()];
        this.childWidgets.keySet().toArray(widgets);
        return WidgetIterators.createWidgetIterator(this, widgets);
    }

    @Override
    public void onBrowserEvent(Event event) {
        int eventType = DOM.eventGetType(event);
        switch (eventType) {
            case 128: {
                if (this.curSelection == null) {
                    if (this.root.getChildCount() > 0) {
                        this.onSelection(this.root.getChild(0), true, true);
                    }
                    super.onBrowserEvent(event);
                    return;
                }
            }
            case 256: 
            case 512: {
                if (!event.getAltKey() && !event.getMetaKey()) break;
                super.onBrowserEvent(event);
                return;
            }
        }
        switch (eventType) {
            case 1: {
                Element e = DOM.eventGetTarget(event);
                if (Tree.shouldTreeDelegateFocusToElement(e) || this.curSelection == null || !this.curSelection.getContentElem().isOrHasChild(e)) break;
                this.setFocus(true);
                break;
            }
            case 4: {
                if (DOM.eventGetCurrentTarget(event) != this.getElement() || event.getButton() != 1) break;
                this.elementClicked(DOM.eventGetTarget(event));
                break;
            }
            case 128: {
                this.keyboardNavigation(event);
                this.lastWasKeyDown = true;
                break;
            }
            case 256: {
                if (!this.lastWasKeyDown) {
                    this.keyboardNavigation(event);
                }
                this.lastWasKeyDown = false;
                break;
            }
            case 512: {
                if (event.getKeyCode() == 9) {
                    ArrayList<com.google.gwt.dom.client.Element> chain = new ArrayList<com.google.gwt.dom.client.Element>();
                    this.collectElementChain(chain, this.getElement(), DOM.eventGetTarget(event));
                    TreeItem item = this.findItemByChain(chain, 0, this.root);
                    if (item != this.getSelectedItem()) {
                        this.setSelectedItem(item, true);
                    }
                }
                this.lastWasKeyDown = false;
            }
        }
        switch (eventType) {
            case 128: 
            case 512: {
                if (!KeyCodes.isArrowKey(event.getKeyCode())) break;
                event.stopPropagation();
                event.preventDefault();
                return;
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    public boolean remove(Widget w) {
        TreeItem item = this.childWidgets.get(w);
        if (item == null) {
            return false;
        }
        item.setWidget(null);
        return true;
    }

    @Override
    public boolean remove(IsWidget w) {
        return this.remove(w.asWidget());
    }

    @Override
    @Deprecated
    public void removeFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener.remove(this, listener);
    }

    @Override
    public void removeItem(TreeItem item) {
        this.root.removeItem(item);
    }

    @Override
    public void removeItem(IsTreeItem isItem) {
        if (isItem != null) {
            TreeItem item = isItem.asTreeItem();
            this.removeItem(item);
        }
    }

    @Override
    public void removeItems() {
        while (this.getItemCount() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    @Override
    @Deprecated
    public void removeKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeTreeListener(TreeListener listener) {
        ListenerWrapper.WrappedTreeListener.remove(this, listener);
    }

    @Override
    public void setAccessKey(char key) {
        FocusPanel.impl.setAccessKey(this.focusable, key);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    @Override
    public void setFocus(boolean focus) {
        if (focus) {
            FocusPanel.impl.focus(this.focusable);
        } else {
            FocusPanel.impl.blur(this.focusable);
        }
    }

    public void setScrollOnSelectEnabled(boolean enable) {
        this.scrollOnSelectEnabled = enable;
    }

    public void setSelectedItem(TreeItem item) {
        this.setSelectedItem(item, true);
    }

    public void setSelectedItem(TreeItem item, boolean fireEvents) {
        if (item == null) {
            if (this.curSelection == null) {
                return;
            }
            this.curSelection.setSelected(false);
            this.curSelection = null;
            return;
        }
        this.onSelection(item, fireEvents, true);
    }

    @Override
    public void setTabIndex(int index) {
        FocusPanel.impl.setTabIndex(this.focusable, index);
    }

    public Iterator<TreeItem> treeItemIterator() {
        ArrayList<TreeItem> accum = new ArrayList<TreeItem>();
        this.root.addTreeItems(accum);
        return accum.iterator();
    }

    @Override
    protected void doAttachChildren() {
        try {
            AttachDetachException.tryCommand(this, AttachDetachException.attachCommand);
        }
        finally {
            DOM.setEventListener(this.focusable, this);
        }
    }

    @Override
    protected void doDetachChildren() {
        try {
            AttachDetachException.tryCommand(this, AttachDetachException.detachCommand);
        }
        finally {
            DOM.setEventListener(this.focusable, null);
        }
    }

    protected boolean isKeyboardNavigationEnabled(TreeItem currentItem) {
        return true;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.root.ensureDebugId(baseID + "-root");
    }

    @Override
    protected void onLoad() {
        this.root.updateStateRecursive();
    }

    void adopt(Widget widget, TreeItem treeItem) {
        assert (!this.childWidgets.containsKey(widget));
        this.childWidgets.put(widget, treeItem);
        widget.setParent(this);
    }

    void fireStateChanged(TreeItem item, boolean open) {
        if (open) {
            OpenEvent.fire(this, item);
        } else {
            CloseEvent.fire(this, item);
        }
    }

    Map<Widget, TreeItem> getChildWidgets() {
        return this.childWidgets;
    }

    ImageAdapter getImages() {
        return this.images;
    }

    void maybeUpdateSelection(TreeItem itemThatChangedState, boolean isItemOpening) {
        if (!isItemOpening) {
            for (TreeItem tempItem = this.curSelection; tempItem != null; tempItem = tempItem.getParentItem()) {
                if (tempItem != itemThatChangedState) continue;
                this.setSelectedItem(itemThatChangedState);
                return;
            }
        }
    }

    void orphan(Widget widget) {
        assert (widget.getParent() == this);
        try {
            widget.setParent(null);
        }
        finally {
            this.childWidgets.remove(widget);
        }
    }

    void showClosedImage(TreeItem treeItem) {
        this.showImage(treeItem, this.images.treeClosed());
    }

    void showLeafImage(TreeItem treeItem) {
        if (this.useLeafImages || treeItem.isFullNode()) {
            this.showImage(treeItem, this.images.treeLeaf());
        } else if (LocaleInfo.getCurrentLocale().isRTL()) {
            treeItem.getElement().getStyle().setProperty("paddingRight", this.indentValue);
        } else {
            treeItem.getElement().getStyle().setProperty("paddingLeft", this.indentValue);
        }
    }

    void showOpenImage(TreeItem treeItem) {
        this.showImage(treeItem, this.images.treeOpen());
    }

    private void collectElementChain(ArrayList<com.google.gwt.dom.client.Element> chain, com.google.gwt.dom.client.Element hRoot, com.google.gwt.dom.client.Element hElem) {
        if (hElem == null || hElem == hRoot) {
            return;
        }
        this.collectElementChain(chain, hRoot, DOM.getParent(hElem));
        chain.add(hElem);
    }

    private boolean elementClicked(com.google.gwt.dom.client.Element hElem) {
        ArrayList<com.google.gwt.dom.client.Element> chain = new ArrayList<com.google.gwt.dom.client.Element>();
        this.collectElementChain(chain, this.getElement(), hElem);
        TreeItem item = this.findItemByChain(chain, 0, this.root);
        if (item != null && item != this.root) {
            if (item.getChildCount() > 0 && item.getImageElement().isOrHasChild(hElem)) {
                item.setState(!item.getState(), true);
                return true;
            }
            if (item.getElement().isOrHasChild(hElem)) {
                this.onSelection(item, true, !Tree.shouldTreeDelegateFocusToElement(hElem));
                return true;
            }
        }
        return false;
    }

    private TreeItem findDeepestOpenChild(TreeItem item) {
        if (!item.getState()) {
            return item;
        }
        return this.findDeepestOpenChild(item.getChild(item.getChildCount() - 1));
    }

    private TreeItem findItemByChain(ArrayList<com.google.gwt.dom.client.Element> chain, int idx, TreeItem root) {
        if (idx == chain.size()) {
            return root;
        }
        com.google.gwt.dom.client.Element hCurElem = chain.get(idx);
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeItem child = root.getChild(i);
            if (child.getElement() != hCurElem) continue;
            TreeItem retItem = this.findItemByChain(chain, idx + 1, root.getChild(i));
            if (retItem == null) {
                return child;
            }
            return retItem;
        }
        return this.findItemByChain(chain, idx + 1, root);
    }

    private TreeItem getTopClosedParent(TreeItem item) {
        TreeItem topClosedParent = null;
        for (TreeItem parent = item.getParentItem(); parent != null && parent != this.root; parent = parent.getParentItem()) {
            if (parent.getState()) continue;
            topClosedParent = parent;
        }
        return topClosedParent;
    }

    private void init(ImageAdapter images, boolean useLeafImages) {
        this.setImages(images, useLeafImages);
        this.setElement(DOM.createDiv());
        this.getElement().getStyle().setProperty("position", "relative");
        this.getElement().getStyle().setProperty("zoom", "1");
        this.focusable = FocusPanel.impl.createFocusable();
        this.focusable.getStyle().setProperty("fontSize", "0");
        this.focusable.getStyle().setProperty("position", "absolute");
        this.focusable.getStyle().setProperty("outline", "0px");
        this.focusable.setAttribute("hideFocus", "true");
        DOM.setIntStyleAttribute(this.focusable, "zIndex", -1);
        DOM.appendChild(this.getElement(), this.focusable);
        this.sinkEvents(901);
        DOM.sinkEvents(this.focusable, 6144);
        this.root = new TreeItem(true);
        this.root.setTree(this);
        this.setStyleName("gwt-Tree");
        Roles.getTreeRole().set(this.focusable);
    }

    private void keyboardNavigation(Event event) {
        if (this.isKeyboardNavigationEnabled(this.curSelection)) {
            int code = event.getKeyCode();
            switch (KeyCodes.maybeSwapArrowKeysForRtl(code, LocaleInfo.getCurrentLocale().isRTL())) {
                case 38: {
                    this.moveSelectionUp(this.curSelection);
                    break;
                }
                case 40: {
                    this.moveSelectionDown(this.curSelection, true);
                    break;
                }
                case 37: {
                    this.maybeCollapseTreeItem();
                    break;
                }
                case 39: {
                    this.maybeExpandTreeItem();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void maybeCollapseTreeItem() {
        TreeItem topClosedParent = this.getTopClosedParent(this.curSelection);
        if (topClosedParent != null) {
            this.setSelectedItem(topClosedParent);
        } else if (this.curSelection.getState()) {
            this.curSelection.setState(false);
        } else {
            TreeItem parent = this.curSelection.getParentItem();
            if (parent != null) {
                this.setSelectedItem(parent);
            }
        }
    }

    private void maybeExpandTreeItem() {
        TreeItem topClosedParent = this.getTopClosedParent(this.curSelection);
        if (topClosedParent != null) {
            this.setSelectedItem(topClosedParent);
        } else if (!this.curSelection.getState()) {
            this.curSelection.setState(true);
        } else if (this.curSelection.getChildCount() > 0) {
            this.setSelectedItem(this.curSelection.getChild(0));
        }
    }

    private void moveFocus() {
        Focusable focusableWidget = this.curSelection.getFocusable();
        if (focusableWidget != null) {
            focusableWidget.setFocus(true);
            if (this.scrollOnSelectEnabled) {
                ((Widget)((Object)focusableWidget)).getElement().scrollIntoView();
            }
        } else {
            if (this.scrollOnSelectEnabled) {
                com.google.gwt.dom.client.Element selectedElem = this.curSelection.getContentElem();
                int containerLeft = this.getAbsoluteLeft();
                int containerTop = this.getAbsoluteTop();
                int left = selectedElem.getAbsoluteLeft() - containerLeft;
                int top = selectedElem.getAbsoluteTop() - containerTop;
                int width = selectedElem.getPropertyInt("offsetWidth");
                int height = selectedElem.getPropertyInt("offsetHeight");
                if (width == 0 || height == 0) {
                    DOM.setIntStyleAttribute(this.focusable, "left", 0);
                    DOM.setIntStyleAttribute(this.focusable, "top", 0);
                    return;
                }
                this.focusable.getStyle().setProperty("left", left + "px");
                this.focusable.getStyle().setProperty("top", top + "px");
                this.focusable.getStyle().setProperty("width", width + "px");
                this.focusable.getStyle().setProperty("height", height + "px");
                this.focusable.scrollIntoView();
            }
            this.updateAriaAttributes();
            this.setFocus(true);
        }
    }

    private void moveSelectionDown(TreeItem sel, boolean dig) {
        if (sel == this.root) {
            return;
        }
        TreeItem topClosedParent = this.getTopClosedParent(sel);
        if (topClosedParent != null) {
            this.moveSelectionDown(topClosedParent, false);
            return;
        }
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        int idx = parent.getChildIndex(sel);
        if (!dig || !sel.getState()) {
            if (idx < parent.getChildCount() - 1) {
                this.onSelection(parent.getChild(idx + 1), true, true);
            } else {
                this.moveSelectionDown(parent, false);
            }
        } else if (sel.getChildCount() > 0) {
            this.onSelection(sel.getChild(0), true, true);
        }
    }

    private void moveSelectionUp(TreeItem sel) {
        int idx;
        TreeItem topClosedParent = this.getTopClosedParent(sel);
        if (topClosedParent != null) {
            this.onSelection(topClosedParent, true, true);
            return;
        }
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        if ((idx = parent.getChildIndex(sel)) > 0) {
            TreeItem sibling = parent.getChild(idx - 1);
            this.onSelection(this.findDeepestOpenChild(sibling), true, true);
        } else {
            this.onSelection(parent, true, true);
        }
    }

    private void onSelection(TreeItem item, boolean fireEvents, boolean moveFocus) {
        if (item == this.root) {
            return;
        }
        if (this.curSelection != null) {
            this.curSelection.setSelected(false);
        }
        this.curSelection = item;
        if (this.curSelection != null) {
            if (moveFocus) {
                this.moveFocus();
            }
            this.curSelection.setSelected(true);
            if (fireEvents) {
                SelectionEvent.fire(this, this.curSelection);
            }
        }
    }

    private void setImages(ImageAdapter images, boolean useLeafImages) {
        this.images = images;
        this.useLeafImages = useLeafImages;
        if (!useLeafImages) {
            Image image = images.treeLeaf().createImage();
            image.getElement().getStyle().setProperty("visibility", "hidden");
            RootPanel.get().add(image);
            int size = image.getWidth() + 7;
            image.removeFromParent();
            this.indentValue = size + "px";
        }
    }

    private void showImage(TreeItem treeItem, AbstractImagePrototype proto) {
        com.google.gwt.dom.client.Element holder = treeItem.getImageHolderElement();
        Element child = DOM.getFirstChild(holder);
        if (child == null) {
            DOM.appendChild(holder, (com.google.gwt.dom.client.Element)proto.createElement().cast());
        } else {
            proto.applyTo((AbstractImagePrototype.ImagePrototypeElement)child.cast());
        }
    }

    private void updateAriaAttributes() {
        com.google.gwt.dom.client.Element curSelectionContentElem = this.curSelection.getContentElem();
        int curSelectionLevel = -1;
        TreeItem tempItem = this.curSelection;
        while (tempItem != null) {
            tempItem = tempItem.getParentItem();
            ++curSelectionLevel;
        }
        Roles.getTreeitemRole().setAriaLevelProperty(curSelectionContentElem, curSelectionLevel + 1);
        TreeItem curSelectionParent = this.curSelection.getParentItem();
        if (curSelectionParent == null) {
            curSelectionParent = this.root;
        }
        Roles.getTreeitemRole().setAriaSetsizeProperty(curSelectionContentElem, curSelectionParent.getChildCount());
        int curSelectionIndex = curSelectionParent.getChildIndex(this.curSelection);
        Roles.getTreeitemRole().setAriaPosinsetProperty(curSelectionContentElem, curSelectionIndex + 1);
        if (this.curSelection.getChildCount() == 0) {
            Roles.getTreeitemRole().removeAriaExpandedState(curSelectionContentElem);
        } else {
            Roles.getTreeitemRole().setAriaExpandedState(curSelectionContentElem, ExpandedValue.of(this.curSelection.getState()));
        }
        Roles.getTreeitemRole().setAriaSelectedState(curSelectionContentElem, SelectedValue.of(true));
        Roles.getTreeRole().setAriaActivedescendantProperty(this.focusable, Id.of(curSelectionContentElem));
    }

    static class ImageAdapter {
        private static final Resources DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        private final AbstractImagePrototype treeClosed;
        private final AbstractImagePrototype treeLeaf;
        private final AbstractImagePrototype treeOpen;

        public ImageAdapter() {
            this(DEFAULT_RESOURCES);
        }

        public ImageAdapter(Resources resources) {
            this.treeClosed = AbstractImagePrototype.create(resources.treeClosed());
            this.treeLeaf = AbstractImagePrototype.create(resources.treeLeaf());
            this.treeOpen = AbstractImagePrototype.create(resources.treeOpen());
        }

        public ImageAdapter(TreeImages images) {
            this.treeClosed = images.treeClosed();
            this.treeLeaf = images.treeLeaf();
            this.treeOpen = images.treeOpen();
        }

        public AbstractImagePrototype treeClosed() {
            return this.treeClosed;
        }

        public AbstractImagePrototype treeLeaf() {
            return this.treeLeaf;
        }

        public AbstractImagePrototype treeOpen() {
            return this.treeOpen;
        }
    }

    public static interface Resources
    extends ClientBundle {
        public ImageResource treeClosed();

        public ImageResource treeLeaf();

        public ImageResource treeOpen();
    }
}

