/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class PrefixTree
extends AbstractCollection<String> {
    protected final int prefixLength;
    protected JavaScriptObject suffixes;
    protected JavaScriptObject subtrees;
    protected int size = 0;

    protected static PrefixTree createPrefixTree(int prefixLength) {
        return new PrefixTree(prefixLength);
    }

    private static String safe(String s) {
        return ':' + s;
    }

    private static String unsafe(String s) {
        return s.substring(1);
    }

    public PrefixTree() {
        this(2, null);
    }

    public PrefixTree(Collection<String> source) {
        this(2, source);
    }

    public PrefixTree(int prefixLength) {
        this(prefixLength, null);
    }

    public PrefixTree(int prefixLength, Collection<String> source) {
        this.prefixLength = prefixLength;
        this.clear();
        if (source != null) {
            this.addAll(source);
        }
    }

    @Override
    public boolean add(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Cannot call native method");
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.contains((String)o);
        }
        return false;
    }

    public boolean contains(String s) {
        return this.getSuggestions(s, 1).contains(s);
    }

    public List<String> getSuggestions(String search, int limit) {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (search != null && limit > 0) {
            this.suggestImpl(search, "", toReturn, limit);
        }
        return toReturn;
    }

    @Override
    public Iterator<String> iterator() {
        return new PrefixTreeIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void suggestImpl(String string, String string2, Collection<String> collection, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private void dump(Collection<String> output, String prefix) {
        for (String s : this) {
            output.add(prefix + s);
        }
    }

    private static class PrefixTreeIterator
    implements Iterator<String> {
        private JavaScriptObject stack;

        public PrefixTreeIterator(PrefixTree tree) {
            this.init();
            this.addTree(tree, "");
        }

        @Override
        public boolean hasNext() {
            return this.nextImpl(true) != null;
        }

        @Override
        public String next() {
            String toReturn = this.nextImpl(false);
            if (toReturn == null) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements in the iterator");
                }
                throw new RuntimeException("nextImpl() returned null, but hasNext says otherwise");
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("PrefixTree does not support removal.  Use clear()");
        }

        private void addTree(PrefixTree prefixTree, String string) {
            throw new RuntimeException("Cannot call native method");
        }

        private void init() {
            throw new RuntimeException("Cannot call native method");
        }

        private String nextImpl(boolean bl) {
            throw new RuntimeException("Cannot call native method");
        }
    }
}

