/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.DoNotRunWith;
import com.google.gwt.junit.Platform;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.rpc.TestSetValidator;
import com.google.gwt.user.client.rpc.UnicodeEscapingService;
import com.google.gwt.user.client.rpc.UnicodeEscapingServiceAsync;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;

public class UnicodeEscapingTest
extends GWTTestCase {
    private static final int CHARACTER_BLOCK_SIZE = 64;
    private static final int NON_BMP_TEST_INCREMENT = 8256;
    private static final int TEST_FINISH_DELAY_MS = 500000;
    protected int current;

    public static String getStringContainingCharacterRange(int start, int end) {
        StringBuffer buf = new StringBuffer();
        for (int codePoint = start; codePoint < end; ++codePoint) {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                buf.append(Character.toChars(codePoint));
                continue;
            }
            buf.append((char)codePoint);
        }
        return buf.toString();
    }

    public static void verifyStringContainingCharacterRange(int start, int end, String str) throws UnicodeEscapingService.InvalidCharacterException {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        int expectedLen = end - start;
        int strLen = str.codePointCount(0, str.length());
        int i = 0;
        int codePoint = start;
        while (i < strLen) {
            int strCodePoint = str.codePointAt(i);
            if (strCodePoint != codePoint) {
                throw new UnicodeEscapingService.InvalidCharacterException(i, codePoint, strCodePoint);
            }
            ++codePoint;
            i = Character.offsetByCodePoints(str, i, 1);
        }
        if (strLen < expectedLen) {
            throw new UnicodeEscapingService.InvalidCharacterException(strLen, start + strLen, -1);
        }
        if (expectedLen != strLen) {
            throw new RuntimeException("Too many characters returned on block from U+" + Integer.toHexString(start) + " to U+" + Integer.toHexString(end) + ": expected=" + expectedLen + ", actual=" + strLen);
        }
    }

    private static UnicodeEscapingServiceAsync getService() {
        UnicodeEscapingServiceAsync service = (UnicodeEscapingServiceAsync)GWT.create(UnicodeEscapingService.class);
        ServiceDefTarget target = (ServiceDefTarget)((Object)service);
        target.setServiceEntryPoint(GWT.getModuleBaseURL() + "unicodeEscape");
        return service;
    }

    @Override
    public String getModuleName() {
        return "com.google.gwt.user.RPCSuite";
    }

    public void testClientToServerBMPHigh() throws UnicodeEscapingService.InvalidCharacterException {
        this.delayTestFinish(500000);
        this.clientToServerVerifyRange(57344, 65536, 64, 64);
    }

    public void testClientToServerBMPLow() throws UnicodeEscapingService.InvalidCharacterException {
        this.delayTestFinish(500000);
        this.clientToServerVerifyRange(0, 55296, 64, 64);
    }

    public void testClientToServerNonBMP() throws UnicodeEscapingService.InvalidCharacterException {
        this.delayTestFinish(500000);
        this.clientToServerVerifyRange(65536, 0x110000, 64, 8256);
    }

    public void testServerToClientBMP() {
        this.delayTestFinish(500000);
        this.serverToClientVerify(0, 55296, 64, 64);
    }

    @DoNotRunWith(value={Platform.HtmlUnitBug})
    public void disabled_testServerToClientBMPSurrogates() {
        this.delayTestFinish(500000);
        this.serverToClientVerify(55296, 65536, 64, 64);
    }

    public void testServerToClientNonBMP() {
        this.delayTestFinish(500000);
        this.serverToClientVerify(65536, 0x110000, 64, 8256);
    }

    protected void clientToServerVerifyRange(int start, final int end, final int size, final int step) throws UnicodeEscapingService.InvalidCharacterException {
        this.current = start;
        int blockEnd = Math.min(end, this.current + size);
        UnicodeEscapingTest.getService().verifyStringContainingCharacterRange(this.current, blockEnd, UnicodeEscapingTest.getStringContainingCharacterRange(start, blockEnd), new AsyncCallback<Boolean>(){
            List<Throwable> fails = new ArrayList<Throwable>();

            @Override
            public void onFailure(Throwable caught) {
                this.fails.add(caught);
                this.onSuccess(false);
            }

            @Override
            public void onSuccess(Boolean ignored) {
                UnicodeEscapingTest.this.current += step;
                if (UnicodeEscapingTest.this.current < end) {
                    UnicodeEscapingTest.this.delayTestFinish(500000);
                    int blockEnd = Math.min(end, UnicodeEscapingTest.this.current + size);
                    try {
                        UnicodeEscapingTest.getService().verifyStringContainingCharacterRange(UnicodeEscapingTest.this.current, blockEnd, UnicodeEscapingTest.getStringContainingCharacterRange(UnicodeEscapingTest.this.current, blockEnd), this);
                    }
                    catch (UnicodeEscapingService.InvalidCharacterException e) {
                        this.fails.add(e);
                    }
                } else if (!this.fails.isEmpty()) {
                    StringBuilder msg = new StringBuilder();
                    for (Throwable t : this.fails) {
                        msg.append(t.getMessage()).append("\n");
                    }
                    TestSetValidator.rethrowException(new RuntimeException(msg.toString()));
                } else {
                    UnicodeEscapingTest.this.finishTest();
                }
            }
        });
    }

    protected void serverToClientVerify(int start, final int end, final int size, final int step) {
        this.current = start;
        UnicodeEscapingTest.getService().getStringContainingCharacterRange(start, Math.min(end, this.current + size), new AsyncCallback<String>(){
            List<Throwable> fails = new ArrayList<Throwable>();

            @Override
            public void onFailure(Throwable caught) {
                this.fails.add(caught);
                this.nextBatch();
            }

            @Override
            public void onSuccess(String str) {
                try {
                    UnicodeEscapingTest.verifyStringContainingCharacterRange(UnicodeEscapingTest.this.current, Math.min(end, UnicodeEscapingTest.this.current + size), str);
                }
                catch (UnicodeEscapingService.InvalidCharacterException e) {
                    this.fails.add(e);
                }
                this.nextBatch();
            }

            private void nextBatch() {
                UnicodeEscapingTest.this.current += step;
                if (UnicodeEscapingTest.this.current < end) {
                    UnicodeEscapingTest.this.delayTestFinish(500000);
                    UnicodeEscapingTest.getService().getStringContainingCharacterRange(UnicodeEscapingTest.this.current, Math.min(end, UnicodeEscapingTest.this.current + size), this);
                } else if (!this.fails.isEmpty()) {
                    StringBuilder msg = new StringBuilder();
                    for (Throwable t : this.fails) {
                        msg.append(t.getMessage()).append("\n");
                    }
                    TestSetValidator.rethrowException(new RuntimeException(msg.toString()));
                } else {
                    UnicodeEscapingTest.this.finishTest();
                }
            }
        });
    }

    private void echoVerify(final String str) {
        this.delayTestFinish(500000);
        UnicodeEscapingTest.getService().echo(str, new AsyncCallback<String>(){

            @Override
            public void onFailure(Throwable caught) {
                TestSetValidator.rethrowException(caught);
            }

            @Override
            public void onSuccess(String result) {
                Assert.assertEquals(str, result);
                UnicodeEscapingTest.this.finishTest();
            }
        });
    }

    public void testEscapeNull() {
        this.echoVerify("\u00007");
    }

    public void testEscapeHtml() {
        this.echoVerify("<img src=x onerror=alert(1)>");
    }
}

