/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc;

import com.google.gwt.user.client.rpc.RemoteService;

public interface UnicodeEscapingService
extends RemoteService {
    public String echo(String var1);

    public String getStringContainingCharacterRange(int var1, int var2);

    public boolean verifyStringContainingCharacterRange(int var1, int var2, String var3) throws InvalidCharacterException;

    public static class InvalidCharacterException
    extends Exception {
        private int index;
        private int expected;
        private int actual;

        private static String toHex(int val) {
            String hex = Integer.toHexString(val);
            return "00000".substring(hex.length()) + hex;
        }

        protected InvalidCharacterException() {
        }

        public InvalidCharacterException(int index, int expected, int actual) {
            super(index < 0 ? "String length mismatch: expected = " + expected + ", actual = " + actual : "At index " + index + ", expected = U+" + InvalidCharacterException.toHex(expected) + ", actual = U+" + InvalidCharacterException.toHex(actual));
            this.index = index;
            this.expected = expected;
            this.actual = actual;
        }

        public int getActual() {
            return this.actual;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

