/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc;

import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.user.client.rpc.FinalFieldsTestService;
import com.google.gwt.user.client.rpc.TestSetFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.Assert;

public class TestSetValidator {
    public static boolean checkObjectArrayElementAssignment(Object[] array, int index, Object value) {
        try {
            array[index] = value;
        }
        catch (ArrayStoreException e) {
            return false;
        }
        try {
            array[index] = new UnassignableObject();
            return false;
        }
        catch (ArrayStoreException e) {
            return true;
        }
    }

    public static boolean equals(boolean[] expected, boolean[] actual) {
        if (actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] expected, byte[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] expected, char[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] expected, double[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] expected, float[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] expected, int[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Iterator<?> expected, Iterator<?> actual) {
        while (expected.hasNext() && actual.hasNext()) {
            if (expected.next().equals(actual.next())) continue;
            return false;
        }
        return expected.hasNext() == actual.hasNext();
    }

    public static boolean equals(long[] expected, long[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] o1, Object[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.length != o2.length) {
            return false;
        }
        for (int i = 0; i < o1.length; ++i) {
            Object e1 = o1[i];
            Object e2 = o2[i];
            if (e1 == e2) continue;
            if (e1 == null || e2 == null) {
                return false;
            }
            if (e1.equals(e2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] expected, short[] actual) {
        if (actual == null) {
            return false;
        }
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Throwable expected, Throwable actual) {
        String actualMessage;
        if (expected == null != (actual == null)) {
            return false;
        }
        if (actual == null) {
            return false;
        }
        String expectedMessage = expected.getMessage();
        return TestSetValidator.equalsWithNullCheck(expectedMessage, actualMessage = actual.getMessage());
    }

    public static boolean isValid(ArrayList<?> list) {
        if (list == null) {
            return false;
        }
        ArrayList<TestSetFactory.MarkerTypeArrayList> reference = TestSetFactory.createArrayList();
        if (reference.size() != list.size()) {
            return false;
        }
        return reference.equals(list);
    }

    public static boolean isValid(List<TestSetFactory.MarkerTypeEmptyList> list) {
        return list != null && list.size() == 0;
    }

    public static boolean isValid(Map<TestSetFactory.MarkerTypeEmptyKey, TestSetFactory.MarkerTypeEmptyValue> map) {
        return map != null && map.size() == 0;
    }

    public static boolean isValid(Set<TestSetFactory.MarkerTypeEmptySet> set) {
        return set != null && set.size() == 0;
    }

    public static boolean isValidEnumKey(EnumMap<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeEnumMapValue> expected, EnumMap<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeEnumMapValue> map) {
        if (map == null) {
            return false;
        }
        Set<Map.Entry<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeEnumMapValue>> entries = expected.entrySet();
        for (Map.Entry<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeEnumMapValue> entry : entries) {
            TestSetFactory.MarkerTypeEnumMapValue value = map.get((Object)entry.getKey());
            if (value == entry.getValue()) continue;
            if (value == null || entry.getValue() == null) {
                return false;
            }
            if (map.get((Object)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(EnumMap<?, ?> expected, EnumMap<?, ?> map) {
        if (map == null) {
            return false;
        }
        Set<Map.Entry<?, ?>> entries = expected.entrySet();
        for (Map.Entry<?, ?> entry : entries) {
            Object value = map.get(entry.getKey());
            if (value == entry.getValue()) continue;
            if (value == null || entry.getValue() == null) {
                return false;
            }
            if (map.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(HashMap<?, ?> expected, HashMap<?, ?> map) {
        if (map == null) {
            return false;
        }
        if (expected.size() != map.size()) {
            return false;
        }
        Set<Map.Entry<?, ?>> entries = expected.entrySet();
        for (Map.Entry<?, ?> entry : entries) {
            Object value = map.get(entry.getKey());
            if (value == entry.getValue()) continue;
            if (value == null || entry.getValue() == null) {
                return false;
            }
            if (map.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(HashSet<?> expected, HashSet<?> actual) {
        if (actual == null) {
            return false;
        }
        if (expected.size() != actual.size()) {
            return false;
        }
        for (Object entry : expected) {
            if (actual.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidEnumKey(IdentityHashMap<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeIdentityHashMapValue> expected, IdentityHashMap<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeIdentityHashMapValue> map) {
        if (map == null) {
            return false;
        }
        if (expected.size() != map.size()) {
            return false;
        }
        Set<Map.Entry<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeIdentityHashMapValue>> entries = expected.entrySet();
        for (Map.Entry<TestSetFactory.MarkerTypeEnum, TestSetFactory.MarkerTypeIdentityHashMapValue> entry : entries) {
            TestSetFactory.MarkerTypeIdentityHashMapValue value = map.get((Object)entry.getKey());
            if (value == entry.getValue()) continue;
            if (value == null || entry.getValue() == null) {
                return false;
            }
            if (map.get((Object)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(IdentityHashMap<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue> expected, IdentityHashMap<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue> map) {
        if (map == null) {
            return false;
        }
        if (expected.size() != map.size()) {
            return false;
        }
        Set<Map.Entry<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue>> mapEntries = map.entrySet();
        Set<Map.Entry<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue>> expectedEntries = expected.entrySet();
        for (Map.Entry<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue> expectedEntry : expectedEntries) {
            Iterator<Map.Entry<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue>> mapIter = mapEntries.iterator();
            boolean found = false;
            while (!found && mapIter.hasNext()) {
                Map.Entry<TestSetFactory.MarkerTypeIdentityHashMapKey, TestSetFactory.MarkerTypeIdentityHashMapValue> mapEntry = mapIter.next();
                if (!mapEntry.getKey().equals(expectedEntry.getKey()) || !mapEntry.getValue().equals(expectedEntry.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(LinkedHashMap<?, ?> expected, LinkedHashMap<?, ?> map) {
        if (TestSetValidator.isValid(expected, map)) {
            Iterator<Map.Entry<?, ?>> expectedEntries = expected.entrySet().iterator();
            Iterator<Map.Entry<?, ?>> actualEntries = map.entrySet().iterator();
            return TestSetValidator.equals(expectedEntries, actualEntries);
        }
        return false;
    }

    public static boolean isValid(LinkedHashSet<?> expected, LinkedHashSet<?> map) {
        if (TestSetValidator.isValid(expected, map)) {
            Iterator expectedEntries = expected.iterator();
            Iterator actualEntries = map.iterator();
            return TestSetValidator.equals(expectedEntries, actualEntries);
        }
        return false;
    }

    public static boolean isValid(LinkedList<?> expected, LinkedList<?> actual) {
        if (actual == null) {
            return false;
        }
        Iterator expectedEntries = expected.iterator();
        Iterator actualEntries = actual.iterator();
        return TestSetValidator.equals(expectedEntries, actualEntries);
    }

    public static boolean isValid(TestSetFactory.SerializablePrivateNoArg actual) {
        if (actual == null) {
            return false;
        }
        return actual.getValue() == 1;
    }

    public static boolean isValid(TestSetFactory.SerializableWithTwoArrays node) {
        return node.one == node.two;
    }

    public static boolean isValid(TreeMap<String, TestSetFactory.MarkerTypeTreeMap> expected, TreeMap<String, TestSetFactory.MarkerTypeTreeMap> map) {
        if (map == null) {
            return false;
        }
        if (!TestSetValidator.equalsWithNullCheck(map.comparator(), expected.comparator())) {
            return false;
        }
        int size = 0;
        size = expected.size();
        if (size != map.size()) {
            return false;
        }
        ArrayList<Map.Entry<String, TestSetFactory.MarkerTypeTreeMap>> actualList = new ArrayList<Map.Entry<String, TestSetFactory.MarkerTypeTreeMap>>(map.entrySet());
        ArrayList<Map.Entry<String, TestSetFactory.MarkerTypeTreeMap>> expectedList = new ArrayList<Map.Entry<String, TestSetFactory.MarkerTypeTreeMap>>(expected.entrySet());
        for (int index = 0; index < size; ++index) {
            Map.Entry expectedEntry = (Map.Entry)expectedList.get(index);
            Map.Entry actualEntry = (Map.Entry)actualList.get(index);
            if (TestSetValidator.equalsWithNullCheck(expectedEntry.getKey(), actualEntry.getKey()) && TestSetValidator.equalsWithNullCheck(expectedEntry.getValue(), actualEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(TreeSet<TestSetFactory.MarkerTypeTreeSet> expected, TreeSet<TestSetFactory.MarkerTypeTreeSet> set) {
        if (set == null) {
            return false;
        }
        if (!TestSetValidator.equalsWithNullCheck(set.comparator(), expected.comparator())) {
            return false;
        }
        int size = 0;
        size = expected.size();
        if (size != set.size()) {
            return false;
        }
        ArrayList<TestSetFactory.MarkerTypeTreeSet> actualList = new ArrayList<TestSetFactory.MarkerTypeTreeSet>(set);
        ArrayList<TestSetFactory.MarkerTypeTreeSet> expectedList = new ArrayList<TestSetFactory.MarkerTypeTreeSet>(expected);
        for (int index = 0; index < size; ++index) {
            if (TestSetValidator.equalsWithNullCheck(expectedList.get(index), actualList.get(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(UmbrellaException expected, UmbrellaException actual) {
        if (actual == null) {
            return false;
        }
        if (!TestSetValidator.equals(expected, actual)) {
            return false;
        }
        Set<Throwable> expectedCauses = expected.getCauses();
        Set<Throwable> actualCauses = actual.getCauses();
        if (actualCauses.size() != expectedCauses.size()) {
            return false;
        }
        for (Throwable expectedCause : expectedCauses) {
            if (expectedCause != null) continue;
            return false;
        }
        for (Throwable actualCause : actualCauses) {
            if (actualCause != null) continue;
            return false;
        }
        for (Throwable expectedCause : expectedCauses) {
            Iterator<Throwable> actualIter = actualCauses.iterator();
            boolean found = false;
            while (!found && actualIter.hasNext()) {
                Throwable actualCause = actualIter.next();
                if (!TestSetValidator.equals(expectedCause, actualCause)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Vector<?> expected, Vector<?> actual) {
        if (actual == null) {
            return false;
        }
        return expected.equals(actual);
    }

    public static boolean isValidAcyclicGraph(TestSetFactory.SerializableDoublyLinkedNode actual) {
        if (actual == null) {
            return false;
        }
        if (!actual.getData().equals("head")) {
            return false;
        }
        TestSetFactory.SerializableDoublyLinkedNode leftChild = actual.getLeftChild();
        if (leftChild == null) {
            return false;
        }
        if (!leftChild.getData().equals("lchild")) {
            return false;
        }
        if (leftChild.getLeftChild() != null || leftChild.getRightChild() != null) {
            return false;
        }
        TestSetFactory.SerializableDoublyLinkedNode rightChild = actual.getRightChild();
        if (rightChild == null) {
            return false;
        }
        if (!rightChild.getData().equals("rchild")) {
            return false;
        }
        return rightChild.getLeftChild() == null && rightChild.getRightChild() == null;
    }

    public static boolean isValidArrayListVoid(ArrayList<Void> list) {
        if (list.size() != 2) {
            return false;
        }
        return list.get(0) == null && list.get(1) == null;
    }

    public static boolean isValidAsList(List<?> list) {
        if (list == null) {
            return false;
        }
        List<TestSetFactory.MarkerTypeArraysAsList> reference = TestSetFactory.createArraysAsList();
        if (reference.size() != list.size()) {
            return false;
        }
        return reference.equals(list);
    }

    public static boolean isValidComplexCyclicGraph(TestSetFactory.SerializableDoublyLinkedNode actual) {
        int i;
        Assert.assertNotNull(actual);
        if (actual == null) {
            return false;
        }
        TestSetFactory.SerializableDoublyLinkedNode currNode = actual;
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals("n" + Integer.toString(i), currNode.getData());
            if (!currNode.getData().equals("n" + Integer.toString(i))) {
                return false;
            }
            TestSetFactory.SerializableDoublyLinkedNode nextNode = currNode.getRightChild();
            TestSetFactory.SerializableDoublyLinkedNode prevNode = currNode.getLeftChild();
            Assert.assertNotNull("next node", nextNode);
            Assert.assertNotNull("prev node", prevNode);
            if (nextNode == null || prevNode == null) {
                return false;
            }
            Assert.assertSame("A", currNode, nextNode.getLeftChild());
            if (nextNode.getLeftChild() != currNode) {
                return false;
            }
            Assert.assertSame("B", currNode, prevNode.getRightChild());
            if (prevNode.getRightChild() != currNode) {
                return false;
            }
            if ((currNode = currNode.getRightChild()) == actual) break;
        }
        Assert.assertFalse("i = " + i, i >= 4);
        return i < 4;
    }

    public static boolean isValidComplexCyclicGraphWithCFS(TestSetFactory.SerializableGraphWithCFS result) {
        Assert.assertNotNull(result);
        ArrayList<TestSetFactory.SerializableGraphWithCFS> array = result.getArray();
        Assert.assertNotNull(array);
        Assert.assertEquals(1, array.size());
        TestSetFactory.SerializableGraphWithCFS child = (TestSetFactory.SerializableGraphWithCFS)array.get(0);
        Assert.assertFalse(result == child);
        Assert.assertSame(result, child.getParent());
        return true;
    }

    public static boolean isValidSingletonList(List<TestSetFactory.MarkerTypeSingleton> list) {
        if (list == null || list.size() != 1) {
            return false;
        }
        TestSetFactory.MarkerTypeSingleton value = list.get(0);
        if (!(value instanceof TestSetFactory.MarkerTypeSingleton)) {
            return false;
        }
        TestSetFactory.MarkerTypeSingleton singleton = value;
        return "singleton".equals(singleton.getValue());
    }

    public static boolean isValidTrivialCyclicGraph(TestSetFactory.SerializableDoublyLinkedNode actual) {
        if (actual == null) {
            return false;
        }
        if (!actual.getData().equals("head")) {
            return false;
        }
        TestSetFactory.SerializableDoublyLinkedNode lchild = actual.getLeftChild();
        if (lchild == null) {
            return false;
        }
        TestSetFactory.SerializableDoublyLinkedNode rchild = actual.getRightChild();
        if (rchild == null) {
            return false;
        }
        return actual == lchild || actual == rchild;
    }

    public static void rethrowException(Throwable caught) {
        if (caught instanceof RuntimeException) {
            throw (RuntimeException)caught;
        }
        throw new RuntimeException(caught);
    }

    private static boolean equalsWithNullCheck(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isValidFinalFieldsObjectDefault(FinalFieldsTestService.FinalFieldsNode result) {
        return result != null && result.i == 5 && result.str.equals("A") && result.f.length == 3;
    }

    public static boolean isValidFinalFieldsObjectFromClient(FinalFieldsTestService.FinalFieldsNode result) {
        return result != null && result.i == 4 && result.str.equals("C") && result.f.length == 9;
    }

    public static boolean isValidFinalFieldsObjectFromServer(FinalFieldsTestService.FinalFieldsNode result) {
        return result != null && result.i == 6 && result.str.equals("B") && result.f.length == 10;
    }

    private static class UnassignableObject {
        private UnassignableObject() {
        }
    }
}

