/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.user.client.BaseListenerWrapper;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.WindowScrollListener;
import com.google.gwt.user.client.impl.WindowImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Window {
    static WindowHandlers handlers;
    private static boolean closeHandlersInitialized;
    private static boolean beforeCloseHandlersInitialized;
    private static boolean scrollHandlersInitialized;
    private static boolean resizeHandlersInitialized;
    private static int lastResizeWidth;
    private static int lastResizeHeight;
    private static final WindowImpl impl;

    @Deprecated
    public static HandlerRegistration addCloseHandler(CloseHandler<Window> handler) {
        Window.maybeInitializeCloseHandlers();
        return Window.addHandler(CloseEvent.getType(), handler);
    }

    public static HandlerRegistration addResizeHandler(ResizeHandler handler) {
        Window.maybeInitializeResizeHandlers();
        return Window.addHandler(ResizeEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowCloseListener(WindowCloseListener listener) {
        BaseListenerWrapper.WrapWindowClose.add(listener);
    }

    public static HandlerRegistration addWindowClosingHandler(ClosingHandler handler) {
        Window.maybeInitializeBeforeCloseHandlers();
        return Window.addHandler(ClosingEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowResizeListener(WindowResizeListener listener) {
        BaseListenerWrapper.WrapWindowResize.add(listener);
    }

    public static HandlerRegistration addWindowScrollHandler(ScrollHandler handler) {
        Window.maybeInitializeScrollHandlers();
        return Window.addHandler(ScrollEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowScrollListener(WindowScrollListener listener) {
        BaseListenerWrapper.WrapWindowScroll.add(listener);
    }

    public static void alert(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public static boolean confirm(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void enableScrolling(boolean enable) {
        Document.get().enableScrolling(enable);
    }

    public static int getClientHeight() {
        return Document.get().getClientHeight();
    }

    public static int getClientWidth() {
        return Document.get().getClientWidth();
    }

    public static int getScrollLeft() {
        return Document.get().getScrollLeft();
    }

    public static int getScrollTop() {
        return Document.get().getScrollTop();
    }

    public static String getTitle() {
        throw new RuntimeException("Cannot call native method");
    }

    public static void moveBy(int n, int n2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void moveTo(int n, int n2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void open(String string, String string2, String string3) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void print() {
        throw new RuntimeException("Cannot call native method");
    }

    public static String prompt(String string, String string2) {
        throw new RuntimeException("Cannot call native method");
    }

    @Deprecated
    public static void removeWindowCloseListener(WindowCloseListener listener) {
        BaseListenerWrapper.WrapWindowClose.remove(handlers, listener);
    }

    @Deprecated
    public static void removeWindowResizeListener(WindowResizeListener listener) {
        BaseListenerWrapper.WrapWindowResize.remove(handlers, listener);
    }

    @Deprecated
    public static void removeWindowScrollListener(WindowScrollListener listener) {
        BaseListenerWrapper.WrapWindowScroll.remove(handlers, listener);
    }

    public static void resizeBy(int n, int n2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void resizeTo(int n, int n2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void scrollTo(int n, int n2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void setMargin(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void setStatus(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void setTitle(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    static void onClosed() {
        if (closeHandlersInitialized) {
            CloseEvent.fire(Window.getHandlers(), null);
        }
    }

    static String onClosing() {
        if (beforeCloseHandlersInitialized) {
            ClosingEvent event = new ClosingEvent();
            Window.fireEvent(event);
            return event.getMessage();
        }
        return null;
    }

    static void onResize() {
        if (resizeHandlersInitialized) {
            int width = Window.getClientWidth();
            int height = Window.getClientHeight();
            if (lastResizeWidth != width || lastResizeHeight != height) {
                lastResizeWidth = width;
                lastResizeHeight = height;
                ResizeEvent.fire(Window.getHandlers(), width, height);
            }
        }
    }

    static void onScroll() {
        if (scrollHandlersInitialized) {
            Window.fireEvent(new ScrollEvent(Window.getScrollLeft(), Window.getScrollTop()));
        }
    }

    private static <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        return Window.getHandlers().addHandler(type, handler);
    }

    private static void fireEvent(GwtEvent<?> event) {
        if (handlers != null) {
            handlers.fireEvent(event);
        }
    }

    private static WindowHandlers getHandlers() {
        if (handlers == null) {
            handlers = new WindowHandlers();
        }
        return handlers;
    }

    @Deprecated
    private static void maybeInitializeCloseHandlers() {
        if (GWT.isClient() && !closeHandlersInitialized) {
            impl.initWindowUnloadHandler();
            closeHandlersInitialized = true;
        }
    }

    private static void maybeInitializeBeforeCloseHandlers() {
        if (GWT.isClient() && !beforeCloseHandlersInitialized) {
            impl.initWindowBeforeUnloadHandler();
            beforeCloseHandlersInitialized = true;
        }
    }

    private static void maybeInitializeResizeHandlers() {
        if (GWT.isClient() && !resizeHandlersInitialized) {
            impl.initWindowResizeHandler();
            resizeHandlersInitialized = true;
        }
    }

    private static void maybeInitializeScrollHandlers() {
        if (GWT.isClient() && !scrollHandlersInitialized) {
            impl.initWindowScrollHandler();
            scrollHandlersInitialized = true;
        }
    }

    private Window() {
    }

    static {
        impl = (WindowImpl)GWT.create(WindowImpl.class);
    }

    private static class WindowHandlers
    extends HandlerManager
    implements HasCloseHandlers<Window>,
    HasResizeHandlers {
        public WindowHandlers() {
            super(null);
        }

        @Override
        public HandlerRegistration addCloseHandler(CloseHandler<Window> handler) {
            return this.addHandler(CloseEvent.getType(), handler);
        }

        @Override
        public HandlerRegistration addResizeHandler(ResizeHandler handler) {
            return this.addHandler(ResizeEvent.getType(), handler);
        }

        public HandlerManager getHandlers() {
            return this;
        }
    }

    public static interface ScrollHandler
    extends EventHandler {
        public void onWindowScroll(ScrollEvent var1);
    }

    public static class ScrollEvent
    extends GwtEvent<ScrollHandler> {
        static final GwtEvent.Type<ScrollHandler> TYPE = new GwtEvent.Type();
        private int scrollLeft;
        private int scrollTop;

        static GwtEvent.Type<ScrollHandler> getType() {
            return TYPE;
        }

        private ScrollEvent(int scrollLeft, int scrollTop) {
            this.scrollLeft = scrollLeft;
            this.scrollTop = scrollTop;
        }

        @Override
        public final GwtEvent.Type<ScrollHandler> getAssociatedType() {
            return TYPE;
        }

        public int getScrollLeft() {
            return this.scrollLeft;
        }

        public int getScrollTop() {
            return this.scrollTop;
        }

        @Override
        protected void dispatch(ScrollHandler handler) {
            handler.onWindowScroll(this);
        }
    }

    public static class Navigator {
        public static String getAppCodeName() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getAppName() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getAppVersion() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getPlatform() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getUserAgent() {
            throw new RuntimeException("Cannot call native method");
        }

        public static boolean isCookieEnabled() {
            return Cookies.isCookieEnabled();
        }

        public static boolean isJavaEnabled() {
            throw new RuntimeException("Cannot call native method");
        }

        private Navigator() {
        }
    }

    public static class Location {
        private static String cachedQueryString = "";
        private static Map<String, List<String>> listParamMap;

        public static void assign(String string) {
            throw new RuntimeException("Cannot call native method");
        }

        public static UrlBuilder createUrlBuilder() {
            String port;
            String hash;
            UrlBuilder builder = new UrlBuilder();
            builder.setProtocol(Location.getProtocol());
            builder.setHost(Location.getHost());
            String path = Location.getPath();
            if (path != null && path.length() > 0) {
                builder.setPath(path);
            }
            if ((hash = Location.getHash()) != null && hash.length() > 0) {
                builder.setHash(URL.decodeQueryString(hash));
            }
            if ((port = Location.getPort()) != null && port.length() > 0) {
                builder.setPort(Integer.parseInt(port));
            }
            Map<String, List<String>> params = Location.getParameterMap();
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                ArrayList values = new ArrayList(entry.getValue());
                builder.setParameter(entry.getKey(), values.toArray(new String[values.size()]));
            }
            return builder;
        }

        public static String getHash() {
            return impl.getHash();
        }

        public static String getHost() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getHostName() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getHref() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getParameter(String name) {
            Location.ensureListParameterMap();
            List<String> paramsForName = listParamMap.get(name);
            if (paramsForName == null) {
                return null;
            }
            return paramsForName.get(paramsForName.size() - 1);
        }

        public static Map<String, List<String>> getParameterMap() {
            Location.ensureListParameterMap();
            return listParamMap;
        }

        public static String getPath() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getPort() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getProtocol() {
            throw new RuntimeException("Cannot call native method");
        }

        public static String getQueryString() {
            return impl.getQueryString();
        }

        public static void reload() {
            throw new RuntimeException("Cannot call native method");
        }

        public static void replace(String string) {
            throw new RuntimeException("Cannot call native method");
        }

        static Map<String, List<String>> buildListParamMap(String queryString) {
            HashMap<String, List<String>> out = new HashMap();
            if (queryString != null && queryString.length() > 1) {
                String qs = queryString.substring(1);
                for (String kvPair : qs.split("&")) {
                    String[] kv = kvPair.split("=", 2);
                    String key = kv[0];
                    if (key.isEmpty()) continue;
                    String val = kv.length > 1 ? kv[1] : "";
                    try {
                        val = URL.decodeQueryString(val);
                    }
                    catch (JavaScriptException e) {
                        GWT.log("Cannot decode a URL query string parameter=" + key + " value=" + val, e);
                    }
                    ArrayList<String> values = (ArrayList<String>)out.get(key);
                    if (values == null) {
                        values = new ArrayList<String>();
                        out.put(key, values);
                    }
                    values.add(val);
                }
            }
            for (Map.Entry entry : out.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            out = Collections.unmodifiableMap(out);
            return out;
        }

        private static void ensureListParameterMap() {
            String currentQueryString = Location.getQueryString();
            if (listParamMap == null || !cachedQueryString.equals(currentQueryString)) {
                listParamMap = Location.buildListParamMap(currentQueryString);
                cachedQueryString = currentQueryString;
            }
        }

        private Location() {
        }
    }

    public static interface ClosingHandler
    extends EventHandler {
        public void onWindowClosing(ClosingEvent var1);
    }

    public static class ClosingEvent
    extends GwtEvent<ClosingHandler> {
        private static final GwtEvent.Type<ClosingHandler> TYPE = new GwtEvent.Type();
        private String message = null;

        static GwtEvent.Type<ClosingHandler> getType() {
            return TYPE;
        }

        @Override
        public final GwtEvent.Type<ClosingHandler> getAssociatedType() {
            return TYPE;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        protected void dispatch(ClosingHandler handler) {
            handler.onWindowClosing(this);
        }
    }
}

