/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.JavaScriptObject;

public abstract class Timer {
    private boolean isRepeating;
    private Integer timerId = null;
    private int cancelCounter = 0;

    public final boolean isRunning() {
        return this.timerId != null;
    }

    public void cancel() {
        if (!this.isRunning()) {
            return;
        }
        ++this.cancelCounter;
        if (this.isRepeating) {
            Timer.clearInterval(this.timerId);
        } else {
            Timer.clearTimeout(this.timerId);
        }
        this.timerId = null;
    }

    public abstract void run();

    public void schedule(int delayMillis) {
        if (delayMillis < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (this.isRunning()) {
            this.cancel();
        }
        this.isRepeating = false;
        this.timerId = Timer.setTimeout(Timer.createCallback(this, this.cancelCounter), delayMillis);
    }

    public void scheduleRepeating(int periodMillis) {
        if (periodMillis <= 0) {
            throw new IllegalArgumentException("must be positive");
        }
        if (this.isRunning()) {
            this.cancel();
        }
        this.isRepeating = true;
        this.timerId = Timer.setInterval(Timer.createCallback(this, this.cancelCounter), periodMillis);
    }

    final void fire(int scheduleCancelCounter) {
        if (scheduleCancelCounter != this.cancelCounter) {
            return;
        }
        if (!this.isRepeating) {
            this.timerId = null;
        }
        this.run();
    }

    private static JavaScriptObject createCallback(Timer timer, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static int setInterval(JavaScriptObject javaScriptObject, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static int setTimeout(JavaScriptObject javaScriptObject, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void clearInterval(int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void clearTimeout(int n) {
        throw new RuntimeException("Cannot call native method");
    }
}

