/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class Cookies {
    static HashMap<String, String> cachedCookies = null;
    static String rawCookies;
    private static boolean isCookieEnabled;
    private static boolean isCookieChecked;
    private static boolean uriEncoding;

    public static String getCookie(String name) {
        HashMap<String, String> cookiesMap = Cookies.ensureCookies();
        return (String)cookiesMap.get(name);
    }

    public static Collection<String> getCookieNames() {
        return Cookies.ensureCookies().keySet();
    }

    public static boolean getUriEncode() {
        return uriEncoding;
    }

    public static boolean isCookieEnabled() {
        if (!isCookieChecked) {
            isCookieChecked = true;
            Cookies.setCookie("__gwtCookieCheck", "isEnabled");
            isCookieEnabled = "isEnabled".equals(Cookies.getCookie("__gwtCookieCheck"));
            Cookies.removeCookie("__gwtCookieCheck");
        }
        return isCookieEnabled;
    }

    public static void removeCookie(String name) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
        }
        Cookies.removeCookieNative(name);
    }

    public static void removeCookie(String name, String path) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
        }
        Cookies.removeCookieNative(name, path);
    }

    public static void removeCookieNative(String string, String string2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static void setCookie(String name, String value) {
        Cookies.setCookie(name, value, null, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires) {
        Cookies.setCookie(name, value, expires, null, null, false);
    }

    public static void setCookie(String name, String value, Date expires, String domain, String path, boolean secure) {
        if (uriEncoding) {
            name = Cookies.uriEncode(name);
            value = Cookies.uriEncode(value);
        } else {
            if (!Cookies.isValidCookieName(name)) {
                throw new IllegalArgumentException("Illegal cookie format: " + name + " is not a valid cookie name.");
            }
            if (!Cookies.isValidCookieValue(value)) {
                throw new IllegalArgumentException("Illegal cookie format: " + value + " is not a valid cookie value.");
            }
        }
        Cookies.setCookieImpl(name, value, expires == null ? 0.0 : (double)expires.getTime(), domain, path, secure);
    }

    public static void setUriEncode(boolean encode) {
        if (encode != uriEncoding) {
            uriEncoding = encode;
            cachedCookies = null;
        }
    }

    static void loadCookies(HashMap<String, String> hashMap) {
        throw new RuntimeException("Cannot call native method");
    }

    private static HashMap<String, String> ensureCookies() {
        if (cachedCookies == null || Cookies.needsRefresh()) {
            HashMap<String, String> newCachedCookies = new HashMap<String, String>();
            Cookies.loadCookies(newCachedCookies);
            cachedCookies = newCachedCookies;
        }
        return cachedCookies;
    }

    private static boolean isValidCookieName(String name) {
        if (uriEncoding) {
            return true;
        }
        return !name.contains("=") && !name.contains(";") && !name.contains(",") && !name.startsWith("$") && !name.matches(".*\\s+.*");
    }

    private static boolean isValidCookieValue(String value) {
        if (uriEncoding) {
            return true;
        }
        return !value.contains("=") && !value.contains(";");
    }

    private static boolean needsRefresh() {
        throw new RuntimeException("Cannot call native method");
    }

    private static void removeCookieNative(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setCookieImpl(String string, String string2, double d, String string3, String string4, boolean bl) {
        throw new RuntimeException("Cannot call native method");
    }

    private static String uriEncode(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    private Cookies() {
    }

    static {
        isCookieEnabled = false;
        isCookieChecked = false;
        uriEncoding = true;
    }
}

