/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.apache.zip;

import com.google.gwt.thirdparty.apache.zip.UnixStat;
import com.google.gwt.thirdparty.apache.zip.ZipExtraField;
import com.google.gwt.thirdparty.apache.zip.ZipLong;
import com.google.gwt.thirdparty.apache.zip.ZipShort;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

public class AsiExtraField
implements ZipExtraField,
UnixStat,
Cloneable {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private int mode = 0;
    private int uid = 0;
    private int gid = 0;
    private String link = "";
    private boolean dirFlag = false;
    private CRC32 crc = new CRC32();

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] byArray = new byte[this.getLocalFileDataLength().getValue() - 4];
        System.arraycopy(new ZipShort(this.getMode()).getBytes(), 0, byArray, 0, 2);
        byte[] byArray2 = this.getLinkedFile().getBytes();
        System.arraycopy(new ZipLong(byArray2.length).getBytes(), 0, byArray, 2, 4);
        System.arraycopy(new ZipShort(this.getUserId()).getBytes(), 0, byArray, 6, 2);
        System.arraycopy(new ZipShort(this.getGroupId()).getBytes(), 0, byArray, 8, 2);
        System.arraycopy(byArray2, 0, byArray, 10, byArray2.length);
        this.crc.reset();
        this.crc.update(byArray);
        long l = this.crc.getValue();
        byte[] byArray3 = new byte[byArray.length + 4];
        System.arraycopy(new ZipLong(l).getBytes(), 0, byArray3, 0, 4);
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        return byArray3;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void setUserId(int n) {
        this.uid = n;
    }

    public int getUserId() {
        return this.uid;
    }

    public void setGroupId(int n) {
        this.gid = n;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setLinkedFile(String string) {
        this.link = string;
        this.mode = this.getMode(this.mode);
    }

    public String getLinkedFile() {
        return this.link;
    }

    public boolean isLink() {
        return this.getLinkedFile().length() != 0;
    }

    public void setMode(int n) {
        this.mode = this.getMode(n);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDirectory(boolean bl) {
        this.dirFlag = bl;
        this.mode = this.getMode(this.mode);
    }

    public boolean isDirectory() {
        return this.dirFlag && !this.isLink();
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n, int n2) throws ZipException {
        long l = new ZipLong(byArray, n).getValue();
        byte[] byArray2 = new byte[n2 - 4];
        System.arraycopy(byArray, n + 4, byArray2, 0, n2 - 4);
        this.crc.reset();
        this.crc.update(byArray2);
        long l2 = this.crc.getValue();
        if (l != l2) {
            throw new ZipException("bad CRC checksum " + Long.toHexString(l) + " instead of " + Long.toHexString(l2));
        }
        int n3 = new ZipShort(byArray2, 0).getValue();
        byte[] byArray3 = new byte[(int)new ZipLong(byArray2, 2).getValue()];
        this.uid = new ZipShort(byArray2, 6).getValue();
        this.gid = new ZipShort(byArray2, 8).getValue();
        if (byArray3.length == 0) {
            this.link = "";
        } else {
            System.arraycopy(byArray2, 10, byArray3, 0, byArray3.length);
            this.link = new String(byArray3);
        }
        this.setDirectory((n3 & 0x4000) != 0);
        this.setMode(n3);
    }

    protected int getMode(int n) {
        int n2 = 32768;
        if (this.isLink()) {
            n2 = 40960;
        } else if (this.isDirectory()) {
            n2 = 16384;
        }
        return n2 | n & 0xFFF;
    }
}

