/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.apache.ant.util;

import com.google.gwt.thirdparty.apache.ant.BuildException;
import com.google.gwt.thirdparty.apache.ant.taskdefs.condition.Os;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileUtils {
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static boolean onNetWare = Os.isFamily("netware");
    private static boolean onDos = Os.isFamily("dos");
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public File resolveFile(File file, String string) {
        if (FileUtils.isAbsolutePath(string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
            return this.normalize(string);
        }
        if (file == null) {
            return new File(string);
        }
        File file2 = new File(file.getAbsolutePath());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("..")) {
                if ((file2 = file2.getParentFile()) != null) continue;
                String string3 = "The file or path you specified (" + string + ") is invalid relative to " + file.getPath();
                throw new BuildException(string3);
            }
            if (string2.equals(".")) continue;
            file2 = new File(file2, string2);
        }
        return new File(file2.getAbsolutePath());
    }

    public static boolean isAbsolutePath(String string) {
        if (string.startsWith(File.separator)) {
            return true;
        }
        if (onDos && string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return true;
        }
        return onNetWare && string.indexOf(":") > -1;
    }

    public File normalize(String string) {
        int n;
        CharSequence charSequence;
        Object object;
        Object object2;
        String string2 = string;
        string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int n2 = string.indexOf(":");
        if (!FileUtils.isAbsolutePath(string)) {
            String string3 = string + " is not an absolute path";
            throw new BuildException(string3);
        }
        boolean bl = false;
        String string4 = null;
        if (onDos && string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' || onNetWare && n2 > -1) {
            bl = true;
            object2 = string.replace('/', '\\').toCharArray();
            object = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)object).append(Character.toUpperCase((char)object2[i]));
            }
            ((StringBuffer)object).append(':');
            if (n2 + 1 < string.length()) {
                ((StringBuffer)object).append(File.separatorChar);
            }
            string4 = ((StringBuffer)object).toString();
            charSequence = new StringBuffer();
            for (n = n2 + 1; n < ((Object)object2).length; ++n) {
                if (object2[n] == 92 && (object2[n] != 92 || object2[n - 1] == 92)) continue;
                ((StringBuffer)charSequence).append((char)object2[n]);
            }
            string = ((StringBuffer)charSequence).toString().replace('\\', File.separatorChar);
        } else if (string.length() == 1) {
            string4 = File.separator;
            string = "";
        } else if (string.charAt(1) == File.separatorChar) {
            string4 = File.separator + File.separator;
            string = string.substring(2);
        } else {
            string4 = File.separator;
            string = string.substring(1);
        }
        object2 = new Stack();
        ((Stack)object2).push(string4);
        object = new StringTokenizer(string, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            charSequence = ((StringTokenizer)object).nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (((Vector)object2).size() < 2) {
                    throw new BuildException("Cannot resolve path " + string2);
                }
                ((Stack)object2).pop();
                continue;
            }
            ((Stack)object2).push(charSequence);
        }
        charSequence = new StringBuffer();
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            if (n > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(((Vector)object2).elementAt(n));
        }
        string = ((StringBuffer)charSequence).toString();
        if (bl) {
            string = string.replace('/', '\\');
        }
        return new File(string);
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        File file2;
        if (file == null) {
            file2 = new File(string);
            file = file2.getParentFile();
            string = file2.getName();
        }
        return !(file2 = new File(file.getCanonicalPath(), string)).getAbsolutePath().equals(file2.getCanonicalPath());
    }

    public String removeLeadingPath(File file, File file2) {
        String string;
        String string2 = this.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (string2.equals(string = this.normalize(file2.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2) ? string.substring(string2.length()) : string;
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            FileUtils.isSpecial[i] = true;
            FileUtils.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtils.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        for (char c : new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FileUtils.isSpecial[c] = true;
            FileUtils.escapedChar1[c] = Character.forDigit(c >> 4, 16);
            FileUtils.escapedChar2[c] = Character.forDigit(c & 0xF, 16);
        }
    }
}

