/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.apache.ant.types;

import com.google.gwt.thirdparty.apache.ant.BuildException;
import com.google.gwt.thirdparty.apache.ant.DirectoryScanner;
import com.google.gwt.thirdparty.apache.ant.types.Resource;
import com.google.gwt.thirdparty.apache.zip.ZipEntry;
import com.google.gwt.thirdparty.apache.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;

public class ZipScanner
extends DirectoryScanner {
    protected File srcFile;
    private Resource lastScannedResource;
    private Hashtable myentries;
    private String encoding;

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public String[] getIncludedFiles() {
        if (this.srcFile != null) {
            Vector<String> vector = new Vector<String>();
            this.scanme();
            Object[] objectArray = this.myentries.elements();
            while (objectArray.hasMoreElements()) {
                Resource resource = (Resource)objectArray.nextElement();
                if (resource.isDirectory() || !this.match(resource.getName())) continue;
                vector.addElement(resource.getName());
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Arrays.sort(objectArray);
            return objectArray;
        }
        return super.getIncludedFiles();
    }

    @Override
    public String[] getIncludedDirectories() {
        if (this.srcFile != null) {
            Vector<String> vector = new Vector<String>();
            this.scanme();
            Object[] objectArray = this.myentries.elements();
            while (objectArray.hasMoreElements()) {
                Resource resource = (Resource)objectArray.nextElement();
                if (!resource.isDirectory() || !this.match(resource.getName())) continue;
                vector.addElement(resource.getName());
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Arrays.sort(objectArray);
            return objectArray;
        }
        return super.getIncludedDirectories();
    }

    public void init() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    public boolean match(String string) {
        String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this.isIncluded(string2) && !this.isExcluded(string2);
    }

    @Override
    public Resource getResource(String string) {
        if (this.srcFile == null) {
            return super.getResource(string);
        }
        if (string.equals("")) {
            return new Resource("", true, Long.MAX_VALUE, true);
        }
        this.scanme();
        if (this.myentries.containsKey(string)) {
            return (Resource)this.myentries.get(string);
        }
        if (this.myentries.containsKey(string + "/")) {
            return (Resource)this.myentries.get(string + "/");
        }
        return new Resource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanme() {
        Resource resource = new Resource(this.srcFile.getAbsolutePath(), this.srcFile.exists(), this.srcFile.lastModified());
        if (this.lastScannedResource != null && this.lastScannedResource.getName().equals(resource.getName()) && this.lastScannedResource.getLastModified() == resource.getLastModified()) {
            return;
        }
        ZipEntry zipEntry = null;
        ZipFile zipFile = null;
        this.myentries = new Hashtable();
        try {
            try {
                zipFile = new ZipFile(this.srcFile, this.encoding);
            }
            catch (ZipException zipException) {
                throw new BuildException("problem reading " + this.srcFile, zipException);
            }
            catch (IOException iOException) {
                throw new BuildException("problem opening " + this.srcFile, iOException);
            }
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                zipEntry = (ZipEntry)enumeration.nextElement();
                this.myentries.put(new String(zipEntry.getName()), new Resource(zipEntry.getName(), true, zipEntry.getTime(), zipEntry.isDirectory(), zipEntry.getSize()));
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.lastScannedResource = resource;
    }
}

