/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.apache.ant.taskdefs.condition;

import com.google.gwt.thirdparty.apache.ant.BuildException;
import java.util.Locale;

public class Os {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            if (string != null) {
                if (string.equals("windows")) {
                    bl2 = OS_NAME.indexOf("windows") > -1;
                } else if (string.equals("os/2")) {
                    bl2 = OS_NAME.indexOf("os/2") > -1;
                } else if (string.equals("netware")) {
                    bl2 = OS_NAME.indexOf("netware") > -1;
                } else if (string.equals("dos")) {
                    bl2 = PATH_SEP.equals(";") && !Os.isFamily("netware");
                } else if (string.equals("mac")) {
                    bl2 = OS_NAME.indexOf("mac") > -1;
                } else if (string.equals("tandem")) {
                    bl2 = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (string.equals("unix")) {
                    bl2 = PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x"));
                } else if (string.equals("win9x")) {
                    bl2 = Os.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (string.equals("z/os")) {
                    bl2 = OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (string.equals("os/400")) {
                    bl2 = OS_NAME.indexOf("os/400") > -1;
                } else if (string.equals("openvms")) {
                    bl2 = OS_NAME.indexOf("openvms") > -1;
                } else {
                    throw new BuildException("Don't know how to detect os family \"" + string + "\"");
                }
            }
            if (string2 != null) {
                bl3 = string2.equals(OS_NAME);
            }
            if (string3 != null) {
                bl4 = string3.equals(OS_ARCH);
            }
            if (string4 != null) {
                bl5 = string4.equals(OS_VERSION);
            }
            bl = bl2 && bl3 && bl4 && bl5;
        }
        return bl;
    }
}

