/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.soyc.io;

import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.core.linker.SoycReportLinker;
import com.google.gwt.soyc.io.OutputDirectory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ArtifactsOutputDirectory
implements OutputDirectory {
    public static final String COMPILE_REPORT_DIRECTORY = "compile-report";
    private List<SyntheticArtifact> artifacts = new ArrayList<SyntheticArtifact>();

    public List<SyntheticArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        return new OutputStreamForArtifact(path);
    }

    private class OutputStreamForArtifact
    extends OutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private boolean closed = false;
        private final String path;

        public OutputStreamForArtifact(String path) {
            this.path = path;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                SyntheticArtifact newArtifact = new SyntheticArtifact(SoycReportLinker.class, "compile-report/" + this.path, this.baos.toByteArray());
                newArtifact.setVisibility(EmittedArtifact.Visibility.Private);
                ArtifactsOutputDirectory.this.artifacts.add(newArtifact);
                this.baos = null;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.baos.write(b);
        }
    }
}

