/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.soyc;

import com.google.gwt.core.ext.linker.CompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.soyc.CodeCollection;
import com.google.gwt.soyc.GlobalInformation;
import com.google.gwt.soyc.LiteralsCollection;
import com.google.gwt.soyc.MakeTopLevelHtmlForPerm;
import com.google.gwt.soyc.SizeBreakdown;
import com.google.gwt.soyc.StaticResources;
import com.google.gwt.soyc.io.OutputDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoycDashboard {
    private GlobalInformation globalInformation;
    private MakeTopLevelHtmlForPerm makeTopLevelHtmlForPerm;
    private final OutputDirectory outDir;

    private static void foldInRPCHeuristic(HashMap<String, CodeCollection> nameToCodeColl) {
        if (nameToCodeColl.get((Object)"rpcGen").classes.size() == 0) {
            for (String className : nameToCodeColl.get((Object)"rpcUser").classes) {
                if (nameToCodeColl.get((Object)"widget").classes.contains(className) || nameToCodeColl.get((Object)"jre").classes.contains(className) || nameToCodeColl.get((Object)"gwtLang").classes.contains(className)) continue;
                nameToCodeColl.get((Object)"allOther").classes.add(className);
            }
            nameToCodeColl.get((Object)"rpcUser").classes.clear();
            for (String className : nameToCodeColl.get((Object)"rpcGwt").classes) {
                if (nameToCodeColl.get((Object)"widget").classes.contains(className) || nameToCodeColl.get((Object)"jre").classes.contains(className) || nameToCodeColl.get((Object)"gwtLang").classes.contains(className)) continue;
                nameToCodeColl.get((Object)"allOther").classes.add(className);
            }
            nameToCodeColl.get((Object)"rpcGwt").classes.clear();
        }
    }

    private static DefaultHandler parseXMLDocumentDependencies(final Map<String, Map<String, String>> allDependencies) {
        DefaultHandler handler = new DefaultHandler(){
            String curMethod;
            Map<String, String> dependencies = new TreeMap<String, String>();
            String graphExtends = null;
            StringBuilder valueBuilder = new StringBuilder();

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (localName.compareTo("table") == 0 && this.graphExtends != null) {
                    for (Map.Entry entry : ((Map)allDependencies.get(this.graphExtends)).entrySet()) {
                        this.dependencies.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }

            @Override
            public void startElement(String nsUri, String strippedName, String tagName, Attributes attributes) {
                this.valueBuilder.delete(0, this.valueBuilder.length());
                if (strippedName.compareTo("table") == 0 && attributes.getValue("name") != null) {
                    String name = attributes.getValue("name");
                    this.dependencies = new TreeMap<String, String>();
                    allDependencies.put(StringInterner.get().intern(name), this.dependencies);
                    if (attributes.getValue("extends") != null) {
                        this.graphExtends = StringInterner.get().intern(attributes.getValue("extends"));
                        if (!allDependencies.containsKey(this.graphExtends)) {
                            throw new FormatException("Graph " + name + " extends an unknown graph " + this.graphExtends);
                        }
                    } else {
                        this.graphExtends = null;
                    }
                } else if (strippedName.compareTo("method") == 0 && attributes.getValue("name") != null) {
                    this.curMethod = StringInterner.get().intern(attributes.getValue("name"));
                } else if (strippedName.compareTo("called") == 0 && attributes.getValue("by") != null) {
                    String curDepMethod = attributes.getValue("by");
                    if (!this.dependencies.containsKey(this.curMethod)) {
                        this.dependencies.put(StringInterner.get().intern(this.curMethod), StringInterner.get().intern(curDepMethod));
                    }
                }
            }
        };
        return handler;
    }

    public SoycDashboard(OutputDirectory outDir) {
        this.outDir = outDir;
    }

    public void generateCompilerMetricsForOnePermutation(ModuleMetricsArtifact moduleMetrics, PrecompilationMetricsArtifact precompilationMetrics, CompilationMetricsArtifact compilationMetrics) throws IOException {
        this.makeTopLevelHtmlForPerm.makeCompilerMetricsPermFiles(moduleMetrics, precompilationMetrics, compilationMetrics);
    }

    public void generateCrossPermutationFiles(Map<String, List<String>> permInfo) throws IOException {
        StaticResources.emit(this.outDir);
        MakeTopLevelHtmlForPerm.makeTopLevelHtmlForAllPerms(permInfo, this.outDir);
    }

    public void generateForOnePermutation() throws IOException {
        if (this.globalInformation.dependencies != null) {
            this.makeTopLevelHtmlForPerm.makeDependenciesHtml();
        }
        if (this.globalInformation.getNumFragments() > 0) {
            this.makeTopLevelHtmlForPerm.makeSplitStatusPages();
            this.makeTopLevelHtmlForPerm.makeLeftoverStatusPages();
        }
        for (SizeBreakdown breakdown : this.globalInformation.allSizeBreakdowns()) {
            MakeTopLevelHtmlForPerm.DependencyLinker linker = this.chooseDependencyLinker(breakdown);
            this.makeHTMLFiles(this.makeTopLevelHtmlForPerm, breakdown, linker);
        }
    }

    public void readDependencies(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        this.globalInformation.dependencies = new TreeMap<String, Map<String, String>>();
        DefaultHandler depHandler = SoycDashboard.parseXMLDocumentDependencies(this.globalInformation.dependencies);
        SAXParserFactory depFactoryMain = SAXParserFactory.newInstance();
        depFactoryMain.setNamespaceAware(true);
        SAXParser saxParser = depFactoryMain.newSAXParser();
        saxParser.parse(stream, depHandler);
    }

    public void readSizeMaps(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DefaultHandler handler = this.parseXMLDocumentSizeMap(this.globalInformation);
        SAXParserFactory factoryMain = SAXParserFactory.newInstance();
        factoryMain.setNamespaceAware(true);
        SAXParser saxParser = factoryMain.newSAXParser();
        saxParser.parse(stream, handler);
        this.globalInformation.computePackageSizes();
        for (SizeBreakdown breakdown : this.globalInformation.allSizeBreakdowns()) {
            this.updateAllOtherCodeType(breakdown.nameToCodeColl);
        }
        for (SizeBreakdown breakdown : this.globalInformation.allSizeBreakdowns()) {
            SoycDashboard.foldInRPCHeuristic(breakdown.nameToCodeColl);
        }
    }

    public void readSplitPoints(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DefaultHandler splitPointHandler = this.parseXMLDocumentSplitPoints();
        SAXParserFactory splitPointsFactoryMain = SAXParserFactory.newInstance();
        splitPointsFactoryMain.setNamespaceAware(true);
        SAXParser saxParser = splitPointsFactoryMain.newSAXParser();
        saxParser.parse(stream, splitPointHandler);
    }

    public void startNewPermutation(String permutationId) {
        this.globalInformation = new GlobalInformation(permutationId);
        this.makeTopLevelHtmlForPerm = new MakeTopLevelHtmlForPerm(this.globalInformation, this.outDir);
    }

    private Collection<SizeBreakdown> breakdownsForFragment(Integer fragment) {
        ArrayList<SizeBreakdown> breakdowns = new ArrayList<SizeBreakdown>();
        breakdowns.add(this.globalInformation.getTotalCodeBreakdown());
        if (fragment == 0) {
            breakdowns.add(this.globalInformation.getInitialCodeBreakdown());
        }
        if (fragment == this.globalInformation.getNumFragments() + 1) {
            breakdowns.add(this.globalInformation.getLeftoversBreakdown());
        }
        if (fragment >= 1 && fragment <= this.globalInformation.getNumFragments()) {
            breakdowns.add(this.globalInformation.fragmentCodeBreakdown(fragment));
        }
        return breakdowns;
    }

    private MakeTopLevelHtmlForPerm.DependencyLinker chooseDependencyLinker(SizeBreakdown breakdown) {
        if (this.globalInformation.dependencies == null) {
            return new MakeTopLevelHtmlForPerm.NullDependencyLinker();
        }
        if (breakdown == this.globalInformation.getTotalCodeBreakdown()) {
            if (this.globalInformation.getNumFragments() > 0) {
                return new MakeTopLevelHtmlForPerm.DependencyLinkerForTotalBreakdown(this.makeTopLevelHtmlForPerm);
            }
            return new MakeTopLevelHtmlForPerm.DependencyLinkerForInitialCode(this.makeTopLevelHtmlForPerm);
        }
        if (breakdown == this.globalInformation.getInitialCodeBreakdown()) {
            return new MakeTopLevelHtmlForPerm.DependencyLinkerForInitialCode(this.makeTopLevelHtmlForPerm);
        }
        if (breakdown == this.globalInformation.getLeftoversBreakdown()) {
            assert (this.globalInformation.getNumFragments() > 0);
            return new MakeTopLevelHtmlForPerm.DependencyLinkerForLeftoversFragment(this.makeTopLevelHtmlForPerm);
        }
        return new MakeTopLevelHtmlForPerm.NullDependencyLinker();
    }

    private void makeHTMLFiles(MakeTopLevelHtmlForPerm makeTopLevelHtmlForPerm, SizeBreakdown breakdown, MakeTopLevelHtmlForPerm.DependencyLinker depLinker) throws IOException {
        makeTopLevelHtmlForPerm.makePackageClassesHtmls(breakdown, depLinker);
        makeTopLevelHtmlForPerm.makeCodeTypeClassesHtmls(breakdown);
        makeTopLevelHtmlForPerm.makeLiteralsClassesTableHtmls(breakdown);
        makeTopLevelHtmlForPerm.makeBreakdownShell(breakdown);
        makeTopLevelHtmlForPerm.makeTopLevelShell();
    }

    private DefaultHandler parseXMLDocumentSizeMap(final GlobalInformation globalInformation) {
        return new DefaultHandler(){
            int fragment = -1;

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (localName.compareTo("sizemap") == 0) {
                    this.fragment = -1;
                }
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (localName.compareTo("sizemap") == 0) {
                    int size;
                    String fragString = attributes.getValue("fragment");
                    if (fragString == null) {
                        throw new FormatException();
                    }
                    try {
                        this.fragment = Integer.valueOf(fragString);
                    }
                    catch (NumberFormatException e) {
                        throw new FormatException(e);
                    }
                    String sizeString = attributes.getValue("size");
                    if (sizeString == null) {
                        throw new FormatException();
                    }
                    try {
                        size = Integer.valueOf(sizeString);
                    }
                    catch (NumberFormatException e) {
                        throw new FormatException(e);
                    }
                    for (SizeBreakdown breakdown : SoycDashboard.this.breakdownsForFragment(this.fragment)) {
                        breakdown.sizeAllCode += size;
                    }
                } else if (localName.compareTo("size") == 0) {
                    int size;
                    String type = attributes.getValue("type");
                    if (type == null) {
                        throw new FormatException();
                    }
                    String ref = attributes.getValue("ref");
                    if (ref == null) {
                        throw new FormatException();
                    }
                    String sizeString = attributes.getValue("size");
                    if (sizeString == null) {
                        throw new FormatException();
                    }
                    try {
                        size = Integer.valueOf(sizeString);
                    }
                    catch (NumberFormatException e) {
                        throw new FormatException(e);
                    }
                    this.recordSize(type, ref, size, globalInformation);
                }
            }

            private void accountForSize(SizeBreakdown breakdown, String refType, String ref, int size, GlobalInformation globalInformation2) {
                if (refType.equals("string")) {
                    LiteralsCollection stringLiterals = breakdown.nameToLitColl.get("string");
                    stringLiterals.size += size;
                    stringLiterals.literals.add(ref);
                } else if (!refType.equals("var")) {
                    String packageName;
                    String className;
                    if (!(refType.equals("type") || refType.equals("method") || refType.equals("field"))) {
                        throw new FormatException();
                    }
                    if (refType.equals("method")) {
                        breakdown.methodToSize.put(ref, size);
                    }
                    if ((className = ref).contains("::")) {
                        int idx = className.indexOf(58);
                        className = className.substring(0, idx);
                    }
                    className = StringInterner.get().intern(className);
                    if (!globalInformation2.getClassToPackage().containsKey(className)) {
                        packageName = className;
                        packageName = packageName.replaceAll("\\.[A-Z].*", "");
                        globalInformation2.getClassToPackage().put(className, packageName);
                    } else {
                        packageName = globalInformation2.getClassToPackage().get(className);
                    }
                    if (!globalInformation2.getPackageToClasses().containsKey(packageName)) {
                        TreeSet<String> insertSet = new TreeSet<String>();
                        insertSet.add(className);
                        globalInformation2.getPackageToClasses().put(packageName, insertSet);
                    } else {
                        globalInformation2.getPackageToClasses().get(packageName).add(className);
                    }
                    this.recordClassCategories(breakdown.nameToCodeColl, className, packageName);
                    if (breakdown.classToSize.containsKey(className)) {
                        int newSize = breakdown.classToSize.get(className) + size;
                        breakdown.classToSize.put(className, newSize);
                    } else {
                        breakdown.classToSize.put(className, size);
                    }
                }
            }

            private void recordClassCategories(HashMap<String, CodeCollection> nameToCodeColl, String className, String packageName) {
                if (packageName.startsWith("java")) {
                    nameToCodeColl.get((Object)"jre").classes.add(className);
                } else if (packageName.startsWith("com.google.gwt.lang")) {
                    nameToCodeColl.get((Object)"gwtLang").classes.add(className);
                }
                if (className.contains("_CustomFieldSerializer")) {
                    nameToCodeColl.get((Object)"rpcUser").classes.add(className);
                } else if (className.endsWith("_FieldSerializer") || className.endsWith("_Proxy") || className.endsWith("_TypeSerializer")) {
                    nameToCodeColl.get((Object)"rpcGen").classes.add(className);
                }
            }

            private void recordSize(String refType, String ref, int size, GlobalInformation globalInformation2) {
                refType = StringInterner.get().intern(refType);
                ref = StringInterner.get().intern(ref);
                for (SizeBreakdown breakdown : SoycDashboard.this.breakdownsForFragment(this.fragment)) {
                    this.accountForSize(breakdown, refType, ref, size, globalInformation2);
                }
            }
        };
    }

    private DefaultHandler parseXMLDocumentSplitPoints() {
        DefaultHandler handler = new DefaultHandler(){
            private boolean inInitialLoadSequence = false;

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (localName.compareTo("initialesq") == 0) {
                    this.inInitialLoadSequence = false;
                }
            }

            @Override
            public void startElement(String nsUri, String strippedName, String tagName, Attributes attributes) {
                if (strippedName.compareTo("splitpoint") == 0) {
                    this.parseSplitPoint(attributes);
                } else if (strippedName.compareTo("initialseq") == 0) {
                    this.inInitialLoadSequence = true;
                } else if (this.inInitialLoadSequence && strippedName.compareTo("splitpointref") == 0) {
                    SoycDashboard.this.globalInformation.getInitialFragmentLoadSequence().add(this.parseSplitPointReference(attributes));
                }
            }

            private void parseSplitPoint(Attributes attributes) {
                if (attributes.getValue("id") != null) {
                    String curSplitPoint = attributes.getValue("id");
                    if (attributes.getValue("location") != null) {
                        String curSplitPointLocation = attributes.getValue("location");
                        curSplitPointLocation = curSplitPointLocation.replaceAll("\\(L.*", "");
                        SoycDashboard.this.globalInformation.addFragmentDescriptor(Integer.parseInt(curSplitPoint), curSplitPointLocation);
                    }
                }
            }

            private Integer parseSplitPointReference(Attributes attributes) {
                String spString = attributes.getValue("id");
                if (spString == null) {
                    throw new FormatException("Could not parse split point reference");
                }
                return Integer.valueOf(spString);
            }
        };
        return handler;
    }

    private void updateAllOtherCodeType(HashMap<String, CodeCollection> nameToCodeColl) {
        for (String className : this.globalInformation.getClassToPackage().keySet()) {
            if (nameToCodeColl.get((Object)"widget").classes.contains(className) || nameToCodeColl.get((Object)"rpcUser").classes.contains(className) || nameToCodeColl.get((Object)"rpcGwt").classes.contains(className) || nameToCodeColl.get((Object)"rpcGen").classes.contains(className) || nameToCodeColl.get((Object)"jre").classes.contains(className) || nameToCodeColl.get((Object)"gwtLang").classes.contains(className)) continue;
            nameToCodeColl.get((Object)"allOther").classes.add(className);
        }
    }

    private static class FormatException
    extends RuntimeException {
        public FormatException() {
        }

        public FormatException(String message) {
            super(message);
        }

        public FormatException(Throwable cause) {
            super(cause);
        }
    }
}

