/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.soyc;

import com.google.gwt.core.ext.linker.CompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.core.ext.soyc.impl.SizeMapRecorder;
import com.google.gwt.dev.util.Util;
import com.google.gwt.soyc.CodeCollection;
import com.google.gwt.soyc.GlobalInformation;
import com.google.gwt.soyc.LiteralsCollection;
import com.google.gwt.soyc.SizeBreakdown;
import com.google.gwt.soyc.io.OutputDirectory;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MakeTopLevelHtmlForPerm {
    private static final int FRAGMENT_NUMBER_INITIAL_DOWNLOAD = 0;
    private static final int FRAGMENT_NUMBER_TOTAL_PROGRAM = -1;
    private static final Pattern PATTERN_SP_INT = Pattern.compile("sp([0-9]+)");
    private final GlobalInformation globalInformation;
    private final OutputDirectory outDir;

    public static void makeTopLevelHtmlForAllPerms(Map<String, List<String>> allPermsInfo, OutputDirectory outDir) throws IOException {
        PrintWriter outFile = new PrintWriter(outDir.getOutputStream("index.html"));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Compile report", "Compile report", "Overview of permutations");
        outFile.println("<ul>");
        TreeSet<Integer> sortedPermIds = new TreeSet<Integer>();
        for (String permutationId : allPermsInfo.keySet()) {
            sortedPermIds.add(Integer.parseInt(permutationId));
        }
        for (Integer sortedPermId : sortedPermIds) {
            String permutationId = Integer.toString(sortedPermId);
            List<String> permutationInfoList = allPermsInfo.get(permutationId);
            outFile.print("<li>Permutation " + permutationId);
            for (String desc : permutationInfoList) {
                outFile.println("  (" + desc + ")");
            }
            outFile.println("<ul>");
            outFile.println("<li>");
            outFile.println("<a href=\"SoycDashboard-" + permutationId + "-index.html\">Split Point Report</a>");
            outFile.println("</li>");
            outFile.println("<li>");
            outFile.println("<a href=\"CompilerMetrics-" + permutationId + "-index.html\">Compiler Metrics</a>");
            outFile.println("</li>");
            outFile.println("</ul>");
            outFile.println("</li>");
        }
        outFile.println("</ul>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    static String getClassSubstring(String fullMethodName) {
        if (fullMethodName.length() == 0) {
            return "";
        }
        int startIndex = MakeTopLevelHtmlForPerm.getPackageSubstring(fullMethodName).length() + 1;
        int endIndex = fullMethodName.indexOf("::");
        if (endIndex == -1) {
            endIndex = fullMethodName.length();
        }
        if (startIndex > endIndex || startIndex > fullMethodName.length()) {
            return "";
        }
        return fullMethodName.substring(startIndex, endIndex);
    }

    static String getMethodSubstring(String fullMethodName) {
        int index = fullMethodName.indexOf("::");
        if (index == -1) {
            return "";
        }
        if ((index += 2) >= fullMethodName.length()) {
            return "";
        }
        return fullMethodName.substring(index);
    }

    static String getPackageSubstring(String fullMethodName) {
        int endIndex = fullMethodName.lastIndexOf(46);
        if (endIndex == -1) {
            endIndex = fullMethodName.length();
        }
        return fullMethodName.substring(0, endIndex);
    }

    private static void addSmallHtmlProlog(PrintWriter outFile, String title) {
        outFile.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
        outFile.println("\"http://www.w3.org/TR/html4/strict.dtd\">");
        outFile.println("<html>");
        outFile.println("<head>");
        outFile.println("<title>");
        outFile.println(title);
        outFile.println("</title>");
        outFile.println("<style type=\"text/css\" media=\"screen\">");
        outFile.println("@import url('goog.css');");
        outFile.println("@import url('inlay.css');");
        outFile.println("@import url('soyc.css');");
        outFile.println("</style>");
        outFile.println("</head>");
    }

    private static void addStandardHtmlEnding(PrintWriter out) {
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
    }

    private static void addStandardHtmlProlog(PrintWriter outFile, String title, String header1, String header2) {
        outFile.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
        outFile.println("\"http://www.w3.org/TR/html4/strict.dtd\">");
        outFile.println("<html>");
        outFile.println("<head>");
        outFile.println("<script type=\"text/javascript\">");
        outFile.println("function show(elementName)");
        outFile.println("{");
        outFile.println("hp = document.getElementById(elementName);");
        outFile.println("hp.style.visibility = \"Visible\";");
        outFile.println("}");
        outFile.println("function hide(elementName)");
        outFile.println("{");
        outFile.println("hp = document.getElementById(elementName);");
        outFile.println("hp.style.visibility = \"Hidden\";");
        outFile.println("}");
        outFile.println("</script>");
        outFile.println("<title>");
        outFile.println(title);
        outFile.println("</title>");
        outFile.println("<style type=\"text/css\" media=\"screen\">");
        outFile.println("@import url('goog.css');");
        outFile.println("@import url('inlay.css');");
        outFile.println("@import url('soyc.css');");
        outFile.println("</style>");
        outFile.println("</head>");
        outFile.println("<body>");
        outFile.println("<div class=\"g-doc\">");
        outFile.println("<div id=\"hd\" class=\"g-section g-tpl-50-50 g-split\">");
        outFile.println("<div class=\"g-unit g-first\">");
        outFile.println("<p>");
        outFile.println("<a href=\"index.html\" id=\"gwt-logo\" class=\"soyc-ir\">");
        outFile.println("<span>Google Web Toolkit</span>");
        outFile.println("</a>");
        outFile.println("</p>");
        outFile.println("</div>");
        outFile.println("<div class=\"g-unit\">");
        outFile.println("</div>");
        outFile.println("</div>");
        outFile.println("<div id=\"soyc-appbar-lrg\">");
        outFile.println("<div class=\"g-section g-tpl-75-25 g-split\">");
        outFile.println("<div class=\"g-unit g-first\">");
        outFile.println("<h1>" + header1 + "</h1>");
        outFile.println("</div>");
        outFile.println("<div class=\"g-unit\"></div>");
        outFile.println("</div>");
        outFile.println("</div>");
        outFile.println("<div id=\"bd\">");
        if (header2 != null && header2.length() > 0) {
            outFile.println("<h2>" + header2 + "</h2>");
        }
    }

    private static String classesInPackageFileName(SizeBreakdown breakdown, String permutationId) {
        return breakdown.getId() + "_" + permutationId + "_Classes.html";
    }

    private String escapeJSString(String str) {
        return str.replaceAll("/", "\\/");
    }

    private static String escapeXml(String unescaped) {
        return SizeMapRecorder.escapeXml(unescaped);
    }

    private static String hashedFilenameFragment(String longFileName) {
        try {
            return Util.computeStrongName(longFileName.getBytes(Util.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String headerLineForBreakdown(SizeBreakdown breakdown) {
        return "(Analyzing code subset: " + breakdown.getDescription() + ")";
    }

    private static String shellFileName(SizeBreakdown breakdown, String permutationId) {
        return breakdown.getId() + "-" + permutationId + "-overallBreakdown.html";
    }

    MakeTopLevelHtmlForPerm(GlobalInformation globalInformation, OutputDirectory outDir) {
        this.globalInformation = globalInformation;
        this.outDir = outDir;
    }

    public void makeBreakdownShell(SizeBreakdown breakdown) throws IOException {
        HashMap<String, CodeCollection> nameToCodeColl = breakdown.nameToCodeColl;
        Map<String, LiteralsCollection> nameToLitColl = breakdown.nameToLitColl;
        String packageBreakdownFileName = this.makePackageHtml(breakdown);
        String codeTypeBreakdownFileName = this.makeCodeTypeHtml(breakdown, nameToCodeColl, nameToLitColl);
        PrintWriter outFile = new PrintWriter(this.getOutFile(MakeTopLevelHtmlForPerm.shellFileName(breakdown, this.getPermutationId())));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Application breakdown analysis", "Application breakdown analysis", "");
        String popupName = "packageBreakdownPopup";
        String popupTitle = "Package breakdown";
        String popupBody = "The package breakdown blames pieces of JavaScript code on Java packages wherever possible.  Note that this is not possible for all code, so the sizes of the packages here will not normally add up to the full code size.  More specifically, the sum will exclude strings, whitespace, and a few pieces of JavaScript code that are produced during compilation but cannot be attributed to any Java package.";
        outFile.println("<h2>");
        this.addPopupLink(outFile, popupName, popupTitle, null);
        outFile.println("</h2></div>");
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("<iframe class='soyc-iframe-package' src=\"" + packageBreakdownFileName + "\" scrolling=auto></iframe>");
        popupName = "codeTypeBreakdownPopup";
        popupTitle = "Code Type Breakdown";
        popupBody = "The code type breakdown breaks down the JavaScript code according to its type or function.  For example, it tells you how much of your code can be attributed to JRE, GWT-RPC, etc.  As above, strings and some other JavaScript snippets are not included in the breakdown.";
        outFile.println("<h2>");
        this.addPopupLink(outFile, popupName, popupTitle, null);
        outFile.println("</h2>");
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("<iframe class='soyc-iframe-code' src=\"" + codeTypeBreakdownFileName + "\" scrolling=auto></iframe>");
        outFile.println("</div>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    public void makeCodeTypeClassesHtmls(SizeBreakdown breakdown) throws IOException {
        HashMap<String, CodeCollection> nameToCodeColl = breakdown.nameToCodeColl;
        for (String codeType : nameToCodeColl.keySet()) {
            String outFileName = breakdown.getId() + "_" + codeType + "-" + this.getPermutationId() + "Classes.html";
            float sumSize = 0.0f;
            TreeMap sortedClasses = new TreeMap(Collections.reverseOrder());
            for (String className : nameToCodeColl.get((Object)codeType).classes) {
                if (!breakdown.classToSize.containsKey(className)) continue;
                int curSize = 0;
                if (breakdown.classToSize.containsKey(className)) {
                    curSize = breakdown.classToSize.get(className);
                }
                if (curSize == 0) continue;
                if (sortedClasses.containsKey(curSize)) {
                    Set existingSet = (Set)sortedClasses.get(curSize);
                    existingSet.add(className);
                    sortedClasses.put(curSize, existingSet);
                } else {
                    TreeSet<String> newSet = new TreeSet<String>();
                    newSet.add(className);
                    sortedClasses.put(curSize, newSet);
                }
                sumSize += (float)curSize;
            }
            PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
            MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Classes in package " + codeType, "Classes in package " + codeType, MakeTopLevelHtmlForPerm.headerLineForBreakdown(breakdown));
            outFile.println("<table class=\"soyc-table\">");
            outFile.println("<colgroup>");
            outFile.println("<col id=\"soyc-splitpoint-type-col\">");
            outFile.println("<col id=\"soyc-splitpoint-size-col\">");
            outFile.println("</colgroup>");
            outFile.println("<thead>");
            outFile.println("<th>Code type</th>");
            outFile.println("<th>");
            outFile.println("<th class=\"soyc-numerical-col-header\">");
            outFile.println("Size <span class=\"soyc-th-units\">(Bytes)</span>");
            outFile.println("</th>");
            outFile.println("<th class=\"soyc-numerical-col-header\">% of total</th>");
            outFile.println("</thead>");
            NumberFormat bytesFormatter = NumberFormat.getInstance();
            bytesFormatter.setGroupingUsed(true);
            NumberFormat percentFormatter = NumberFormat.getPercentInstance();
            percentFormatter.setMinimumFractionDigits(1);
            percentFormatter.setMaximumFractionDigits(1);
            for (Integer size : sortedClasses.keySet()) {
                Set classNames = (Set)sortedClasses.get(size);
                for (String className : classNames) {
                    float perc = (float)size.intValue() / sumSize;
                    outFile.println("<tr>");
                    outFile.println("<td>" + className + "</a></td>");
                    outFile.println("<td class=\"soyc-bargraph-col\">");
                    outFile.println("<div class=\"soyc-bar-graph goog-inline-block\">");
                    outFile.println("<div style=\"width:" + (double)perc * 100.0 + "%;\" class=\"soyc-bar-graph-fill goog-inline-block\"></div>");
                    outFile.println("</div>");
                    outFile.println("</td>");
                    outFile.println("<td class=\"soyc-numerical-col\">");
                    outFile.println(bytesFormatter.format(size));
                    outFile.println("</td>");
                    outFile.println("<td class=\"soyc-percent-col\">" + percentFormatter.format(perc) + "</td>");
                    outFile.println("</tr>");
                }
            }
            MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
            outFile.close();
        }
    }

    public void makeCompilerMetricsPermFiles(ModuleMetricsArtifact moduleMetrics, PrecompilationMetricsArtifact precompilationMetrics, CompilationMetricsArtifact compilationMetrics) throws IOException {
        String outFileName = "CompilerMetrics-" + precompilationMetrics.getPermutationBase() + "-index.html";
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Compiler Metrics for Permutation " + compilationMetrics.getPermutationId();
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "Build Time Metrics");
        NumberFormat elapsedFormatter = NumberFormat.getInstance();
        elapsedFormatter.setGroupingUsed(true);
        elapsedFormatter.setMinimumFractionDigits(3);
        elapsedFormatter.setMaximumFractionDigits(3);
        outFile.println("<div id=\"bd\">");
        int permutationId = compilationMetrics.getPermutationId();
        outFile.println("<table class=\"soyc-table\">");
        outFile.println("<colgroup>");
        outFile.println("<col id=\"soyc-buildTimePhase-col\">");
        outFile.println("<col id=\"soyc-buildTimeElapsed-col\">");
        outFile.println("</colgroup>");
        outFile.println("<thead>");
        outFile.println("<th>Phase</th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">Elapsed Time</th>");
        outFile.println("</thead>");
        outFile.println("<tr>");
        outFile.println("<td>");
        outFile.println("Module Analysis");
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">" + elapsedFormatter.format((double)moduleMetrics.getElapsedMilliseconds() / 1000.0) + " s");
        outFile.println("</td>");
        outFile.println("</tr>");
        outFile.println("<tr>");
        outFile.println("<td>");
        outFile.println("Precompile (may include Module Analysis)");
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">" + elapsedFormatter.format((double)precompilationMetrics.getElapsedMilliseconds() / 1000.0) + " s");
        outFile.println("</td>");
        outFile.println("</tr>");
        outFile.println("<tr>");
        outFile.println("<td>");
        outFile.println("Compile");
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">" + elapsedFormatter.format((double)compilationMetrics.getElapsedMilliseconds() / 1000.0) + " s");
        outFile.println("</td>");
        outFile.println("</tr>");
        outFile.println("</table>");
        NumberFormat referencesFormatter = NumberFormat.getInstance();
        referencesFormatter.setGroupingUsed(true);
        outFile.println("<p></p>");
        outFile.println("<h2>Source/Type Metrics</h2>");
        outFile.println("<table class=\"soyc-table\">");
        outFile.println("<colgroup>");
        outFile.println("<col id=\"soyc-typeList-col\">");
        outFile.println("<col id=\"soyc-typeReferences-col\">");
        outFile.println("</colgroup>");
        outFile.println("<thead>");
        outFile.println("<th>Description</th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">References</th>");
        outFile.println("</thead>");
        String sourcesFileName = "CompilerMetrics-sources.html";
        outFile.println("<tr>");
        outFile.println("<td>");
        String popupName = "compilerMetricsSourceFiles";
        String popupTitle = "Source files";
        String popupBody = "All source files on the module source path.";
        this.addPopupLink(outFile, popupName, popupTitle, sourcesFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(moduleMetrics.getSourceFiles().length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsSources(sourcesFileName, moduleMetrics, popupBody);
        String initialTypesFileName = "CompilerMetrics-initialTypes-" + permutationId + ".html";
        outFile.println("<tr>");
        outFile.println("<td>");
        popupName = "compilerMetricsInitialTypes";
        popupTitle = "Initial Type Oracle Types";
        popupBody = "All types in the type oracle after compiling sources on the source path.";
        this.addPopupLink(outFile, popupName, popupTitle, initialTypesFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(moduleMetrics.getInitialTypes().length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsInitialTypeOracleTypes(initialTypesFileName, moduleMetrics, popupBody);
        String finalTypesFileName = "CompilerMetrics-finalTypes-" + permutationId + ".html";
        outFile.println("<tr>");
        outFile.println("<td>");
        popupName = "compilerMetricsFinalTypes";
        popupTitle = "Final Type Oracle Types";
        popupBody = "All types in the type oracle after constructing the Java AST.";
        this.addPopupLink(outFile, popupName, popupTitle, finalTypesFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(precompilationMetrics.getFinalTypeOracleTypes().length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsFinalTypeOracleTypes(finalTypesFileName, precompilationMetrics, popupBody);
        String[] generatedTypes = this.getGeneratedTypes(moduleMetrics, precompilationMetrics);
        String generatedTypesFileName = "CompilerMetrics-generatedTypes-" + permutationId + ".html";
        outFile.println("<tr>");
        outFile.println("<td>");
        popupName = "compilerMetricsGeneratedTypes";
        popupTitle = "GeneratedTypes";
        popupBody = "Types that were added to the type oracle while running generators.";
        this.addPopupLink(outFile, popupName, popupTitle, generatedTypesFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(generatedTypes.length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsGeneratedTypes(generatedTypesFileName, generatedTypes, popupBody);
        String astFileName = "CompilerMetrics-ast-" + permutationId + ".html";
        outFile.println("<tr>");
        outFile.println("<td>");
        popupName = "compilerMetricsAstTypes";
        popupTitle = "AST Referenced Types";
        popupBody = "All types referenced by the Java AST after performing reachability analysis from the module EntryPoint.";
        this.addPopupLink(outFile, popupName, popupTitle, astFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(precompilationMetrics.getAstTypes().length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsAstTypes(astFileName, precompilationMetrics, popupBody);
        String[] unreferencedTypes = this.getUnreferencedTypes(precompilationMetrics);
        String unreferencedFileName = "CompilerMetrics-unreferencedTypes-" + permutationId + ".html";
        outFile.println("<tr>");
        outFile.println("<td>");
        popupName = "compilerMetricsUnreferenceTypes";
        popupTitle = "Unreferenced Types";
        popupBody = "Types that were on the initial source path but never referenced in the Java AST.";
        this.addPopupLink(outFile, popupName, popupTitle, unreferencedFileName);
        this.addPopup(outFile, popupName, popupTitle, popupBody);
        outFile.println("</td>");
        outFile.println("<td class=\"soyc-numerical-col\">");
        outFile.println(referencesFormatter.format(unreferencedTypes.length));
        outFile.println("</td>");
        outFile.println("</tr>");
        this.makeCompilerMetricsUnreferencedTypes(unreferencedFileName, unreferencedTypes, popupBody);
        outFile.println("</table>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    public void makeDependenciesHtml() throws IOException {
        for (String depGraphName : this.globalInformation.dependencies.keySet()) {
            this.makeDependenciesHtml(depGraphName, this.globalInformation.dependencies.get(depGraphName));
        }
    }

    public void makeLeftoverStatusPages() throws IOException {
        String packageName;
        PrintWriter outFile = new PrintWriter(this.getOutFile(this.leftoversStatusFileName()));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Leftovers page", "Leftovers page", "");
        outFile.println("<div id=\"bd\">");
        outFile.println("<p>These classes have some leftover code, neither initial nor exclusive to any split point:</p>");
        String curPackageName = "";
        HtmlInterner interner = new HtmlInterner();
        for (String className : this.globalInformation.getClassToPackage().keySet()) {
            packageName = this.globalInformation.getClassToPackage().get(className);
            interner.intern(packageName);
            interner.intern(MakeTopLevelHtmlForPerm.getClassSubstring(className));
            interner.intern(MakeTopLevelHtmlForPerm.hashedFilenameFragment(packageName));
        }
        interner.freeze();
        outFile.println("<script language=\"javascript\">");
        interner.printInternedDataAsJs(outFile);
        for (String className : this.globalInformation.getClassToPackage().keySet()) {
            packageName = this.globalInformation.getClassToPackage().get(className);
            if (packageName.compareTo("") == 0 || packageName.compareTo(curPackageName) != 0) {
                curPackageName = packageName;
                interner.printPackageHeader(outFile, packageName);
            }
            interner.printClassHeader(outFile, className);
            if (this.globalInformation.dependencies == null) continue;
            interner.printLeftoversStatus(outFile, packageName, className);
        }
        outFile.println("</script>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    public void makeLiteralsClassesTableHtmls(SizeBreakdown breakdown) throws IOException {
        Map<String, LiteralsCollection> nameToLitColl = breakdown.nameToLitColl;
        for (String literalType : nameToLitColl.keySet()) {
            String outFileName = literalType + "-" + this.getPermutationId() + "Lits.html";
            PrintWriter outFile = new PrintWriter(this.getOutFile(breakdown.getId() + "_" + outFileName));
            MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Literals of type " + literalType, "Literals of type " + literalType, MakeTopLevelHtmlForPerm.headerLineForBreakdown(breakdown));
            outFile.println("<table width=\"80%\" style=\"font-size: 11pt;\" bgcolor=\"white\">");
            for (String literal : nameToLitColl.get((Object)literalType).literals) {
                if (literal.trim().length() == 0) {
                    literal = "[whitespace only string]";
                }
                String escliteral = MakeTopLevelHtmlForPerm.escapeXml(literal);
                outFile.println("<tr>");
                outFile.println("<td>" + escliteral + "</td>");
                outFile.println("</tr>");
            }
            outFile.println("</table>");
            outFile.println("<center>");
            MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
            outFile.close();
        }
    }

    public void makePackageClassesHtmls(SizeBreakdown breakdown, DependencyLinker depLinker) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(MakeTopLevelHtmlForPerm.classesInPackageFileName(breakdown, this.getPermutationId())));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Classes in  " + breakdown.getDescription(), "Classes in " + breakdown.getDescription(), MakeTopLevelHtmlForPerm.headerLineForBreakdown(breakdown));
        Object[] packageNames = this.globalInformation.getPackageToClasses().keySet().toArray(new String[0]);
        Arrays.sort(packageNames);
        for (Object packageName : packageNames) {
            TreeMap sortedClasses = new TreeMap(Collections.reverseOrder());
            int sumSize = 0;
            for (String className : this.globalInformation.getPackageToClasses().get(packageName)) {
                int curSize = 0;
                if (breakdown.classToSize.containsKey(className)) {
                    curSize = breakdown.classToSize.get(className);
                }
                if ((float)curSize == 0.0f) continue;
                if (sortedClasses.containsKey(curSize)) {
                    Set existingSet = (Set)sortedClasses.get(curSize);
                    existingSet.add(className);
                    sortedClasses.put(curSize, existingSet);
                } else {
                    TreeSet<String> newSet = new TreeSet<String>();
                    newSet.add(className);
                    sortedClasses.put(curSize, newSet);
                }
                sumSize += curSize;
            }
            if (sortedClasses.size() <= 0) continue;
            outFile.println("<p>");
            outFile.println("<table class=\"soyc-table\">");
            outFile.print("<colgroup>");
            outFile.print("<col id=\"soyc-splitpoint-type-col\">");
            outFile.print("<col id=\"soyc-splitpoint-size-col\">");
            outFile.println("</colgroup>");
            outFile.print("<thead>");
            outFile.print("<a name=\"" + MakeTopLevelHtmlForPerm.hashedFilenameFragment((String)packageName) + "\"></a><th>Package: " + (String)packageName + "</th>");
            outFile.println("<th></th>");
            outFile.println("<th class=\"soyc-numerical-col-header\">");
            outFile.println("Size <span class=\"soyc-th-units\">(Bytes)</span>");
            outFile.println("</th>");
            outFile.println("<th class=\"soyc-numerical-col-header\">% of total</th>");
            outFile.print("</thead>");
            NumberFormat bytesFormatter = NumberFormat.getInstance();
            bytesFormatter.setGroupingUsed(true);
            NumberFormat percentFormatter = NumberFormat.getPercentInstance();
            percentFormatter.setMinimumFractionDigits(1);
            percentFormatter.setMaximumFractionDigits(1);
            for (Integer size : sortedClasses.keySet()) {
                Set classNames = (Set)sortedClasses.get(size);
                for (String className : classNames) {
                    String drillDownFileName = depLinker.dependencyLinkForClass(className);
                    float perc = (float)size.intValue() / (float)sumSize;
                    outFile.println("<tr>");
                    if (drillDownFileName == null) {
                        outFile.println("<td>" + className + "</td>");
                    } else {
                        outFile.println("<td><a href=\"" + drillDownFileName + "\" target=\"_top\">" + className + "</a></td>");
                    }
                    outFile.println("<td class=\"soyc-bargraph-col\">");
                    outFile.println("<div class=\"soyc-bar-graph goog-inline-block\">");
                    outFile.println("<div style=\"width:" + (double)perc * 100.0 + "%;\" class=\"soyc-bar-graph-fill goog-inline-block\"></div>");
                    outFile.println("</div>");
                    outFile.println("</td>");
                    outFile.println("<td class=\"soyc-numerical-col\">");
                    outFile.println(bytesFormatter.format(size));
                    outFile.println("</td>");
                    outFile.println("<td class=\"soyc-percent-col\">" + percentFormatter.format(perc) + "</td>");
                    outFile.println("</tr>");
                }
            }
            outFile.println("</table>");
            outFile.println("</p>");
        }
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    public void makeSplitStatusPages() throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(this.splitStatusFileName()));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Split point status", "Split point status", "");
        outFile.println("<div id=\"bd\">");
        HtmlInterner interner = new HtmlInterner();
        for (String className : this.globalInformation.getClassToPackage().keySet()) {
            String packageName = this.globalInformation.getClassToPackage().get(className);
            interner.intern(packageName);
            interner.intern(MakeTopLevelHtmlForPerm.getClassSubstring(className));
            interner.intern(MakeTopLevelHtmlForPerm.hashedFilenameFragment(packageName));
        }
        interner.freeze();
        outFile.println("<script language=\"javascript\">");
        interner.printInternedDataAsJs(outFile);
        String curPackageName = "";
        for (String className : this.globalInformation.getClassToPackage().keySet()) {
            String packageName = this.globalInformation.getClassToPackage().get(className);
            if (packageName.compareTo("") == 0 || packageName.compareTo(curPackageName) != 0) {
                curPackageName = packageName;
                interner.printPackageHeader(outFile, packageName);
            }
            interner.printClassHeader(outFile, className);
            if (this.globalInformation.getInitialCodeBreakdown().classToSize.containsKey(className)) {
                if (this.globalInformation.dependencies != null) {
                    interner.printHasInitialFragment(outFile, className);
                } else {
                    interner.printHasInitialFragment(outFile);
                }
            }
            for (int sp : this.splitPointsWithClass(className)) {
                interner.printHasCodeInSplitPoint(outFile, className, sp);
            }
            if (!this.globalInformation.getLeftoversBreakdown().classToSize.containsKey(className)) continue;
            interner.printSomeCodeLeftover(outFile);
            interner.printLeftoversStatus(outFile, packageName, className);
        }
        outFile.println("</script>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    public void makeTopLevelShell() throws IOException {
        String permutationId = this.getPermutationId();
        PrintWriter outFile = new PrintWriter(this.getOutFile("SoycDashboard-" + this.getPermutationId() + "-index.html"));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Compile report: Permutation " + permutationId, "Compile report: Permutation " + permutationId, "");
        NumberFormat bytesFormatter = NumberFormat.getInstance();
        bytesFormatter.setGroupingUsed(true);
        outFile.println("<div id=\"bd\">");
        outFile.println("<div id=\"soyc-summary\" class=\"g-section\">");
        outFile.println("<dl>");
        outFile.println("<dt>Full code size</dt>");
        outFile.println("<dd class=\"value\">" + bytesFormatter.format(this.globalInformation.getTotalCodeBreakdown().sizeAllCode) + " Bytes</dd>");
        outFile.println("<dd class=\"report\"><a href=\"total-" + permutationId + "-overallBreakdown.html\">Report</a></dd>");
        outFile.println("</dl>");
        outFile.println("<dl>");
        outFile.println("<dt>Initial download size</dt>");
        outFile.println("<dd class=\"value\">" + bytesFormatter.format(this.globalInformation.getInitialCodeBreakdown().sizeAllCode) + " Bytes</dd>");
        outFile.println("<dd class=\"report\"><a href=\"initial-" + permutationId + "-overallBreakdown.html\">Report</a></dd>");
        outFile.println("</dl>");
        outFile.println("<dl>");
        outFile.println("<dt>Left over code</dt>");
        outFile.println("<dd class=\"value\">" + bytesFormatter.format(this.globalInformation.getLeftoversBreakdown().sizeAllCode) + " Bytes</dd>");
        outFile.println("<dd class=\"report\"><a href=\"leftovers-" + permutationId + "-overallBreakdown.html\">Report</a></dd>");
        outFile.println("</dl>");
        outFile.println("</div>");
        outFile.println("<table id=\"soyc-table-splitpoints\" class=\"soyc-table\">");
        outFile.println("<caption>");
        outFile.println("<strong>Split Points</strong>");
        outFile.println("</caption>");
        outFile.println("<colgroup>");
        outFile.println("<col id=\"soyc-splitpoint-number-col\">");
        outFile.println("<col id=\"soyc-splitpoint-location-col\">");
        outFile.println("<col id=\"soyc-splitpoint-size-col\">");
        outFile.println("</colgroup>");
        outFile.println("<thead>");
        outFile.println("<th>#</th>");
        outFile.println("<th>Location</th>");
        outFile.println("<th></th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">");
        outFile.println("Size <span class=\"soyc-th-units\">(Bytes)</span>");
        outFile.println("</th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">% of total</th>");
        outFile.println("</thead>");
        outFile.println("<tbody>");
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        percentFormatter.setMinimumFractionDigits(1);
        percentFormatter.setMaximumFractionDigits(1);
        if (this.globalInformation.getNumFragments() >= 1) {
            int numFragments = this.globalInformation.getNumFragments();
            int maxSize = this.globalInformation.getTotalCodeBreakdown().sizeAllCode;
            for (int fragment = -1; fragment <= numFragments + 1; ++fragment) {
                if (fragment == -1 || fragment == numFragments + 1 || fragment == 0) continue;
                SizeBreakdown breakdown = this.globalInformation.fragmentCodeBreakdown(fragment);
                String drillDownFileName = MakeTopLevelHtmlForPerm.shellFileName(breakdown, this.getPermutationId());
                List<String> fragmentDescriptors = this.globalInformation.getFragmentDescriptors(fragment);
                Object[] escapedFragmentDescriptors = new String[fragmentDescriptors.size()];
                for (int i = 0; i < fragmentDescriptors.size(); ++i) {
                    escapedFragmentDescriptors[i] = MakeTopLevelHtmlForPerm.escapeXml(fragmentDescriptors.get(i));
                }
                String fragmentDescription = Joiner.on("<BR>").join(escapedFragmentDescriptors);
                int size = breakdown.sizeAllCode;
                float perc = (float)size / (float)maxSize;
                outFile.println("<tr>");
                outFile.println("<td>" + fragment + "</td>");
                outFile.print("<td><a href=\"" + drillDownFileName + "\">" + fragmentDescription + "</a></td>");
                outFile.println("<td class=\"soyc-bargraph-col\">");
                outFile.println("<div class=\"soyc-bar-graph goog-inline-block\">");
                outFile.println("<div style=\"width:" + (double)perc * 100.0 + "%;\" class=\"soyc-bar-graph-fill goog-inline-block\"></div>");
                outFile.println("</div>");
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-numerical-col\">");
                outFile.println(bytesFormatter.format(size));
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-percent-col\">" + percentFormatter.format(perc) + "</td>");
                outFile.println("</tr>");
            }
        }
        outFile.println("</tbody>");
        outFile.println("</table>");
        outFile.println("</div>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void addPopup(PrintWriter outFile, String popupName, String popupTitle, String popupBody) {
        outFile.println("<div class=\"soyc-popup\" id=\"" + popupName + "\">");
        outFile.println("<table>");
        outFile.println("<tr><th><b>" + popupTitle + "</b></th></tr>");
        outFile.println("<tr><td>" + popupBody + "</td></tr>");
        outFile.println("</table>");
        outFile.println("</div>");
    }

    private void addPopupLink(PrintWriter outFile, String popupName, String popupTitle, String href) {
        outFile.println("<a ");
        if (href != null) {
            outFile.println("href=\"" + href + "\"");
        }
        outFile.println("style=\"cursor:default;\" onMouseOver=\"show('" + popupName + "');\" onMouseOut=\"hide('" + popupName + "');\">" + popupTitle + "</a>");
    }

    private String dependenciesFileName(String depGraphName) {
        return "methodDependencies-" + depGraphName + "-" + this.getPermutationId() + ".html";
    }

    private String[] getGeneratedTypes(ModuleMetricsArtifact moduleMetrics, PrecompilationMetricsArtifact precompilationMetrics) {
        ArrayList<String> initialTypes = Lists.newArrayList(moduleMetrics.getInitialTypes());
        HashSet<String> generatedTypes = Sets.newHashSet(precompilationMetrics.getFinalTypeOracleTypes());
        generatedTypes.removeAll(initialTypes);
        Object[] results = generatedTypes.toArray(new String[generatedTypes.size()]);
        Arrays.sort(results);
        return results;
    }

    private OutputStream getOutFile(String localFileName) throws IOException {
        return this.outDir.getOutputStream(localFileName);
    }

    private String getPermutationId() {
        return this.globalInformation.getPermutationId();
    }

    private String[] getUnreferencedTypes(PrecompilationMetricsArtifact precompilationMetrics) {
        ArrayList<String> astTypes = Lists.newArrayList(precompilationMetrics.getAstTypes());
        HashSet<String> unreferencedTypes = Sets.newHashSet(precompilationMetrics.getFinalTypeOracleTypes());
        unreferencedTypes.removeAll(astTypes);
        Object[] results = unreferencedTypes.toArray(new String[unreferencedTypes.size()]);
        Arrays.sort(results);
        return results;
    }

    private String inferDepGraphDescription(String depGraphName) {
        if (depGraphName.equals("initial")) {
            return "Initially Live Code";
        }
        if (depGraphName.equals("total")) {
            return "All Code";
        }
        Matcher matcher = PATTERN_SP_INT.matcher(depGraphName);
        if (matcher.matches()) {
            int splitPoint = Integer.valueOf(matcher.group(1));
            if (this.isInitialSplitPoint(splitPoint)) {
                return "Code Becoming Live at Split Point " + splitPoint;
            }
            return "Code not Exclusive to Split Point " + splitPoint;
        }
        throw new RuntimeException("Unexpected dependency graph name: " + depGraphName);
    }

    private boolean isInitialSplitPoint(int splitPoint) {
        return this.globalInformation.getInitialFragmentLoadSequence().contains(splitPoint);
    }

    private String leftoversStatusFileName() {
        return "leftoverStatus-" + this.getPermutationId() + ".html";
    }

    private String makeCodeTypeHtml(SizeBreakdown breakdown, Map<String, CodeCollection> nameToCodeColl, Map<String, LiteralsCollection> nameToLitColl) throws IOException {
        String outFileName = breakdown.getId() + "-" + this.getPermutationId() + "-codeTypeBreakdown.html";
        int sumSize = 0;
        TreeMap sortedCodeTypes = new TreeMap(Collections.reverseOrder());
        for (String codeType : nameToCodeColl.keySet()) {
            int curSize = nameToCodeColl.get(codeType).getCumSize(breakdown);
            sumSize += curSize;
            if (curSize == 0) continue;
            if (sortedCodeTypes.containsKey(curSize)) {
                Set existingSet = (Set)sortedCodeTypes.get(curSize);
                existingSet.add(codeType);
                sortedCodeTypes.put(curSize, existingSet);
                continue;
            }
            TreeSet<String> newSet = new TreeSet<String>();
            newSet.add(codeType);
            sortedCodeTypes.put(curSize, newSet);
        }
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        MakeTopLevelHtmlForPerm.addSmallHtmlProlog(outFile, "Code breakdown");
        outFile.println("<body class=\"soyc-breakdown\">");
        outFile.println("<div class=\"g-doc\">");
        outFile.println("<table class=\"soyc-table\">");
        outFile.println("<colgroup>");
        outFile.println("<col id=\"soyc-splitpoint-type-col\">");
        outFile.println("<col id=\"soyc-splitpoint-size-col\">");
        outFile.println("</colgroup>");
        outFile.println("<thead>");
        outFile.println("<th>Type</th>");
        outFile.println("<th></th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">");
        outFile.println("Size <span class=\"soyc-th-units\">(Bytes)</span>");
        outFile.println("</th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">% of total</th>");
        outFile.println("</thead>");
        NumberFormat bytesFormatter = NumberFormat.getInstance();
        bytesFormatter.setGroupingUsed(true);
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        percentFormatter.setMinimumFractionDigits(1);
        percentFormatter.setMaximumFractionDigits(1);
        for (Integer size : sortedCodeTypes.keySet()) {
            Set codeTypes = (Set)sortedCodeTypes.get(size);
            for (String codeType : codeTypes) {
                String drillDownFileName = breakdown.getId() + "_" + codeType + "-" + this.getPermutationId() + "Classes.html";
                float perc = (float)size.intValue() / (float)sumSize;
                outFile.println("<tr>");
                outFile.println("<td><a href=\"" + drillDownFileName + "\" target=\"_top\">" + codeType + "</a></td>");
                outFile.println("<td class=\"soyc-bargraph-col\">");
                outFile.println("<div class=\"soyc-bar-graph goog-inline-block\">");
                outFile.println("<div style=\"width:" + (double)perc * 100.0 + "%;\" class=\"soyc-bar-graph-fill goog-inline-block\"></div>");
                outFile.println("</div>");
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-numerical-col\">");
                outFile.println(bytesFormatter.format(size));
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-percent-col\">" + percentFormatter.format(perc) + "</td>");
                outFile.println("</tr>");
            }
        }
        outFile.println("</table>");
        int stringSize = nameToLitColl.get((Object)"string").size;
        String drillDownFileName = breakdown.getId() + "_string-" + this.getPermutationId() + "Lits.html";
        outFile.println("<p class=\"soyc-breakdown-strings\">" + stringSize + " bytes occupied by <a href=\"" + drillDownFileName + "\" target=\"_top\">Strings</a></p>");
        int unaccountedForSize = breakdown.sizeAllCode - sumSize - stringSize;
        outFile.println("<p class=\"soyc-breakdown-strings\">" + unaccountedForSize + " bytes of the JavaScript output cannot be attributed to any package or code type.</p>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
        return outFileName;
    }

    private void makeCompilerMetricsAstTypes(String outFileName, PrecompilationMetricsArtifact precompilationMetrics, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "AST Types";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        Object[] types = precompilationMetrics.getAstTypes();
        Arrays.sort(types);
        for (Object type : types) {
            outFile.println((String)type);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void makeCompilerMetricsFinalTypeOracleTypes(String outFileName, PrecompilationMetricsArtifact precompilationMetrics, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Final Type Oracle Types";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        Object[] types = precompilationMetrics.getFinalTypeOracleTypes();
        Arrays.sort(types);
        for (Object type : types) {
            outFile.println((String)type);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void makeCompilerMetricsGeneratedTypes(String outFileName, String[] generatedTypes, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Generated Types";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        for (String type : generatedTypes) {
            outFile.println(type);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void makeCompilerMetricsInitialTypeOracleTypes(String outFileName, ModuleMetricsArtifact moduleMetrics, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Initial Type Oracle Types (built from source path)";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        Object[] types = moduleMetrics.getInitialTypes();
        Arrays.sort(types);
        for (Object type : types) {
            outFile.println((String)type);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void makeCompilerMetricsSources(String outFileName, ModuleMetricsArtifact moduleMetrics, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Sources on Source Path";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        Object[] sources = moduleMetrics.getSourceFiles();
        Arrays.sort(sources);
        for (Object source : sources) {
            outFile.println((String)source);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private void makeCompilerMetricsUnreferencedTypes(String outFileName, String[] unreferencedTypes, String helpText) throws IOException {
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        String title = "Unreferenced Types";
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, title, title, "");
        outFile.println("<p>");
        outFile.println(helpText);
        outFile.println("</p>");
        outFile.println("<pre>");
        for (String type : unreferencedTypes) {
            outFile.println(type);
        }
        outFile.println("</pre>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private static void internMethod(HtmlInterner interner, String method) {
        interner.intern(MakeTopLevelHtmlForPerm.getPackageSubstring(method));
        interner.intern(MakeTopLevelHtmlForPerm.getClassSubstring(method));
        interner.intern(MakeTopLevelHtmlForPerm.getMethodSubstring(method));
    }

    private void makeDependenciesHtml(String depGraphName, Map<String, String> dependencies) throws IOException {
        String curPackageName = "";
        HtmlInterner interner = new HtmlInterner();
        for (Map.Entry<String, String> dependencyEntry : dependencies.entrySet()) {
            MakeTopLevelHtmlForPerm.internMethod(interner, dependencyEntry.getKey());
            MakeTopLevelHtmlForPerm.internMethod(interner, dependencyEntry.getValue());
        }
        interner.freeze();
        String jsFileName = "methodDependencies-" + depGraphName + "-" + this.getPermutationId() + ".js";
        PrintWriter outFile = new PrintWriter(this.getOutFile(jsFileName));
        interner.printInternedDataAsJs(outFile);
        outFile.close();
        ArrayList<String> classesInPackage = new ArrayList<String>();
        for (String method : dependencies.keySet()) {
            classesInPackage.add(method);
        }
        this.makeDependenciesInternedHtml(depGraphName, classesInPackage, dependencies, interner, jsFileName);
    }

    private void makeDependenciesInternedHtml(String depGraphName, List<String> classesInSplitPoint, Map<String, String> dependencies, HtmlInterner interner, String jsFileName) throws IOException {
        String depGraphDescription = this.inferDepGraphDescription(depGraphName);
        PrintWriter outFile = null;
        String curClassName = "";
        String outFileName = this.dependenciesFileName(depGraphName);
        outFile = new PrintWriter(this.getOutFile(outFileName));
        MakeTopLevelHtmlForPerm.addStandardHtmlProlog(outFile, "Method Dependencies for " + depGraphDescription, "Method Dependencies for " + depGraphDescription, null);
        outFile.print("<script src=\"" + jsFileName + "\" language=\"javascript\" ></script>");
        outFile.print("<script>");
        for (String method : classesInSplitPoint) {
            String className = method.replaceAll("::.*", "");
            String depMethod = dependencies.get(method);
            if (curClassName.compareTo(className) != 0) {
                curClassName = className;
                if (method != classesInSplitPoint.get(0)) {
                    outFile.print("j();");
                }
                interner.printDependencyClassHeader(outFile, className);
            }
            interner.printDependency(outFile, dependencies, method, depMethod);
        }
        outFile.println("</script>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
    }

    private String makePackageHtml(SizeBreakdown breakdown) throws IOException {
        String outFileName = breakdown.getId() + "-" + this.getPermutationId() + "-packageBreakdown.html";
        Map<String, Integer> packageToPartialSize = breakdown.packageToSize;
        TreeMap sortedPackages = new TreeMap(Collections.reverseOrder());
        float sumSize = 0.0f;
        for (String packageName : packageToPartialSize.keySet()) {
            Integer curSize = packageToPartialSize.get(packageName);
            if (sortedPackages.containsKey(curSize)) {
                Set existingSet = (Set)sortedPackages.get(curSize);
                existingSet.add(packageName);
                sortedPackages.put(curSize, existingSet);
            } else {
                TreeSet<String> newSet = new TreeSet<String>();
                newSet.add(packageName);
                sortedPackages.put(curSize, newSet);
            }
            sumSize += (float)curSize.intValue();
        }
        PrintWriter outFile = new PrintWriter(this.getOutFile(outFileName));
        MakeTopLevelHtmlForPerm.addSmallHtmlProlog(outFile, "Package breakdown");
        outFile.println("<body class=\"soyc-breakdown\">");
        outFile.println("<div class=\"g-doc\">");
        outFile.println("<table class=\"soyc-table\">");
        outFile.println("<colgroup>");
        outFile.println("<col id=\"soyc-splitpoint-type-col\">");
        outFile.println("<col id=\"soyc-splitpoint-size-col\">");
        outFile.println("</colgroup>");
        outFile.println("<thead>");
        outFile.println("<th>Packages (Sorted by size)</th>");
        outFile.println("<th></th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">");
        outFile.println("Size <span class=\"soyc-th-units\">(Bytes)</span>");
        outFile.println("</th>");
        outFile.println("<th class=\"soyc-numerical-col-header\">% of total</th>");
        outFile.println("</thead>");
        NumberFormat bytesFormatter = NumberFormat.getInstance();
        bytesFormatter.setGroupingUsed(true);
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        percentFormatter.setMinimumFractionDigits(1);
        percentFormatter.setMaximumFractionDigits(1);
        Iterator iterator = sortedPackages.keySet().iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            if (size == 0) continue;
            Set packageNames = (Set)sortedPackages.get(size);
            for (String packageName : packageNames) {
                String drillDownFileName = MakeTopLevelHtmlForPerm.classesInPackageFileName(breakdown, this.getPermutationId()) + "#" + MakeTopLevelHtmlForPerm.hashedFilenameFragment(packageName);
                float perc = (float)size / sumSize;
                outFile.println("<tr>");
                outFile.println("<td><a href=\"" + drillDownFileName + "\" target=\"_top\">" + packageName + "</a></td>");
                outFile.println("<td class=\"soyc-bargraph-col\">");
                outFile.println("<div class=\"soyc-bar-graph goog-inline-block\">");
                outFile.println("<div style=\"width:" + (double)perc * 100.0 + "%;\" class=\"soyc-bar-graph-fill goog-inline-block\"></div>");
                outFile.println("</div>");
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-numerical-col\">");
                outFile.println(bytesFormatter.format(size));
                outFile.println("</td>");
                outFile.println("<td class=\"soyc-percent-col\">" + percentFormatter.format(perc) + "</td>");
                outFile.println("</tr>");
            }
        }
        outFile.println("</table>");
        MakeTopLevelHtmlForPerm.addStandardHtmlEnding(outFile);
        outFile.close();
        return outFileName;
    }

    private Iterable<Integer> splitPointsWithClass(String className) {
        ArrayList<Integer> sps = new ArrayList<Integer>();
        for (int sp = 1; sp <= this.globalInformation.getNumFragments(); ++sp) {
            Map<String, Integer> classToSize = this.globalInformation.fragmentCodeBreakdown((int)sp).classToSize;
            if (!classToSize.containsKey(className)) continue;
            sps.add(sp);
        }
        return sps;
    }

    private String splitStatusFileName() {
        return "splitStatus-" + this.getPermutationId() + ".html";
    }

    private class HtmlInterner {
        Map<String, Integer> builder = new HashMap<String, Integer>();
        Map<String, Integer> frozen = null;

        private HtmlInterner() {
        }

        public void freeze() {
            int maxDigits = 9;
            assert (this.frozen == null);
            assert ((double)this.builder.size() < Math.pow(10.0, 9.0));
            Object[] temp = new String[this.builder.size()];
            int index = 0;
            for (String key : this.builder.keySet()) {
                int n = index++;
                temp[n] = String.format("%09d%s", this.builder.get(key), key);
            }
            this.builder = null;
            Arrays.sort(temp);
            index = 0;
            this.frozen = new LinkedHashMap<String, Integer>();
            for (int i = temp.length - 1; i >= 0; --i) {
                this.frozen.put(((String)temp[i]).substring(9), index++);
            }
        }

        public void intern(String key) {
            if (this.builder == null) {
                throw new RuntimeException("freeze() already called.");
            }
            if (!this.builder.containsKey(key)) {
                this.builder.put(key, 1);
            } else {
                int value = this.builder.get(key) + 1;
                this.builder.put(key, value);
            }
        }

        public void printHasCodeInSplitPoint(PrintWriter outFile, String className, int sp) {
            outFile.print("h(" + this.frozen.get(MakeTopLevelHtmlForPerm.getPackageSubstring(className)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(className)) + "," + sp + ");");
        }

        public void printHasInitialFragment(PrintWriter outFile) {
            outFile.print("f();");
        }

        public void printHasInitialFragment(PrintWriter outFile, String className) {
            String packageName = MakeTopLevelHtmlForPerm.getPackageSubstring(className);
            outFile.print("g(" + this.frozen.get(packageName) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(className)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.hashedFilenameFragment(packageName)) + ");");
        }

        public void printSomeCodeLeftover(PrintWriter outFile) {
            outFile.print("i();");
        }

        private void printClassHeader(PrintWriter outFile, String className) {
            outFile.print("e(" + this.frozen.get(MakeTopLevelHtmlForPerm.getPackageSubstring(className)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(className)) + ",'" + MakeTopLevelHtmlForPerm.hashedFilenameFragment(className) + "');");
        }

        private void printDependency(PrintWriter outFile, Map<String, String> dependencies, String method, String depMethod) {
            String nameArray = this.methodDependencyString(method);
            outFile.print("b(" + nameArray + ",");
            outFile.print("[");
            HashSet<String> visited = Sets.newHashSet();
            String separator = "";
            while (depMethod != null) {
                String nextDep = dependencies.get(depMethod);
                if (nextDep != null) {
                    if (!visited.add(nextDep)) break;
                    outFile.print(separator);
                    outFile.print(this.methodDependencyString(depMethod));
                    separator = ",";
                }
                depMethod = nextDep;
            }
            outFile.print("]);");
        }

        private String methodDependencyString(String method) {
            return "[" + this.frozen.get(MakeTopLevelHtmlForPerm.getPackageSubstring(method)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(method)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getMethodSubstring(method)) + "]";
        }

        private void printDependencyClassHeader(PrintWriter outFile, String className) {
            outFile.print("a(" + this.frozen.get(MakeTopLevelHtmlForPerm.getPackageSubstring(className)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(className)) + ");");
        }

        private void printInternedDataAsJs(PrintWriter outFile) {
            if (this.frozen == null) {
                throw new RuntimeException("freeze() not called.");
            }
            outFile.println("  var internedStrings = [");
            for (String key : this.frozen.keySet()) {
                outFile.print("\"" + key + "\",");
            }
            outFile.println("];");
            outFile.println("  var spl = [");
            for (int fragment = 1; fragment <= MakeTopLevelHtmlForPerm.this.globalInformation.getNumFragments(); ++fragment) {
                List<String> fragmentDescriptors = MakeTopLevelHtmlForPerm.this.globalInformation.getFragmentDescriptors(fragment);
                Object[] escapedFragmentDescriptors = new String[fragmentDescriptors.size()];
                for (int i = 0; i < fragmentDescriptors.size(); ++i) {
                    escapedFragmentDescriptors[i] = MakeTopLevelHtmlForPerm.this.escapeJSString(fragmentDescriptors.get(i));
                }
                outFile.println("        '" + Joiner.on(",").join(escapedFragmentDescriptors) + "',");
            }
            outFile.println("  ];");
            outFile.println("  var methodSizes = {");
            for (SizeBreakdown breakdown : MakeTopLevelHtmlForPerm.this.globalInformation.allSizeBreakdowns()) {
                for (Map.Entry<String, Integer> methodEntry : breakdown.methodToSize.entrySet()) {
                    String methodSignature = methodEntry.getKey();
                    String method = methodSignature.substring(0, methodSignature.indexOf("("));
                    outFile.println("    \"" + method + "\" : " + methodEntry.getValue() + ",");
                }
            }
            outFile.println("};");
            outFile.println("  var images = {");
            outFile.println("    \"closed\" : \"images/play-g16.png\",");
            outFile.println("    \"open\" : \"images/play-g16-down.png\",");
            outFile.println("  };");
            outFile.println("  function a(packageRef, classRef) {");
            outFile.println("    var className = internedStrings[packageRef] + \".\" + internedStrings[classRef];");
            outFile.println("    document.write(\"<div class='main'>\");");
            outFile.println("    document.write(\"<table class='soyc-table'>\");");
            outFile.println("    document.write(\"<thead>\");");
            outFile.println("    document.write(\"<th><a class='soyc-class-name' name='\" + className + \"'>Class: \" + className + \"</a></th>\");");
            outFile.println("    document.write(\"<th class='soyc-numerical-col-header'>Size <span class='soyc-th-units'>(bytes)</span></th>\");");
            outFile.println("    document.write(\"</thead>\");");
            outFile.println("  }");
            outFile.println("  function swapShowHide(elementName) {");
            outFile.println("    hp = document.getElementById(elementName);");
            outFile.println("    arrow = document.getElementById(\"dropdown-\" + elementName);");
            outFile.println("    if (hp.style.display !== \"none\" && hp.style.display !== \"inline\") {");
            outFile.println("      hp.style.display = \"inline\";");
            outFile.println("      arrow.src = images[\"open\"];");
            outFile.println("    } else if (hp.style.display === \"none\") {");
            outFile.println("      hp.style.display = \"inline\";");
            outFile.println("      arrow.src = images[\"open\"];");
            outFile.println("    } else {");
            outFile.println("      hp.style.display = \"none\";");
            outFile.println("      arrow.src = images[\"closed\"];");
            outFile.println("    }");
            outFile.println("  }");
            outFile.println("  function b(c, deps) {");
            outFile.println("    var methodName = internedStrings[c[0]] + \".\" + internedStrings[c[1]] + \"::\" + internedStrings[c[2]];");
            outFile.println("    var methodSize = methodSizes[methodName];");
            outFile.println("    if (methodSize === undefined) methodSize = \"--\";");
            outFile.println("    var callstackId = \"callstack-\" + methodName;");
            outFile.println("    document.write(\"<tr>\");");
            outFile.println("    document.write(\"<td>\");");
            outFile.println("    document.write(\"<img onclick='swapShowHide(\\\"\" + callstackId + \"\\\")'id='dropdown-\" + callstackId + \"' class='dropdown-img' src=\" + images[\"closed\"] + \">\");");
            outFile.println("    document.write(\"<a class='toggle soyc-call-stack-link' onclick='swapShowHide(\\\"\" + callstackId + \"\\\")'>\" + methodName + \"</a>\");");
            outFile.println("    document.write(\"<ul id='\" + callstackId + \"' class='soyc-call-stack-list'>\");");
            outFile.println("    for (var i = 0; i < deps.length ; i++) {");
            outFile.println("      var s = deps[i];");
            outFile.println("      document.write(\"<li>\" + internedStrings[s[0]] + \".\" + internedStrings[s[1]] + \"::\" + internedStrings[s[2]] + \"</li>\");");
            outFile.println("    }");
            outFile.println("    document.write(\"</ul>\");");
            outFile.println("    document.write(\"</td>\");");
            outFile.println("    document.write(\"<td class='soyc-numerical-col'>\" + methodSize + \"</td>\");");
            outFile.println("    document.write(\"</tr>\");");
            outFile.println("  }");
            outFile.println("  function j() {");
            outFile.println("    document.write(\"</table></div>\");");
            outFile.println("  }");
            outFile.println("  function c(packageRef,classRef,packageHashRef) {");
            outFile.println("    var packageName = internedStrings[packageRef];");
            outFile.println("    var className = packageName + \".\" + internedStrings[classRef];");
            outFile.println("    var d1 = 'methodDependencies-total-" + MakeTopLevelHtmlForPerm.this.getPermutationId() + ".html';");
            outFile.println("    document.write(\"<ul class='soyc-excl'>\");");
            outFile.println("    document.write(\"<li><a href='\" + d1 + \"#\" + className + \"'>See why it's live</a></li>\");");
            outFile.println("    for (var sp = 1; sp <= " + MakeTopLevelHtmlForPerm.this.globalInformation.getNumFragments() + "; sp++) {");
            outFile.println("      var d2 = 'methodDependencies-sp' + sp + '-" + MakeTopLevelHtmlForPerm.this.getPermutationId() + ".html';");
            outFile.println("      document.write(\"<li><a href='\" + d2 + \"#\" + className +\"'> See why it's not exclusive to s.p. #\" + sp + \" (\" + spl[sp - 1] + \")</a></li>\");");
            outFile.println("    }");
            outFile.println("    document.write(\"</ul>\");");
            outFile.println("  }");
            outFile.println("  function d(packageRef) {");
            outFile.println("    document.write(\"<div class='soyc-pkg-break'>Package: \" + internedStrings[packageRef] + \"</div>\");");
            outFile.println("  }");
            outFile.println("  function e(packageRef,classRef,classHashRef) {");
            outFile.println("    document.write(\"<a name='\" + classHashRef + \"'></a><h3>\" + internedStrings[packageRef] + \".\" + internedStrings[classRef] + \"</h3>\");");
            outFile.println("  }");
            outFile.println("  function f() {");
            outFile.println("    document.write(\"<p>Some code is included in the initial fragment</p>\");");
            outFile.println("  }");
            outFile.println("  function g(packageRef, classRef, packageHashRef) {");
            outFile.println("    document.write(\"<p>Some code is included in the initial fragment (<a href='methodDependencies-initial-\" + internedStrings[packageHashRef] + \"-" + MakeTopLevelHtmlForPerm.this.getPermutationId() + ".html#\" + internedStrings[packageRef] + \".\" + internedStrings[classRef] + \"'> See why</a>)</p>\");");
            outFile.println("  }");
            outFile.println("  function h(packageRef, classRef, sp) {");
            outFile.println("    document.write(\"<p>Some code downloads with split point \" + sp + \": \" + spl[sp - 1] + \"</p>\");");
            outFile.println("  }");
            outFile.println("  function i() {");
            outFile.println("    document.write(\"<p>Some code is left over:</p>\");");
            outFile.println("  }");
        }

        private void printLeftoversStatus(PrintWriter outFile, String packageName, String className) {
            outFile.println("c(" + this.frozen.get(packageName) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.getClassSubstring(className)) + "," + this.frozen.get(MakeTopLevelHtmlForPerm.hashedFilenameFragment(packageName)) + ");");
        }

        private void printPackageHeader(PrintWriter outFile, String packageName) {
            outFile.print("d(" + this.frozen.get(packageName) + ");");
        }
    }

    static interface DependencyLinker {
        public String dependencyLinkForClass(String var1);
    }

    public static class NullDependencyLinker
    implements DependencyLinker {
        @Override
        public String dependencyLinkForClass(String className) {
            return null;
        }
    }

    public class DependencyLinkerForTotalBreakdown
    implements DependencyLinker {
        @Override
        public String dependencyLinkForClass(String className) {
            return MakeTopLevelHtmlForPerm.this.splitStatusFileName() + "#" + MakeTopLevelHtmlForPerm.hashedFilenameFragment(className);
        }
    }

    public class DependencyLinkerForLeftoversFragment
    implements DependencyLinker {
        @Override
        public String dependencyLinkForClass(String className) {
            return MakeTopLevelHtmlForPerm.this.leftoversStatusFileName() + "#" + MakeTopLevelHtmlForPerm.hashedFilenameFragment(className);
        }
    }

    public class DependencyLinkerForInitialCode
    implements DependencyLinker {
        @Override
        public String dependencyLinkForClass(String className) {
            String packageName = MakeTopLevelHtmlForPerm.this.globalInformation.getClassToPackage().get(className);
            assert (packageName != null);
            return MakeTopLevelHtmlForPerm.this.dependenciesFileName("initial") + "#" + className;
        }
    }
}

