/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.soyc;

import com.google.gwt.soyc.SizeBreakdown;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class GlobalInformation {
    private static final SizeBreakdown[] EMPTY_SIZE_BREAKDOWN = new SizeBreakdown[0];
    public Map<String, Map<String, String>> dependencies = null;
    private Map<String, String> classToPackage = new TreeMap<String, String>();
    private HashMap<String, HashSet<String>> classToWhatItDependsOn = new HashMap();
    private Map<Integer, SizeBreakdown> exclusiveCodeBreakdowns = new HashMap<Integer, SizeBreakdown>();
    private SizeBreakdown initialCodeBreakdown = new SizeBreakdown("Initially downloaded code", "initial");
    private SizeBreakdown leftoversBreakdown = new SizeBreakdown("Leftovers code, code not in any other fragment", "leftovers");
    private Map<String, TreeSet<String>> packageToClasses = new TreeMap<String, TreeSet<String>>();
    private final String permutationId;
    private ArrayList<Integer> initialFragmentLoadSequence = new ArrayList();
    private HashMap<Integer, List<String>> fragmentDescriptors = new HashMap();
    private SizeBreakdown totalCodeBreakdown = new SizeBreakdown("Total program", "total");

    public GlobalInformation(String permutationId) {
        this.permutationId = permutationId;
    }

    public SizeBreakdown[] allSizeBreakdowns() {
        ArrayList<SizeBreakdown> breakdowns = new ArrayList<SizeBreakdown>();
        breakdowns.add(this.totalCodeBreakdown);
        breakdowns.add(this.initialCodeBreakdown);
        if (this.getNumFragments() > 0) {
            breakdowns.add(this.leftoversBreakdown);
            for (int fragment = 1; fragment <= this.getNumFragments(); ++fragment) {
                breakdowns.add(this.fragmentCodeBreakdown(fragment));
            }
        }
        return breakdowns.toArray(EMPTY_SIZE_BREAKDOWN);
    }

    public void computePackageSizes() {
        for (SizeBreakdown breakdown : this.allSizeBreakdowns()) {
            this.computePackageSizes(breakdown.packageToSize, breakdown.classToSize);
        }
    }

    public final Map<String, String> getClassToPackage() {
        return this.classToPackage;
    }

    public final HashMap<String, HashSet<String>> getClassToWhatItDependsOn() {
        return this.classToWhatItDependsOn;
    }

    public final Map<Integer, SizeBreakdown> getExclusiveCodeBreakdowns() {
        return this.exclusiveCodeBreakdowns;
    }

    public final SizeBreakdown getInitialCodeBreakdown() {
        return this.initialCodeBreakdown;
    }

    public final SizeBreakdown getLeftoversBreakdown() {
        return this.leftoversBreakdown;
    }

    public final int getNumFragments() {
        return this.fragmentDescriptors.size();
    }

    public final Map<String, TreeSet<String>> getPackageToClasses() {
        return this.packageToClasses;
    }

    public String getPermutationId() {
        return this.permutationId;
    }

    public final ArrayList<Integer> getInitialFragmentLoadSequence() {
        return this.initialFragmentLoadSequence;
    }

    public final void addFragmentDescriptor(int fragment, String desc) {
        List<String> descriptions = this.fragmentDescriptors.get(fragment);
        if (descriptions == null) {
            descriptions = new ArrayList<String>();
            this.fragmentDescriptors.put(fragment, descriptions);
        }
        descriptions.add(desc);
    }

    public final List<String> getFragmentDescriptors(int fragment) {
        return this.fragmentDescriptors.get(fragment);
    }

    public final SizeBreakdown getTotalCodeBreakdown() {
        return this.totalCodeBreakdown;
    }

    public SizeBreakdown fragmentCodeBreakdown(int fragment) {
        assert (fragment >= 1 && fragment <= this.getNumFragments());
        if (!this.exclusiveCodeBreakdowns.containsKey(fragment)) {
            this.exclusiveCodeBreakdowns.put(fragment, new SizeBreakdown("split point " + fragment + ": " + this.fragmentDescriptors.get(fragment), "fragment" + fragment));
        }
        return this.exclusiveCodeBreakdowns.get(fragment);
    }

    private void computePackageSizes(Map<String, Integer> packageToSize, Map<String, Integer> classToSize) {
        packageToSize.clear();
        for (String packageName : this.packageToClasses.keySet()) {
            packageToSize.put(packageName, 0);
            for (String className : this.packageToClasses.get(packageName)) {
                if (!classToSize.containsKey(className)) continue;
                int curSize = classToSize.get(className);
                int newSize = curSize + packageToSize.get(packageName);
                packageToSize.put(packageName, newSize);
            }
        }
    }
}

