/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.soyc;

import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.CompilationMetricsArtifact;
import com.google.gwt.core.ext.linker.ModuleMetricsArtifact;
import com.google.gwt.core.ext.linker.PrecompilationMetricsArtifact;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public class CompilerMetricsXmlFormatter {
    public static final int XML_FORMAT_VERSION = 1;

    public static byte[] writeMetricsAsXml(ArtifactSet artifacts, ModuleMetricsArtifact moduleMetrics) {
        SortedSet<CompilationMetricsArtifact> compilationMetrics;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        pw.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        pw.append("<metrics version=\"1\" >\n");
        CompilerMetricsXmlFormatter.writeModuleMetricsAsXml(moduleMetrics, pw);
        SortedSet<PrecompilationMetricsArtifact> precompilationMetrics = artifacts.find(PrecompilationMetricsArtifact.class);
        if (!precompilationMetrics.isEmpty()) {
            pw.append(" <precompilations>\n");
            for (PrecompilationMetricsArtifact metrics : precompilationMetrics) {
                CompilerMetricsXmlFormatter.writePrecompilationMetricsAsXml(moduleMetrics, metrics, pw);
            }
            pw.append(" </precompilations>\n");
        }
        if (!(compilationMetrics = artifacts.find(CompilationMetricsArtifact.class)).isEmpty()) {
            pw.append(" <compilations>\n");
            for (CompilationMetricsArtifact metrics : compilationMetrics) {
                CompilerMetricsXmlFormatter.writeCompilationMetricsAsXml(metrics, pw);
            }
            pw.append(" </compilations>\n");
        }
        pw.append("</metrics>\n");
        pw.close();
        return out.toByteArray();
    }

    private static String escapeXmlAttributeContent(String content) {
        String result = content.replaceAll("'", "&apos;");
        return result.replaceAll("\"", "&quot;");
    }

    private static void writeCompilationMetricsAsXml(CompilationMetricsArtifact metrics, PrintWriter pw) {
        pw.append("  <compilation  id=\"" + metrics.getPermutationId() + "\" ");
        pw.append("elapsed=\"" + metrics.getCompileElapsedMilliseconds() + "\" ");
        pw.append("totalElapsed=\"" + metrics.getElapsedMilliseconds() + "\" ");
        String description = metrics.getPermutationDescription();
        if (description != null) {
            pw.append(" description=\"" + CompilerMetricsXmlFormatter.escapeXmlAttributeContent(description) + "\"");
        }
        pw.append(">\n");
        int[] jsSizes = metrics.getJsSize();
        if (jsSizes != null) {
            int totalSize = 0;
            int numFragments = 0;
            for (int size : jsSizes) {
                totalSize += size;
                ++numFragments;
            }
            pw.append("   <javascript size=\"" + totalSize + "\" fragments=\"" + numFragments + "\">\n");
            boolean initialFragment = true;
            for (int size : jsSizes) {
                pw.append("    <fragment ");
                if (initialFragment) {
                    pw.append("initial=\"true\" ");
                    initialFragment = false;
                }
                pw.append("size=\"" + size + "\" />\n");
            }
            pw.append("   </javascript>\n");
        }
        pw.append("  </compilation>\n");
    }

    private static void writeModuleMetricsAsXml(ModuleMetricsArtifact metrics, PrintWriter pw) {
        Object[] initialTypes;
        pw.append(" <module elapsed=\"" + metrics.getElapsedMilliseconds() + "\" ");
        pw.append(">\n");
        Object[] sourceFiles = metrics.getSourceFiles();
        if (sourceFiles != null) {
            Arrays.sort(sourceFiles);
            pw.append("  <sources count=\"" + sourceFiles.length + "\">\n");
            for (Object sourceFile : sourceFiles) {
                pw.append("   <source name=\"" + (String)sourceFile + "\" />\n");
            }
            pw.append("  </sources>\n");
        }
        if ((initialTypes = metrics.getInitialTypes()) != null) {
            Arrays.sort(initialTypes);
            pw.append("  <types kind=\"initial\" count=\"" + initialTypes.length + "\">\n");
            for (Object typeName : initialTypes) {
                pw.append("   <type name=\"" + (String)typeName + "\" />\n");
            }
            pw.append("  </types>\n");
        }
        pw.append(" </module>\n");
    }

    private static void writePrecompilationMetricsAsXml(ModuleMetricsArtifact moduleMetrics, PrecompilationMetricsArtifact metrics, PrintWriter pw) {
        String[] finalTypeOracleTypes;
        pw.append("  <precompilation ");
        pw.append("base=\"" + metrics.getPermutationBase() + "\" ");
        int[] permutationIds = metrics.getPermutationIds();
        if (permutationIds != null) {
            StringBuilder builder = new StringBuilder();
            for (int perm : permutationIds) {
                builder.append("" + perm + ",");
            }
            Object[] idList = builder.substring(0, builder.length() - 1);
            pw.append("ids=\"" + (String)idList + "\" ");
        }
        pw.append("elapsed=\"" + metrics.getElapsedMilliseconds() + "\" ");
        pw.append(">\n");
        Object[] astTypes = metrics.getAstTypes();
        if (astTypes != null) {
            Arrays.sort(astTypes);
            pw.append("   <types kind=\"ast\" count=\"" + astTypes.length + "\">\n");
            for (Object typeName : astTypes) {
                pw.append("    <type name=\"" + (String)typeName + "\" />\n");
            }
            pw.append("   </types>\n");
        }
        if ((finalTypeOracleTypes = metrics.getFinalTypeOracleTypes()) != null) {
            assert (finalTypeOracleTypes.length > 0);
            List<String> initialTypes = Lists.create(moduleMetrics.getInitialTypes());
            Set<String> generatedTypesList = Sets.create(finalTypeOracleTypes);
            generatedTypesList.removeAll(initialTypes);
            Object[] generatedTypes = generatedTypesList.toArray(new String[generatedTypesList.size()]);
            Arrays.sort(generatedTypes);
            pw.append("   <types kind=\"generated\" count=\"" + generatedTypes.length + "\">\n");
            for (Object typeName : generatedTypes) {
                pw.append("    <type name=\"" + (String)typeName + "\" />\n");
            }
            pw.append("   </types>\n");
        }
        pw.append(" </precompilation>\n");
    }

    private CompilerMetricsXmlFormatter() {
    }
}

